/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import kotlin.Function0;
import kotlin.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetImportDirective;
import org.jetbrains.kotlin.psi.JetImportsFactory;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProviderImpl;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.LazyFileScope;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;
import org.jetbrains.kotlin.storage.NotNullLazyValue;

public class ScopeProvider
implements DeclarationScopeProvider,
FileScopeProvider {
    private final ResolveSession resolveSession;
    private final NotNullLazyValue<Collection<JetImportDirective>> defaultImports;
    private final MemoizedFunctionToNotNull<JetFile, LazyFileScope> fileScopes;
    private AdditionalFileScopeProvider additionalFileScopeProvider;
    private DeclarationScopeProvider declarationScopeProvider;

    @Inject
    public void setAdditionalFileScopesProvider(@NotNull AdditionalFileScopeProvider additionalFileScopeProvider) {
        if (additionalFileScopeProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalFileScopeProvider", "org/jetbrains/kotlin/resolve/lazy/ScopeProvider", "setAdditionalFileScopesProvider"));
        }
        this.additionalFileScopeProvider = additionalFileScopeProvider;
    }

    @Inject
    public void setDeclarationScopeProvider(@NotNull DeclarationScopeProviderImpl declarationScopeProvider) {
        if (declarationScopeProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationScopeProvider", "org/jetbrains/kotlin/resolve/lazy/ScopeProvider", "setDeclarationScopeProvider"));
        }
        this.declarationScopeProvider = declarationScopeProvider;
    }

    public ScopeProvider(final @NotNull ResolveSession resolveSession) {
        if (resolveSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveSession", "org/jetbrains/kotlin/resolve/lazy/ScopeProvider", "<init>"));
        }
        this.resolveSession = resolveSession;
        this.defaultImports = resolveSession.getStorageManager().createLazyValue(new Function0<Collection<JetImportDirective>>(){

            @Override
            public Collection<JetImportDirective> invoke() {
                PackageViewDescriptor rootPackage = resolveSession.getModuleDescriptor().getPackage(FqName.ROOT);
                if (rootPackage == null) {
                    throw new IllegalStateException("Root package not found");
                }
                JetImportsFactory importsFactory = resolveSession.getJetImportsFactory();
                List<ImportPath> defaultImports = resolveSession.getModuleDescriptor().getDefaultImports();
                return importsFactory.createImportDirectives(defaultImports);
            }
        });
        this.fileScopes = resolveSession.getStorageManager().createMemoizedFunction(new Function1<JetFile, LazyFileScope>(){

            @Override
            public LazyFileScope invoke(JetFile file) {
                return ScopeProvider.this.createFileScope(file);
            }
        });
    }

    @Override
    @NotNull
    public LazyFileScope getFileScope(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/resolve/lazy/ScopeProvider", "getFileScope"));
        }
        LazyFileScope lazyFileScope = (LazyFileScope)this.fileScopes.invoke(file);
        if (lazyFileScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ScopeProvider", "getFileScope"));
        }
        return lazyFileScope;
    }

    private LazyFileScope createFileScope(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/resolve/lazy/ScopeProvider", "createFileScope"));
        }
        TemporaryBindingTrace tempTrace = TemporaryBindingTrace.create(this.resolveSession.getTrace(), "Transient trace for default imports lazy resolve");
        return LazyFileScope.OBJECT$.create(this.resolveSession, file, (Collection)this.defaultImports.invoke(), this.additionalFileScopeProvider.scopes(file), this.resolveSession.getTrace(), tempTrace, "LazyFileScope for file " + file.getName());
    }

    @Override
    @NotNull
    public JetScope getResolutionScopeForDeclaration(@NotNull PsiElement elementOfDeclaration) {
        if (elementOfDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementOfDeclaration", "org/jetbrains/kotlin/resolve/lazy/ScopeProvider", "getResolutionScopeForDeclaration"));
        }
        JetScope jetScope = this.declarationScopeProvider.getResolutionScopeForDeclaration(elementOfDeclaration);
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ScopeProvider", "getResolutionScopeForDeclaration"));
        }
        return jetScope;
    }

    @Override
    @NotNull
    public DataFlowInfo getOuterDataFlowInfoForDeclaration(@NotNull PsiElement elementOfDeclaration) {
        if (elementOfDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementOfDeclaration", "org/jetbrains/kotlin/resolve/lazy/ScopeProvider", "getOuterDataFlowInfoForDeclaration"));
        }
        DataFlowInfo dataFlowInfo = this.declarationScopeProvider.getOuterDataFlowInfoForDeclaration(elementOfDeclaration);
        if (dataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ScopeProvider", "getOuterDataFlowInfoForDeclaration"));
        }
        return dataFlowInfo;
    }

    public static class AdditionalFileScopeProvider {
        @NotNull
        public List<JetScope> scopes(@NotNull JetFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/resolve/lazy/ScopeProvider$AdditionalFileScopeProvider", "scopes"));
            }
            List<JetScope> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ScopeProvider$AdditionalFileScopeProvider", "scopes"));
            }
            return list;
        }
    }
}

