/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.types;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.org.objectweb.asm.Type;

public class PrimitiveTypesUtil {
    private PrimitiveTypesUtil() {
    }

    public static Type asmTypeForPrimitive(@NotNull JvmPrimitiveType jvmPrimitiveType) {
        if (jvmPrimitiveType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmPrimitiveType", "org/jetbrains/kotlin/resolve/jvm/types/PrimitiveTypesUtil", "asmTypeForPrimitive"));
        }
        switch (jvmPrimitiveType) {
            case BOOLEAN: {
                return Type.BOOLEAN_TYPE;
            }
            case CHAR: {
                return Type.CHAR_TYPE;
            }
            case BYTE: {
                return Type.BYTE_TYPE;
            }
            case SHORT: {
                return Type.SHORT_TYPE;
            }
            case INT: {
                return Type.INT_TYPE;
            }
            case FLOAT: {
                return Type.FLOAT_TYPE;
            }
            case LONG: {
                return Type.LONG_TYPE;
            }
            case DOUBLE: {
                return Type.DOUBLE_TYPE;
            }
        }
        throw new IllegalStateException("Unknown primitive type: " + (Object)((Object)jvmPrimitiveType));
    }
}

