/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.Type;

public class AsmTypes {
    private static final Map<Class<?>, Type> TYPES_MAP = new HashMap();
    public static final Type OBJECT_TYPE = AsmTypes.getType(Object.class);
    public static final Type JAVA_STRING_TYPE = AsmTypes.getType(String.class);
    public static final Type JAVA_THROWABLE_TYPE = AsmTypes.getType(Throwable.class);
    public static final Type UNIT_TYPE = Type.getObjectType("kotlin/Unit");
    public static final Type PROPERTY_METADATA_TYPE = Type.getObjectType("kotlin/PropertyMetadata");
    public static final Type PROPERTY_METADATA_IMPL_TYPE = Type.getObjectType("kotlin/PropertyMetadataImpl");
    public static final Type K_MEMBER_PROPERTY_TYPE = Type.getObjectType("kotlin/reflect/KMemberProperty");
    public static final Type K_MUTABLE_MEMBER_PROPERTY_TYPE = Type.getObjectType("kotlin/reflect/KMutableMemberProperty");
    public static final Type K_CLASS_IMPL_TYPE = AsmTypes.reflectInternal("KClassImpl");
    public static final Type K_PACKAGE_IMPL_TYPE = AsmTypes.reflectInternal("KPackageImpl");
    public static final Type K_TOP_LEVEL_VARIABLE_IMPL_TYPE = AsmTypes.reflectInternal("KTopLevelVariableImpl");
    public static final Type K_MUTABLE_TOP_LEVEL_VARIABLE_IMPL_TYPE = AsmTypes.reflectInternal("KMutableTopLevelVariableImpl");
    public static final Type K_TOP_LEVEL_EXTENSION_PROPERTY_IMPL_TYPE = AsmTypes.reflectInternal("KTopLevelExtensionPropertyImpl");
    public static final Type K_MUTABLE_TOP_LEVEL_EXTENSION_PROPERTY_IMPL_TYPE = AsmTypes.reflectInternal("KMutableTopLevelExtensionPropertyImpl");
    public static final String REFLECTION_INTERNAL_PACKAGE = AsmTypes.reflectInternal("InternalPackage").getInternalName();
    public static final String REF_TYPE_PREFIX = "kotlin/jvm/internal/Ref$";
    public static final Type OBJECT_REF_TYPE = Type.getObjectType("kotlin/jvm/internal/Ref$ObjectRef");

    @NotNull
    private static Type reflectInternal(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/kotlin/resolve/jvm/AsmTypes", "reflectInternal"));
        }
        Type type2 = Type.getObjectType("kotlin/reflect/jvm/internal/" + className);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/AsmTypes", "reflectInternal"));
        }
        return type2;
    }

    @NotNull
    public static Type getType(@NotNull Class<?> javaClass) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/kotlin/resolve/jvm/AsmTypes", "getType"));
        }
        Type type2 = TYPES_MAP.get(javaClass);
        if (type2 == null) {
            type2 = Type.getType(javaClass);
            TYPES_MAP.put(javaClass, type2);
        }
        Type type3 = type2;
        if (type3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/AsmTypes", "getType"));
        }
        return type3;
    }

    private AsmTypes() {
    }
}

