/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tasks;

import com.google.common.collect.Lists;
import java.util.Collection;
import kotlin.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckValueArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategyImpl;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.types.JetType;

public class ResolutionTask<D extends CallableDescriptor, F extends D>
extends CallResolutionContext<ResolutionTask<D, F>> {
    private final Function0<Collection<ResolutionCandidate<D>>> lazyCandidates;
    private final Collection<MutableResolvedCall<F>> resolvedCalls;
    public final TracingStrategy tracing;

    private ResolutionTask(@NotNull Function0<Collection<ResolutionCandidate<D>>> lazyCandidates2, @NotNull TracingStrategy tracing, @NotNull BindingTrace trace, @NotNull JetScope scope2, @NotNull Call call, @NotNull JetType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull ContextDependency contextDependency, @NotNull CheckValueArgumentsMode checkArguments, @NotNull ResolutionResultsCache resolutionResultsCache, @Nullable MutableDataFlowInfoForArguments dataFlowInfoForArguments, @NotNull CallChecker callChecker, @NotNull StatementFilter statementFilter, @NotNull Collection<MutableResolvedCall<F>> resolvedCalls, boolean isAnnotationContext, boolean collectAllCandidates) {
        if (lazyCandidates2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lazyCandidates", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (contextDependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextDependency", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (checkArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkArguments", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (resolutionResultsCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolutionResultsCache", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (callChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callChecker", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (statementFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statementFilter", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (resolvedCalls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCalls", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        super(trace, scope2, call, expectedType, dataFlowInfo, contextDependency, checkArguments, resolutionResultsCache, dataFlowInfoForArguments, callChecker, statementFilter, isAnnotationContext, collectAllCandidates);
        this.lazyCandidates = lazyCandidates2;
        this.resolvedCalls = resolvedCalls;
        this.tracing = tracing;
    }

    public ResolutionTask(@NotNull BasicCallResolutionContext context2, @NotNull TracingStrategy tracing, @NotNull Function0<Collection<ResolutionCandidate<D>>> lazyCandidates2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (lazyCandidates2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lazyCandidates", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        this(lazyCandidates2, tracing, context2.trace, context2.scope, context2.call, context2.expectedType, context2.dataFlowInfo, context2.contextDependency, context2.checkArguments, context2.resolutionResultsCache, context2.dataFlowInfoForArguments, context2.callChecker, context2.statementFilter, Lists.newArrayList(), context2.isAnnotationContext, context2.collectAllCandidates);
    }

    public ResolutionTask(final @NotNull Collection<ResolutionCandidate<D>> candidates, @NotNull JetReferenceExpression reference, @NotNull BasicCallResolutionContext context2) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "<init>"));
        }
        this(context2, TracingStrategyImpl.create(reference, context2.call), new Function0<Collection<ResolutionCandidate<D>>>(){

            @Override
            public Collection<ResolutionCandidate<D>> invoke() {
                return candidates;
            }
        });
    }

    @NotNull
    public Collection<ResolutionCandidate<D>> getCandidates() {
        Collection<ResolutionCandidate<D>> collection = this.lazyCandidates.invoke();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "getCandidates"));
        }
        return collection;
    }

    public void addResolvedCall(@NotNull MutableResolvedCall<F> resolvedCall) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "addResolvedCall"));
        }
        this.resolvedCalls.add(resolvedCall);
    }

    @NotNull
    public Collection<MutableResolvedCall<F>> getResolvedCalls() {
        Collection<MutableResolvedCall<F>> collection = this.resolvedCalls;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "getResolvedCalls"));
        }
        return collection;
    }

    @Override
    protected ResolutionTask<D, F> create(@NotNull BindingTrace trace, @NotNull JetScope scope2, @NotNull DataFlowInfo dataFlowInfo, @NotNull JetType expectedType, @NotNull ContextDependency contextDependency, @NotNull ResolutionResultsCache resolutionResultsCache, @NotNull StatementFilter statementFilter, boolean collectAllCandidates) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "create"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "create"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "create"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "create"));
        }
        if (contextDependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextDependency", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "create"));
        }
        if (resolutionResultsCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolutionResultsCache", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "create"));
        }
        if (statementFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statementFilter", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "create"));
        }
        return new ResolutionTask<D, F>(this.lazyCandidates, this.tracing, trace, scope2, this.call, expectedType, dataFlowInfo, contextDependency, this.checkArguments, resolutionResultsCache, this.dataFlowInfoForArguments, this.callChecker, statementFilter, this.resolvedCalls, this.isAnnotationContext, collectAllCandidates);
    }

    public ResolutionTask<D, F> replaceContext(@NotNull BasicCallResolutionContext newContext) {
        if (newContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newContext", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "replaceContext"));
        }
        return new ResolutionTask<D, F>(newContext, this.tracing, this.lazyCandidates);
    }

    public ResolutionTask<D, F> replaceCall(@NotNull Call newCall) {
        if (newCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newCall", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask", "replaceCall"));
        }
        return new ResolutionTask<D, F>(this.lazyCandidates, this.tracing, this.trace, this.scope, newCall, this.expectedType, this.dataFlowInfo, this.contextDependency, this.checkArguments, this.resolutionResultsCache, this.dataFlowInfoForArguments, this.callChecker, this.statementFilter, this.resolvedCalls, this.isAnnotationContext, this.collectAllCandidates);
    }

    public String toString() {
        return this.lazyCandidates.toString();
    }

    public static interface DescriptorCheckStrategy {
        public <D extends CallableDescriptor> boolean performAdvancedChecks(D var1, BindingTrace var2, TracingStrategy var3);
    }
}

