/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.smartcasts;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ThisReceiver;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

public class SmartCastUtils {
    private SmartCastUtils() {
    }

    @NotNull
    public static List<JetType> getSmartCastVariants(@NotNull ReceiverValue receiverToCast, @NotNull ResolutionContext context2) {
        if (receiverToCast == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverToCast", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "getSmartCastVariants"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "getSmartCastVariants"));
        }
        List<JetType> list = SmartCastUtils.getSmartCastVariants(receiverToCast, context2.trace.getBindingContext(), context2.dataFlowInfo);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "getSmartCastVariants"));
        }
        return list;
    }

    @NotNull
    public static List<JetType> getSmartCastVariants(@NotNull ReceiverValue receiverToCast, @NotNull BindingContext bindingContext, @NotNull DataFlowInfo dataFlowInfo) {
        if (receiverToCast == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverToCast", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "getSmartCastVariants"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "getSmartCastVariants"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "getSmartCastVariants"));
        }
        ArrayList<JetType> variants = Lists.newArrayList();
        variants.add(receiverToCast.getType());
        variants.addAll(SmartCastUtils.getSmartCastVariantsExcludingReceiver(bindingContext, dataFlowInfo, receiverToCast));
        ArrayList<JetType> arrayList = variants;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "getSmartCastVariants"));
        }
        return arrayList;
    }

    @NotNull
    public static List<JetType> getSmartCastVariantsWithLessSpecificExcluded(@NotNull ReceiverValue receiverToCast, @NotNull BindingContext bindingContext, @NotNull DataFlowInfo dataFlowInfo) {
        if (receiverToCast == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverToCast", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "getSmartCastVariantsWithLessSpecificExcluded"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "getSmartCastVariantsWithLessSpecificExcluded"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "getSmartCastVariantsWithLessSpecificExcluded"));
        }
        final List<JetType> variants = SmartCastUtils.getSmartCastVariants(receiverToCast, bindingContext, dataFlowInfo);
        List<JetType> list = KotlinPackage.filter(variants, new Function1<JetType, Boolean>(){

            @Override
            public Boolean invoke(final JetType type2) {
                return !KotlinPackage.any(variants, new Function1<JetType, Boolean>(){

                    @Override
                    public Boolean invoke(JetType another) {
                        return another != type2 && JetTypeChecker.DEFAULT.isSubtypeOf(another, type2);
                    }
                });
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "getSmartCastVariantsWithLessSpecificExcluded"));
        }
        return list;
    }

    @NotNull
    public static Collection<JetType> getSmartCastVariantsExcludingReceiver(@NotNull BindingContext bindingContext, @NotNull DataFlowInfo dataFlowInfo, @NotNull ReceiverValue receiverToCast) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "getSmartCastVariantsExcludingReceiver"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "getSmartCastVariantsExcludingReceiver"));
        }
        if (receiverToCast == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverToCast", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "getSmartCastVariantsExcludingReceiver"));
        }
        if (receiverToCast instanceof ThisReceiver) {
            ThisReceiver receiver = (ThisReceiver)receiverToCast;
            assert (receiver.exists());
            DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(receiver);
            Set<JetType> set = dataFlowInfo.getPossibleTypes(dataFlowValue);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "getSmartCastVariantsExcludingReceiver"));
            }
            return set;
        }
        if (receiverToCast instanceof ExpressionReceiver) {
            DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(receiverToCast, bindingContext);
            Set<JetType> set = dataFlowInfo.getPossibleTypes(dataFlowValue);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "getSmartCastVariantsExcludingReceiver"));
            }
            return set;
        }
        List<JetType> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "getSmartCastVariantsExcludingReceiver"));
        }
        return list;
    }

    public static boolean isSubTypeBySmartCastIgnoringNullability(@NotNull ReceiverValue receiverArgument, @NotNull JetType receiverParameterType, @NotNull ResolutionContext context2) {
        if (receiverArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverArgument", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "isSubTypeBySmartCastIgnoringNullability"));
        }
        if (receiverParameterType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverParameterType", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "isSubTypeBySmartCastIgnoringNullability"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "isSubTypeBySmartCastIgnoringNullability"));
        }
        List<JetType> smartCastTypes = SmartCastUtils.getSmartCastVariants(receiverArgument, context2);
        return SmartCastUtils.getSmartCastSubType(TypeUtils.makeNullable(receiverParameterType), smartCastTypes) != null;
    }

    @Nullable
    private static JetType getSmartCastSubType(@NotNull JetType receiverParameterType, @NotNull Collection<JetType> smartCastTypes) {
        if (receiverParameterType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverParameterType", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "getSmartCastSubType"));
        }
        if (smartCastTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "smartCastTypes", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "getSmartCastSubType"));
        }
        HashSet<JetType> subTypes = Sets.newHashSet();
        for (JetType smartCastType : smartCastTypes) {
            if (!ArgumentTypeResolver.isSubtypeOfForArgumentType(smartCastType, receiverParameterType)) continue;
            subTypes.add(smartCastType);
        }
        if (subTypes.isEmpty()) {
            return null;
        }
        JetType intersection = TypeUtils.intersect(JetTypeChecker.DEFAULT, subTypes);
        if (intersection == null || !intersection.getConstructor().isDenotable()) {
            return receiverParameterType;
        }
        return intersection;
    }

    public static boolean recordSmartCastIfNecessary(@NotNull ReceiverValue receiver, @NotNull JetType receiverParameterType, @NotNull ResolutionContext context2, boolean safeAccess) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "recordSmartCastIfNecessary"));
        }
        if (receiverParameterType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverParameterType", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "recordSmartCastIfNecessary"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "recordSmartCastIfNecessary"));
        }
        if (!(receiver instanceof ExpressionReceiver)) {
            return false;
        }
        JetType jetType = receiverParameterType = safeAccess ? TypeUtils.makeNullable(receiverParameterType) : receiverParameterType;
        if (ArgumentTypeResolver.isSubtypeOfForArgumentType(receiver.getType(), receiverParameterType)) {
            return false;
        }
        Collection<JetType> smartCastTypesExcludingReceiver = SmartCastUtils.getSmartCastVariantsExcludingReceiver(context2.trace.getBindingContext(), context2.dataFlowInfo, receiver);
        JetType smartCastSubType = SmartCastUtils.getSmartCastSubType(receiverParameterType, smartCastTypesExcludingReceiver);
        if (smartCastSubType == null) {
            return false;
        }
        JetExpression expression = ((ExpressionReceiver)receiver).getExpression();
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(receiver, context2.trace.getBindingContext());
        SmartCastUtils.recordCastOrError(expression, smartCastSubType, context2.trace, dataFlowValue.isStableIdentifier(), true);
        return true;
    }

    public static void recordCastOrError(@NotNull JetExpression expression, @NotNull JetType type2, @NotNull BindingTrace trace, boolean canBeCast, boolean recordExpressionType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "recordCastOrError"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "recordCastOrError"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "recordCastOrError"));
        }
        if (canBeCast) {
            trace.record(BindingContext.SMARTCAST, expression, type2);
            if (recordExpressionType) {
                trace.record(BindingContext.EXPRESSION_TYPE, expression, type2);
            }
        } else {
            trace.report(Errors.SMARTCAST_IMPOSSIBLE.on(expression, type2, expression.getText()));
        }
    }

    public static boolean canBeSmartCast(@NotNull ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiver, @NotNull BindingContext bindingContext, @NotNull DataFlowInfo dataFlowInfo) {
        if (receiverParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverParameter", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "canBeSmartCast"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "canBeSmartCast"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "canBeSmartCast"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastUtils", "canBeSmartCast"));
        }
        if (!receiver.getType().isMarkedNullable()) {
            return true;
        }
        List<JetType> smartCastVariants = SmartCastUtils.getSmartCastVariants(receiver, bindingContext, dataFlowInfo);
        for (JetType smartCastVariant : smartCastVariants) {
            if (!JetTypeChecker.DEFAULT.isSubtypeOf(smartCastVariant, receiverParameter.getType())) continue;
            return true;
        }
        return false;
    }
}

