/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetConstantExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetTypeProjection;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.ResolvePackage;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallResolverUtil;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckValueArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.JetTypeInfo;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;

public class ArgumentTypeResolver {
    private TypeResolver typeResolver;
    private ExpressionTypingServices expressionTypingServices;
    private KotlinBuiltIns builtIns;

    @Inject
    public void setTypeResolver(@NotNull TypeResolver typeResolver) {
        if (typeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeResolver", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "setTypeResolver"));
        }
        this.typeResolver = typeResolver;
    }

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "setExpressionTypingServices"));
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    @Inject
    public void setBuiltIns(@NotNull KotlinBuiltIns builtIns) {
        if (builtIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builtIns", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "setBuiltIns"));
        }
        this.builtIns = builtIns;
    }

    public static boolean isSubtypeOfForArgumentType(@NotNull JetType actualType, @NotNull JetType expectedType) {
        if (actualType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actualType", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "isSubtypeOfForArgumentType"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "isSubtypeOfForArgumentType"));
        }
        if (actualType == TypeUtils.PLACEHOLDER_FUNCTION_TYPE) {
            return ArgumentTypeResolver.isFunctionOrErrorType(expectedType) || KotlinBuiltIns.isAnyOrNullableAny(expectedType);
        }
        return JetTypeChecker.DEFAULT.isSubtypeOf(actualType, expectedType);
    }

    private static boolean isFunctionOrErrorType(@NotNull JetType supertype) {
        if (supertype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertype", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "isFunctionOrErrorType"));
        }
        return KotlinBuiltIns.isFunctionOrExtensionFunctionType(supertype) || supertype.isError();
    }

    public void checkTypesWithNoCallee(@NotNull CallResolutionContext<?> context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "checkTypesWithNoCallee"));
        }
        this.checkTypesWithNoCallee(context2, CallResolverUtil.ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
    }

    public void checkTypesWithNoCallee(@NotNull CallResolutionContext<?> context2, @NotNull CallResolverUtil.ResolveArgumentsMode resolveFunctionArgumentBodies) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "checkTypesWithNoCallee"));
        }
        if (resolveFunctionArgumentBodies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveFunctionArgumentBodies", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "checkTypesWithNoCallee"));
        }
        if (context2.checkArguments == CheckValueArgumentsMode.DISABLED) {
            return;
        }
        for (ValueArgument valueArgument : context2.call.getValueArguments()) {
            JetExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null || argumentExpression instanceof JetFunctionLiteralExpression) continue;
            this.checkArgumentTypeWithNoCallee(context2, argumentExpression);
        }
        if (resolveFunctionArgumentBodies == CallResolverUtil.ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS) {
            this.checkTypesForFunctionArgumentsWithNoCallee(context2);
        }
        for (JetTypeProjection jetTypeProjection : context2.call.getTypeArguments()) {
            JetTypeReference typeReference = jetTypeProjection.getTypeReference();
            if (typeReference == null) {
                context2.trace.report(Errors.PROJECTION_ON_NON_CLASS_TYPE_ARGUMENT.on(jetTypeProjection));
                continue;
            }
            this.typeResolver.resolveType(context2.scope, typeReference, context2.trace, true);
        }
    }

    public void checkTypesForFunctionArgumentsWithNoCallee(@NotNull CallResolutionContext<?> context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "checkTypesForFunctionArgumentsWithNoCallee"));
        }
        if (context2.checkArguments == CheckValueArgumentsMode.DISABLED) {
            return;
        }
        for (ValueArgument valueArgument : context2.call.getValueArguments()) {
            JetExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null || !ArgumentTypeResolver.isFunctionLiteralArgument(argumentExpression, context2)) continue;
            this.checkArgumentTypeWithNoCallee(context2, argumentExpression);
        }
    }

    private void checkArgumentTypeWithNoCallee(CallResolutionContext<?> context2, JetExpression argumentExpression) {
        this.expressionTypingServices.getTypeInfo(argumentExpression, (ResolutionContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
        ArgumentTypeResolver.updateResultArgumentTypeIfNotDenotable(context2, argumentExpression);
    }

    public static boolean isFunctionLiteralArgument(@NotNull JetExpression expression, @NotNull ResolutionContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "isFunctionLiteralArgument"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "isFunctionLiteralArgument"));
        }
        return ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression, context2) != null;
    }

    @NotNull
    public static JetFunctionLiteralExpression getFunctionLiteralArgument(@NotNull JetExpression expression, @NotNull ResolutionContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralArgument"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralArgument"));
        }
        assert (ArgumentTypeResolver.isFunctionLiteralArgument(expression, context2));
        JetFunctionLiteralExpression jetFunctionLiteralExpression = ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression, context2);
        if (jetFunctionLiteralExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralArgument"));
        }
        return jetFunctionLiteralExpression;
    }

    @Nullable
    private static JetFunctionLiteralExpression getFunctionLiteralArgumentIfAny(@NotNull JetExpression expression, @NotNull ResolutionContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralArgumentIfAny"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralArgumentIfAny"));
        }
        JetExpression deparenthesizedExpression = ArgumentTypeResolver.getLastElementDeparenthesized(expression, context2);
        if (deparenthesizedExpression instanceof JetFunctionLiteralExpression) {
            return (JetFunctionLiteralExpression)deparenthesizedExpression;
        }
        return null;
    }

    @Nullable
    public static JetExpression getLastElementDeparenthesized(@Nullable JetExpression expression, @NotNull ResolutionContext context2) {
        JetBlockExpression blockExpression;
        JetElement lastStatementInABlock;
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getLastElementDeparenthesized"));
        }
        JetExpression deparenthesizedExpression = JetPsiUtil.deparenthesize(expression, false);
        if (deparenthesizedExpression instanceof JetBlockExpression && (lastStatementInABlock = ResolvePackage.getLastStatementInABlock(context2.statementFilter, blockExpression = (JetBlockExpression)deparenthesizedExpression)) instanceof JetExpression) {
            return ArgumentTypeResolver.getLastElementDeparenthesized((JetExpression)lastStatementInABlock, context2);
        }
        return deparenthesizedExpression;
    }

    @NotNull
    public JetTypeInfo getArgumentTypeInfo(@Nullable JetExpression expression, @NotNull CallResolutionContext<?> context2, @NotNull CallResolverUtil.ResolveArgumentsMode resolveArgumentsMode) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getArgumentTypeInfo"));
        }
        if (resolveArgumentsMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveArgumentsMode", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getArgumentTypeInfo"));
        }
        if (expression == null) {
            JetTypeInfo jetTypeInfo = JetTypeInfo.create(null, context2.dataFlowInfo);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getArgumentTypeInfo"));
            }
            return jetTypeInfo;
        }
        if (ArgumentTypeResolver.isFunctionLiteralArgument(expression, context2)) {
            JetTypeInfo jetTypeInfo = this.getFunctionLiteralTypeInfo(expression, ArgumentTypeResolver.getFunctionLiteralArgument(expression, context2), context2, resolveArgumentsMode);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getArgumentTypeInfo"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo recordedTypeInfo = BindingContextUtils.getRecordedTypeInfo(expression, context2.trace.getBindingContext());
        if (recordedTypeInfo != null) {
            JetTypeInfo jetTypeInfo = recordedTypeInfo;
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getArgumentTypeInfo"));
            }
            return jetTypeInfo;
        }
        Object newContext = ((CallResolutionContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.DEPENDENT);
        JetTypeInfo jetTypeInfo = this.expressionTypingServices.getTypeInfo(expression, (ResolutionContext)newContext);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getArgumentTypeInfo"));
        }
        return jetTypeInfo;
    }

    @NotNull
    public JetTypeInfo getFunctionLiteralTypeInfo(@NotNull JetExpression expression, @NotNull JetFunctionLiteralExpression functionLiteralExpression, @NotNull CallResolutionContext<?> context2, @NotNull CallResolverUtil.ResolveArgumentsMode resolveArgumentsMode) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralTypeInfo"));
        }
        if (functionLiteralExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionLiteralExpression", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralTypeInfo"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralTypeInfo"));
        }
        if (resolveArgumentsMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveArgumentsMode", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralTypeInfo"));
        }
        if (resolveArgumentsMode == CallResolverUtil.ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS) {
            JetType type2 = this.getShapeTypeOfFunctionLiteral(functionLiteralExpression, context2.scope, context2.trace, true);
            JetTypeInfo jetTypeInfo = JetTypeInfo.create(type2, context2.dataFlowInfo);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralTypeInfo"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo jetTypeInfo = this.expressionTypingServices.getTypeInfo(expression, (ResolutionContext)context2.replaceContextDependency(ContextDependency.INDEPENDENT));
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralTypeInfo"));
        }
        return jetTypeInfo;
    }

    @Nullable
    public JetType getShapeTypeOfFunctionLiteral(@NotNull JetFunctionLiteralExpression expression, @NotNull JetScope scope2, @NotNull BindingTrace trace, boolean expectedTypeIsUnknown) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getShapeTypeOfFunctionLiteral"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getShapeTypeOfFunctionLiteral"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getShapeTypeOfFunctionLiteral"));
        }
        if (expression.getFunctionLiteral().getValueParameterList() == null) {
            return expectedTypeIsUnknown ? TypeUtils.PLACEHOLDER_FUNCTION_TYPE : this.builtIns.getFunctionType(Annotations.EMPTY, null, Collections.<JetType>emptyList(), TypeUtils.DONT_CARE);
        }
        List<JetParameter> valueParameters = expression.getValueParameters();
        TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(trace, "trace to resolve function literal parameter types");
        ArrayList<JetType> parameterTypes = Lists.newArrayList();
        for (JetParameter parameter : valueParameters) {
            parameterTypes.add(this.resolveTypeRefWithDefault(parameter.getTypeReference(), scope2, temporaryTrace, TypeUtils.DONT_CARE));
        }
        JetFunctionLiteral functionLiteral = expression.getFunctionLiteral();
        JetType returnType = this.resolveTypeRefWithDefault(functionLiteral.getTypeReference(), scope2, temporaryTrace, TypeUtils.DONT_CARE);
        assert (returnType != null);
        JetType receiverType = this.resolveTypeRefWithDefault(functionLiteral.getReceiverTypeReference(), scope2, temporaryTrace, null);
        return this.builtIns.getFunctionType(Annotations.EMPTY, receiverType, parameterTypes, returnType);
    }

    @Nullable
    public JetType resolveTypeRefWithDefault(@Nullable JetTypeReference returnTypeRef, @NotNull JetScope scope2, @NotNull BindingTrace trace, @Nullable JetType defaultValue) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "resolveTypeRefWithDefault"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "resolveTypeRefWithDefault"));
        }
        if (returnTypeRef != null) {
            return this.expressionTypingServices.getTypeResolver().resolveType(scope2, returnTypeRef, trace, true);
        }
        return defaultValue;
    }

    public void analyzeArgumentsAndRecordTypes(@NotNull CallResolutionContext<?> context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "analyzeArgumentsAndRecordTypes"));
        }
        MutableDataFlowInfoForArguments infoForArguments = context2.dataFlowInfoForArguments;
        infoForArguments.setInitialDataFlowInfo(context2.dataFlowInfo);
        for (ValueArgument valueArgument : context2.call.getValueArguments()) {
            JetExpression expression = valueArgument.getArgumentExpression();
            if (expression == null) continue;
            CallResolutionContext newContext = (CallResolutionContext)context2.replaceDataFlowInfo(infoForArguments.getInfo(valueArgument));
            JetTypeInfo typeInfoForCall = this.getArgumentTypeInfo(expression, newContext, CallResolverUtil.ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
            infoForArguments.updateInfo(valueArgument, typeInfoForCall.getDataFlowInfo());
        }
    }

    @Nullable
    public static JetType updateResultArgumentTypeIfNotDenotable(@NotNull ResolutionContext context2, @NotNull JetExpression expression) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "updateResultArgumentTypeIfNotDenotable"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "updateResultArgumentTypeIfNotDenotable"));
        }
        JetType type2 = context2.trace.get(BindingContext.EXPRESSION_TYPE, expression);
        if (type2 != null && !type2.getConstructor().isDenotable() && type2.getConstructor() instanceof IntegerValueTypeConstructor) {
            IntegerValueTypeConstructor constructor2 = (IntegerValueTypeConstructor)type2.getConstructor();
            JetType primitiveType = TypeUtils.getPrimitiveNumberType(constructor2, context2.expectedType);
            ArgumentTypeResolver.updateNumberType(primitiveType, expression, context2);
            return primitiveType;
        }
        return type2;
    }

    public static void updateNumberType(@NotNull JetType numberType, @Nullable JetExpression expression, @NotNull ResolutionContext context2) {
        if (numberType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "numberType", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "updateNumberType"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "updateNumberType"));
        }
        if (expression == null) {
            return;
        }
        BindingContextUtils.updateRecordedType(numberType, expression, context2.trace, false);
        if (!(expression instanceof JetConstantExpression)) {
            JetExpression deparenthesized = ArgumentTypeResolver.getLastElementDeparenthesized(expression, context2);
            if (deparenthesized != expression) {
                ArgumentTypeResolver.updateNumberType(numberType, deparenthesized, context2);
            }
            return;
        }
        ConstantExpressionEvaluator.OBJECT$.evaluate(expression, context2.trace, numberType);
    }
}

