/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationsImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetTypeParameter;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CompositeChecker;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.SimpleResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotationDescriptor;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotationsContextImpl;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

public class AnnotationResolver {
    private CallResolver callResolver;
    private StorageManager storageManager;
    private TypeResolver typeResolver;

    @Inject
    public void setCallResolver(CallResolver callResolver) {
        this.callResolver = callResolver;
    }

    @Inject
    public void setStorageManager(StorageManager storageManager) {
        this.storageManager = storageManager;
    }

    @Inject
    public void setTypeResolver(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    @NotNull
    public Annotations resolveAnnotationsWithoutArguments(@NotNull JetScope scope2, @Nullable JetModifierList modifierList, @NotNull BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationsWithoutArguments"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationsWithoutArguments"));
        }
        Annotations annotations2 = this.resolveAnnotations(scope2, modifierList, trace, false);
        if (annotations2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationsWithoutArguments"));
        }
        return annotations2;
    }

    @NotNull
    public Annotations resolveAnnotationsWithArguments(@NotNull JetScope scope2, @Nullable JetModifierList modifierList, @NotNull BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationsWithArguments"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationsWithArguments"));
        }
        Annotations annotations2 = this.resolveAnnotations(scope2, modifierList, trace, true);
        if (annotations2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationsWithArguments"));
        }
        return annotations2;
    }

    @NotNull
    public Annotations resolveAnnotationsWithArguments(@NotNull JetScope scope2, @NotNull List<JetAnnotationEntry> annotationEntries, @NotNull BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationsWithArguments"));
        }
        if (annotationEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationEntries", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationsWithArguments"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationsWithArguments"));
        }
        Annotations annotations2 = this.resolveAnnotationEntries(scope2, annotationEntries, trace, true);
        if (annotations2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationsWithArguments"));
        }
        return annotations2;
    }

    private Annotations resolveAnnotations(@NotNull JetScope scope2, @Nullable JetModifierList modifierList, @NotNull BindingTrace trace, boolean shouldResolveArguments) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotations"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotations"));
        }
        if (modifierList == null) {
            return Annotations.EMPTY;
        }
        List<JetAnnotationEntry> annotationEntryElements = modifierList.getAnnotationEntries();
        return this.resolveAnnotationEntries(scope2, annotationEntryElements, trace, shouldResolveArguments);
    }

    private Annotations resolveAnnotationEntries(@NotNull JetScope scope2, @NotNull List<JetAnnotationEntry> annotationEntryElements, @NotNull BindingTrace trace, boolean shouldResolveArguments) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationEntries"));
        }
        if (annotationEntryElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationEntryElements", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationEntries"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationEntries"));
        }
        if (annotationEntryElements.isEmpty()) {
            return Annotations.EMPTY;
        }
        ArrayList<AnnotationDescriptor> result2 = Lists.newArrayList();
        for (JetAnnotationEntry entryElement : annotationEntryElements) {
            AnnotationDescriptor descriptor = trace.get(BindingContext.ANNOTATION, entryElement);
            if (descriptor == null) {
                descriptor = new LazyAnnotationDescriptor(new LazyAnnotationsContextImpl(this, this.storageManager, trace, scope2), entryElement);
            }
            if (shouldResolveArguments) {
                AnnotationResolver.resolveAnnotationArguments(entryElement, trace);
            }
            result2.add(descriptor);
        }
        return new AnnotationsImpl(result2);
    }

    @NotNull
    public JetType resolveAnnotationType(@NotNull JetScope scope2, @NotNull JetAnnotationEntry entryElement) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationType"));
        }
        if (entryElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryElement", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationType"));
        }
        JetTypeReference typeReference = entryElement.getTypeReference();
        if (typeReference == null) {
            JetType jetType = ErrorUtils.createErrorType("No type reference: " + entryElement.getText());
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationType"));
            }
            return jetType;
        }
        JetType jetType = this.typeResolver.resolveType(scope2, typeReference, new BindingTraceContext(), true);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationType"));
        }
        return jetType;
    }

    public static void checkAnnotationType(@NotNull JetAnnotationEntry entryElement, @NotNull BindingTrace trace, @NotNull OverloadResolutionResults<FunctionDescriptor> results) {
        if (entryElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryElement", "org/jetbrains/kotlin/resolve/AnnotationResolver", "checkAnnotationType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/AnnotationResolver", "checkAnnotationType"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/kotlin/resolve/AnnotationResolver", "checkAnnotationType"));
        }
        if (!results.isSingleResult()) {
            return;
        }
        FunctionDescriptor descriptor = results.getResultingDescriptor();
        if (!ErrorUtils.isError(descriptor)) {
            if (descriptor instanceof ConstructorDescriptor) {
                ConstructorDescriptor constructor2 = (ConstructorDescriptor)descriptor;
                ClassDescriptor classDescriptor = constructor2.getContainingDeclaration();
                if (classDescriptor.getKind() != ClassKind.ANNOTATION_CLASS) {
                    trace.report(Errors.NOT_AN_ANNOTATION_CLASS.on(entryElement, classDescriptor));
                }
            } else {
                trace.report(Errors.NOT_AN_ANNOTATION_CLASS.on(entryElement, descriptor));
            }
        }
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveAnnotationCall(JetAnnotationEntry annotationEntry, JetScope scope2, BindingTrace trace) {
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.callResolver.resolveFunctionCall(trace, scope2, CallMaker.makeCall(ReceiverValue.NO_RECEIVER, null, annotationEntry), TypeUtils.NO_EXPECTED_TYPE, DataFlowInfo.EMPTY, true);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationCall"));
        }
        return overloadResolutionResults;
    }

    public static void resolveAnnotationsArguments(@Nullable JetModifierList modifierList, @NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationsArguments"));
        }
        if (modifierList == null) {
            return;
        }
        for (JetAnnotationEntry annotationEntry : modifierList.getAnnotationEntries()) {
            AnnotationResolver.resolveAnnotationArguments(annotationEntry, trace);
        }
    }

    public static void resolveAnnotationsArguments(@NotNull Annotations annotations2, @NotNull BindingTrace trace) {
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationsArguments"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationsArguments"));
        }
        for (AnnotationDescriptor annotationDescriptor : annotations2) {
            JetAnnotationEntry annotationEntry = trace.getBindingContext().get(BindingContext.ANNOTATION_DESCRIPTOR_TO_PSI_ELEMENT, annotationDescriptor);
            assert (annotationEntry != null) : "Cannot find annotation entry: " + annotationDescriptor;
            AnnotationResolver.resolveAnnotationArguments(annotationEntry, trace);
        }
    }

    private static void resolveAnnotationArguments(@NotNull JetAnnotationEntry annotationEntry, @NotNull BindingTrace trace) {
        if (annotationEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationEntry", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationArguments"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationArguments"));
        }
        AnnotationDescriptor annotationDescriptor = trace.getBindingContext().get(BindingContext.ANNOTATION, annotationEntry);
        assert (annotationDescriptor != null) : "Annotation descriptor should be created before resolving arguments for " + annotationEntry.getText();
        if (annotationDescriptor instanceof LazyAnnotationDescriptor) {
            ((LazyAnnotationDescriptor)annotationDescriptor).forceResolveAllContents();
        }
    }

    @NotNull
    public static Map<ValueParameterDescriptor, CompileTimeConstant<?>> resolveAnnotationArguments(@NotNull ResolvedCall<?> resolvedCall, @NotNull BindingTrace trace) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationArguments"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationArguments"));
        }
        HashMap arguments2 = new HashMap();
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> descriptorToArgument : resolvedCall.getValueArguments().entrySet()) {
            ResolvedValueArgument resolvedArgument;
            ValueParameterDescriptor parameterDescriptor = descriptorToArgument.getKey();
            CompileTimeConstant<?> value = AnnotationResolver.getAnnotationArgumentValue(trace, parameterDescriptor, resolvedArgument = descriptorToArgument.getValue());
            if (value == null) continue;
            arguments2.put(parameterDescriptor, value);
        }
        HashMap hashMap = arguments2;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationArguments"));
        }
        return hashMap;
    }

    @Nullable
    public static CompileTimeConstant<?> getAnnotationArgumentValue(BindingTrace trace, ValueParameterDescriptor parameterDescriptor, ResolvedValueArgument resolvedArgument) {
        JetType varargElementType = parameterDescriptor.getVarargElementType();
        boolean argumentsAsVararg = varargElementType != null && !AnnotationResolver.hasSpread(resolvedArgument);
        List<CompileTimeConstant<?>> constants = AnnotationResolver.resolveValueArguments(resolvedArgument, argumentsAsVararg ? varargElementType : parameterDescriptor.getType(), trace);
        if (argumentsAsVararg) {
            boolean usesVariableAsConstant = KotlinPackage.any(constants, new Function1<CompileTimeConstant<?>, Boolean>(){

                @Override
                public Boolean invoke(CompileTimeConstant<?> constant) {
                    return constant.usesVariableAsConstant();
                }
            });
            return new ArrayValue(constants, parameterDescriptor.getType(), true, usesVariableAsConstant);
        }
        return !constants.isEmpty() ? KotlinPackage.last(constants) : null;
    }

    private static void checkCompileTimeConstant(@NotNull JetExpression argumentExpression, @NotNull JetType expectedType, @NotNull BindingTrace trace) {
        CompileTimeConstant<?> constant;
        Pair<List<JetExpression>, JetType> arrayArgument;
        if (argumentExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentExpression", "org/jetbrains/kotlin/resolve/AnnotationResolver", "checkCompileTimeConstant"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/resolve/AnnotationResolver", "checkCompileTimeConstant"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/AnnotationResolver", "checkCompileTimeConstant"));
        }
        JetType expressionType = trace.get(BindingContext.EXPRESSION_TYPE, argumentExpression);
        if (expressionType == null || !JetTypeChecker.DEFAULT.isSubtypeOf(expressionType, expectedType)) {
            return;
        }
        if (argumentExpression instanceof JetCallExpression && (arrayArgument = AnnotationResolver.getArgumentExpressionsForArrayCall((JetCallExpression)argumentExpression, trace)) != null) {
            for (JetExpression expression : arrayArgument.getFirst()) {
                AnnotationResolver.checkCompileTimeConstant(expression, arrayArgument.getSecond(), trace);
            }
        }
        if ((constant = trace.get(BindingContext.COMPILE_TIME_VALUE, argumentExpression)) != null && constant.canBeUsedInAnnotations()) {
            return;
        }
        ClassifierDescriptor descriptor = expressionType.getConstructor().getDeclarationDescriptor();
        if (descriptor != null && DescriptorUtils.isEnumClass(descriptor)) {
            trace.report(Errors.ANNOTATION_PARAMETER_MUST_BE_ENUM_CONST.on(argumentExpression));
        } else if (descriptor instanceof ClassDescriptor && CompileTimeConstantUtils.isJavaLangClass((ClassDescriptor)descriptor)) {
            trace.report(Errors.ANNOTATION_PARAMETER_MUST_BE_CLASS_LITERAL.on(argumentExpression));
        } else {
            trace.report(Errors.ANNOTATION_PARAMETER_MUST_BE_CONST.on(argumentExpression));
        }
    }

    @Nullable
    private static Pair<List<JetExpression>, JetType> getArgumentExpressionsForArrayCall(@NotNull JetCallExpression expression, @NotNull BindingTrace trace) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/AnnotationResolver", "getArgumentExpressionsForArrayCall"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/AnnotationResolver", "getArgumentExpressionsForArrayCall"));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(expression, trace.getBindingContext());
        if (resolvedCall == null || !CompileTimeConstantUtils.isArrayMethodCall(resolvedCall)) {
            return null;
        }
        assert (resolvedCall.getValueArguments().size() == 1) : "Array function should have only one vararg parameter";
        Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> argumentEntry = resolvedCall.getValueArguments().entrySet().iterator().next();
        ArrayList<JetExpression> result2 = Lists.newArrayList();
        JetType elementType = argumentEntry.getKey().getVarargElementType();
        for (ValueArgument valueArgument : argumentEntry.getValue().getArguments()) {
            JetExpression valueArgumentExpression = valueArgument.getArgumentExpression();
            if (valueArgumentExpression == null || elementType == null) continue;
            result2.add(valueArgumentExpression);
        }
        return new Pair<List<JetExpression>, JetType>(result2, elementType);
    }

    private static boolean hasSpread(@NotNull ResolvedValueArgument argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/resolve/AnnotationResolver", "hasSpread"));
        }
        List<ValueArgument> arguments2 = argument.getArguments();
        return arguments2.size() == 1 && arguments2.get(0).getSpreadElement() != null;
    }

    @NotNull
    private static List<CompileTimeConstant<?>> resolveValueArguments(@NotNull ResolvedValueArgument resolvedValueArgument, @NotNull JetType expectedType, @NotNull BindingTrace trace) {
        if (resolvedValueArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedValueArgument", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveValueArguments"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveValueArguments"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveValueArguments"));
        }
        ArrayList<CompileTimeConstant<?>> constants = Lists.newArrayList();
        for (ValueArgument argument : resolvedValueArgument.getArguments()) {
            JetExpression argumentExpression = argument.getArgumentExpression();
            if (argumentExpression == null) continue;
            CompileTimeConstant<?> constant = ConstantExpressionEvaluator.OBJECT$.evaluate(argumentExpression, trace, expectedType);
            if (constant instanceof IntegerValueTypeConstant) {
                JetType defaultType = ((IntegerValueTypeConstant)constant).getType(expectedType);
                SimpleResolutionContext context2 = new SimpleResolutionContext(trace, JetScope.Empty.INSTANCE$, TypeUtils.NO_EXPECTED_TYPE, DataFlowInfo.EMPTY, ContextDependency.INDEPENDENT, new CompositeChecker(Lists.<CallChecker>newArrayList()), StatementFilter.NONE);
                ArgumentTypeResolver.updateNumberType(defaultType, argumentExpression, context2);
            }
            if (constant != null) {
                constants.add(constant);
            }
            AnnotationResolver.checkCompileTimeConstant(argumentExpression, expectedType, trace);
        }
        ArrayList<CompileTimeConstant<?>> arrayList = constants;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveValueArguments"));
        }
        return arrayList;
    }

    public static void reportUnsupportedAnnotationForTypeParameter(@NotNull JetTypeParameter jetTypeParameter, @NotNull BindingTrace trace) {
        if (jetTypeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetTypeParameter", "org/jetbrains/kotlin/resolve/AnnotationResolver", "reportUnsupportedAnnotationForTypeParameter"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/AnnotationResolver", "reportUnsupportedAnnotationForTypeParameter"));
        }
        JetModifierList modifierList = jetTypeParameter.getModifierList();
        if (modifierList == null) {
            return;
        }
        for (JetAnnotationEntry annotationEntry : modifierList.getAnnotationEntries()) {
            trace.report(Errors.UNSUPPORTED.on(annotationEntry, "Annotations for type parameters are not supported yet"));
        }
    }
}

