/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassBody;
import org.jetbrains.kotlin.psi.JetClassObject;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetPsiUtil;

public final class JetNamedDeclarationUtil {
    @Nullable
    public static FqNameUnsafe getUnsafeFQName(@NotNull JetNamedDeclaration namedDeclaration) {
        if (namedDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedDeclaration", "org/jetbrains/kotlin/psi/JetNamedDeclarationUtil", "getUnsafeFQName"));
        }
        FqName fqName2 = namedDeclaration.getFqName();
        return fqName2 != null ? fqName2.toUnsafe() : null;
    }

    @Nullable
    static FqName getFQName(@NotNull JetNamedDeclaration namedDeclaration) {
        if (namedDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedDeclaration", "org/jetbrains/kotlin/psi/JetNamedDeclarationUtil", "getFQName"));
        }
        Name name = namedDeclaration.getNameAsName();
        if (name == null) {
            return null;
        }
        FqName parentFqName = JetNamedDeclarationUtil.getParentFqName(namedDeclaration);
        if (parentFqName == null) {
            return null;
        }
        return parentFqName.child(name);
    }

    @Nullable
    public static FqName getParentFqName(@NotNull JetNamedDeclaration namedDeclaration) {
        if (namedDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedDeclaration", "org/jetbrains/kotlin/psi/JetNamedDeclarationUtil", "getParentFqName"));
        }
        PsiElement parent = namedDeclaration.getParent();
        if (parent instanceof JetClassBody) {
            parent = parent.getParent();
        }
        if (parent instanceof JetFile) {
            return ((JetFile)parent).getPackageFqName();
        }
        if (parent instanceof JetNamedFunction || parent instanceof JetClass) {
            return JetNamedDeclarationUtil.getFQName((JetNamedDeclaration)parent);
        }
        if (namedDeclaration instanceof JetParameter) {
            JetClass constructorClass = JetPsiUtil.getClassIfParameterIsProperty((JetParameter)namedDeclaration);
            if (constructorClass != null) {
                return JetNamedDeclarationUtil.getFQName(constructorClass);
            }
        } else if (parent instanceof JetObjectDeclaration) {
            if (parent.getParent() instanceof JetClassObject) {
                JetClassOrObject classOrObject = PsiTreeUtil.getParentOfType(parent, JetClassOrObject.class);
                if (classOrObject != null) {
                    return JetNamedDeclarationUtil.getFQName(classOrObject);
                }
            } else {
                return JetNamedDeclarationUtil.getFQName((JetNamedDeclaration)parent);
            }
        }
        return null;
    }

    private JetNamedDeclarationUtil() {
    }
}

