/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetDelegationSpecifier;
import org.jetbrains.kotlin.psi.JetInitializerList;
import org.jetbrains.kotlin.psi.JetObjectDeclarationName;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes;

public class JetEnumEntry
extends JetClass {
    public JetEnumEntry(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetEnumEntry", "<init>"));
        }
        super(node);
    }

    public JetEnumEntry(@NotNull KotlinClassStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/JetEnumEntry", "<init>"));
        }
        super(stub);
    }

    @Override
    public String getName() {
        KotlinClassStub classStub = (KotlinClassStub)this.getStub();
        if (classStub != null) {
            return classStub.getName();
        }
        JetObjectDeclarationName nameAsDeclaration = this.getNameAsDeclaration();
        return nameAsDeclaration == null ? "<Anonymous>" : nameAsDeclaration.getName();
    }

    @Override
    public PsiElement getNameIdentifier() {
        JetObjectDeclarationName nameAsDeclaration = this.getNameAsDeclaration();
        return nameAsDeclaration == null ? null : nameAsDeclaration.getNameIdentifier();
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/psi/JetEnumEntry", "setName"));
        }
        JetObjectDeclarationName nameAsDeclaration = this.getNameAsDeclaration();
        return nameAsDeclaration == null ? null : nameAsDeclaration.setName(name);
    }

    @Override
    @NotNull
    public List<JetDelegationSpecifier> getDelegationSpecifiers() {
        JetInitializerList initializerList = this.getInitializerList();
        if (initializerList == null) {
            List<JetDelegationSpecifier> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetEnumEntry", "getDelegationSpecifiers"));
            }
            return list;
        }
        List<JetDelegationSpecifier> list = initializerList.getInitializers();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetEnumEntry", "getDelegationSpecifiers"));
        }
        return list;
    }

    @Nullable
    public JetInitializerList getInitializerList() {
        return (JetInitializerList)this.getStubOrPsiChild(JetStubElementTypes.INITIALIZER_LIST);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetEnumEntry", "accept"));
        }
        return visitor.visitEnumEntry(this, data2);
    }
}

