/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.TokenSet;
import java.util.Arrays;
import java.util.List;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetClassInitializer;
import org.jetbrains.kotlin.psi.JetClassObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDeclarationContainer;
import org.jetbrains.kotlin.psi.JetElementImplStub;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes;

public class JetClassBody
extends JetElementImplStub<KotlinPlaceHolderStub<JetClassBody>>
implements JetDeclarationContainer {
    public JetClassBody(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetClassBody", "<init>"));
        }
        super(node);
    }

    public JetClassBody(@NotNull KotlinPlaceHolderStub<JetClassBody> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/JetClassBody", "<init>"));
        }
        super(stub, JetStubElementTypes.CLASS_BODY);
    }

    @Override
    @NotNull
    public List<JetDeclaration> getDeclarations() {
        List<PsiElement> list = Arrays.asList(this.getStubOrPsiChildren(JetStubElementTypes.DECLARATION_TYPES, JetDeclaration.ARRAY_FACTORY));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetClassBody", "getDeclarations"));
        }
        return list;
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetClassBody", "accept"));
        }
        return visitor.visitClassBody(this, data2);
    }

    @NotNull
    public List<JetClassInitializer> getAnonymousInitializers() {
        List<JetClassInitializer> list = this.findChildrenByType(JetNodeTypes.ANONYMOUS_INITIALIZER);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetClassBody", "getAnonymousInitializers"));
        }
        return list;
    }

    @NotNull
    public List<JetProperty> getProperties() {
        List<JetProperty> list = this.getStubOrPsiChildrenAsList(JetStubElementTypes.PROPERTY);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetClassBody", "getProperties"));
        }
        return list;
    }

    @Nullable
    public JetClassObject getClassObject() {
        return (JetClassObject)this.getStubOrPsiChild(JetStubElementTypes.CLASS_OBJECT);
    }

    @NotNull
    public List<JetClassObject> getAllClassObjects() {
        List<JetClassObject> list = this.getStubOrPsiChildrenAsList(JetStubElementTypes.CLASS_OBJECT);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetClassBody", "getAllClassObjects"));
        }
        return list;
    }

    @Nullable
    public PsiElement getRBrace() {
        ASTNode[] children = this.getNode().getChildren(TokenSet.create(JetTokens.RBRACE));
        return children.length == 1 ? children[0].getPsi() : null;
    }

    @Nullable
    public PsiElement getLBrace() {
        ASTNode[] children = this.getNode().getChildren(TokenSet.create(JetTokens.LBRACE));
        return children.length == 1 ? children[0].getPsi() : null;
    }

    @NotNull
    public List<JetAnnotationEntry> getDanglingAnnotations() {
        List<JetAnnotationEntry> list = KotlinPackage.flatMap(this.getStubOrPsiChildrenAsList(JetStubElementTypes.MODIFIER_LIST), new Function1<JetModifierList, Iterable<JetAnnotationEntry>>(){

            @Override
            public Iterable<JetAnnotationEntry> invoke(JetModifierList modifierList) {
                return modifierList.getAnnotationEntries();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetClassBody", "getDanglingAnnotations"));
        }
        return list;
    }
}

