/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.load.java.components.TypeUsage;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMapBuilder;
import org.jetbrains.kotlin.platform.PlatformToKotlinClassMap;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.kotlin.types.JetType;

public class JavaToKotlinClassMap
extends JavaToKotlinClassMapBuilder
implements PlatformToKotlinClassMap {
    public static final JavaToKotlinClassMap INSTANCE = new JavaToKotlinClassMap();
    private final Map<FqName, ClassDescriptor> classDescriptorMap = new HashMap<FqName, ClassDescriptor>();
    private final Map<FqName, ClassDescriptor> classDescriptorMapForCovariantPositions = new HashMap<FqName, ClassDescriptor>();
    private final Map<String, JetType> primitiveTypesMap = new LinkedHashMap<String, JetType>();
    private final Map<FqName, Collection<ClassDescriptor>> packagesWithMappedClasses = new HashMap<FqName, Collection<ClassDescriptor>>();
    private final Set<ClassDescriptor> allKotlinClasses = new LinkedHashSet<ClassDescriptor>();

    private JavaToKotlinClassMap() {
        this.init();
        this.initPrimitives();
    }

    private void initPrimitives() {
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
            PrimitiveType primitiveType = jvmPrimitiveType.getPrimitiveType();
            String name = jvmPrimitiveType.getName();
            FqName wrapperFqName = jvmPrimitiveType.getWrapperFqName();
            this.register(wrapperFqName, builtIns.getPrimitiveClassDescriptor(primitiveType));
            this.primitiveTypesMap.put(name, builtIns.getPrimitiveJetType(primitiveType));
            this.primitiveTypesMap.put("[" + name, builtIns.getPrimitiveArrayJetType(primitiveType));
            this.primitiveTypesMap.put(wrapperFqName.asString(), builtIns.getNullablePrimitiveJetType(primitiveType));
        }
        this.primitiveTypesMap.put("void", KotlinBuiltIns.getInstance().getUnitType());
        for (JetType type2 : this.primitiveTypesMap.values()) {
            this.allKotlinClasses.add((ClassDescriptor)type2.getConstructor().getDeclarationDescriptor());
        }
    }

    @Nullable
    public JetType mapPrimitiveKotlinClass(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "mapPrimitiveKotlinClass"));
        }
        return this.primitiveTypesMap.get(name);
    }

    @Nullable
    public ClassDescriptor mapKotlinClass(@NotNull FqName fqName2, @NotNull TypeUsage typeUsage) {
        ClassDescriptor descriptor;
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "mapKotlinClass"));
        }
        if (typeUsage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeUsage", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "mapKotlinClass"));
        }
        if ((typeUsage == TypeUsage.MEMBER_SIGNATURE_COVARIANT || typeUsage == TypeUsage.SUPERTYPE) && (descriptor = this.classDescriptorMapForCovariantPositions.get(fqName2)) != null) {
            return descriptor;
        }
        return this.classDescriptorMap.get(fqName2);
    }

    @NotNull
    private static FqName fqNameByClass(@NotNull Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "fqNameByClass"));
        }
        FqName fqName2 = new FqName(clazz.getCanonicalName());
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "fqNameByClass"));
        }
        return fqName2;
    }

    @Override
    protected void register(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor, @NotNull JavaToKotlinClassMapBuilder.Direction direction) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "register"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinDescriptor", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "register"));
        }
        if (direction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "direction", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "register"));
        }
        if (direction == JavaToKotlinClassMapBuilder.Direction.BOTH || direction == JavaToKotlinClassMapBuilder.Direction.JAVA_TO_KOTLIN) {
            this.register(JavaToKotlinClassMap.fqNameByClass(javaClass), kotlinDescriptor);
        }
    }

    @Override
    protected void register(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor, @NotNull ClassDescriptor kotlinMutableDescriptor, @NotNull JavaToKotlinClassMapBuilder.Direction direction) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "register"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinDescriptor", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "register"));
        }
        if (kotlinMutableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinMutableDescriptor", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "register"));
        }
        if (direction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "direction", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "register"));
        }
        if (direction == JavaToKotlinClassMapBuilder.Direction.BOTH || direction == JavaToKotlinClassMapBuilder.Direction.JAVA_TO_KOTLIN) {
            FqName javaClassName = JavaToKotlinClassMap.fqNameByClass(javaClass);
            this.register(javaClassName, kotlinDescriptor);
            this.registerCovariant(javaClassName, kotlinMutableDescriptor);
        }
    }

    private void register(@NotNull FqName javaClassName, @NotNull ClassDescriptor kotlinDescriptor) {
        if (javaClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClassName", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "register"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinDescriptor", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "register"));
        }
        this.classDescriptorMap.put(javaClassName, kotlinDescriptor);
        this.registerClassInPackage(javaClassName.parent(), kotlinDescriptor);
    }

    private void registerCovariant(@NotNull FqName javaClassName, @NotNull ClassDescriptor kotlinDescriptor) {
        if (javaClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClassName", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "registerCovariant"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinDescriptor", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "registerCovariant"));
        }
        this.classDescriptorMapForCovariantPositions.put(javaClassName, kotlinDescriptor);
        this.registerClassInPackage(javaClassName.parent(), kotlinDescriptor);
    }

    private void registerClassInPackage(@NotNull FqName packageFqName, @NotNull ClassDescriptor kotlinDescriptor) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "registerClassInPackage"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinDescriptor", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "registerClassInPackage"));
        }
        Collection<ClassDescriptor> classesInPackage = this.packagesWithMappedClasses.get(packageFqName);
        if (classesInPackage == null) {
            classesInPackage = new HashSet<ClassDescriptor>();
            this.packagesWithMappedClasses.put(packageFqName, classesInPackage);
        }
        classesInPackage.add(kotlinDescriptor);
        this.allKotlinClasses.add(kotlinDescriptor);
    }

    @NotNull
    public Collection<ClassDescriptor> mapPlatformClass(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "mapPlatformClass"));
        }
        ClassDescriptor kotlinAnalog = this.classDescriptorMap.get(fqName2);
        ClassDescriptor kotlinCovariantAnalog = this.classDescriptorMapForCovariantPositions.get(fqName2);
        ArrayList<ClassDescriptor> descriptors = new ArrayList<ClassDescriptor>(2);
        if (kotlinAnalog != null) {
            descriptors.add(kotlinAnalog);
        }
        if (kotlinCovariantAnalog != null) {
            descriptors.add(kotlinCovariantAnalog);
        }
        ArrayList<ClassDescriptor> arrayList = descriptors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "mapPlatformClass"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> mapPlatformClass(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "mapPlatformClass"));
        }
        FqNameUnsafe className = DescriptorUtils.getFqName(classDescriptor);
        if (!className.isSafe()) {
            List<ClassDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "mapPlatformClass"));
            }
            return list;
        }
        Collection<ClassDescriptor> collection = this.mapPlatformClass(className.toSafe());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "mapPlatformClass"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> mapPlatformClassesInside(@NotNull DeclarationDescriptor containingDeclaration) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "mapPlatformClassesInside"));
        }
        FqNameUnsafe fqName2 = DescriptorUtils.getFqName(containingDeclaration);
        if (!fqName2.isSafe()) {
            List<ClassDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "mapPlatformClassesInside"));
            }
            return list;
        }
        Collection<ClassDescriptor> result2 = this.packagesWithMappedClasses.get(fqName2.toSafe());
        Collection<Object> collection = result2 == null ? Collections.emptySet() : Collections.unmodifiableCollection(result2);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "mapPlatformClassesInside"));
        }
        return collection;
    }

    @NotNull
    public Set<ClassDescriptor> allKotlinClasses() {
        Set<ClassDescriptor> set = this.allKotlinClasses;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "allKotlinClasses"));
        }
        return set;
    }
}

