/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.name;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;

public final class ClassId {
    private final FqName packageFqName;
    private final FqNameUnsafe relativeClassName;

    @NotNull
    public static ClassId topLevel(@NotNull FqName topLevelFqName) {
        if (topLevelFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topLevelFqName", "org/jetbrains/kotlin/name/ClassId", "topLevel"));
        }
        ClassId classId = new ClassId(topLevelFqName.parent(), topLevelFqName.shortName());
        if (classId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/name/ClassId", "topLevel"));
        }
        return classId;
    }

    public ClassId(@NotNull FqName packageFqName, @NotNull FqNameUnsafe relativeClassName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/name/ClassId", "<init>"));
        }
        if (relativeClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeClassName", "org/jetbrains/kotlin/name/ClassId", "<init>"));
        }
        this.packageFqName = packageFqName;
        assert (!relativeClassName.isRoot()) : "Class name must not be root. " + packageFqName;
        this.relativeClassName = relativeClassName;
    }

    public ClassId(@NotNull FqName packageFqName, @NotNull Name topLevelName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/name/ClassId", "<init>"));
        }
        if (topLevelName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topLevelName", "org/jetbrains/kotlin/name/ClassId", "<init>"));
        }
        this(packageFqName, FqNameUnsafe.topLevel(topLevelName));
    }

    @NotNull
    public FqName getPackageFqName() {
        FqName fqName2 = this.packageFqName;
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/name/ClassId", "getPackageFqName"));
        }
        return fqName2;
    }

    @NotNull
    public FqNameUnsafe getRelativeClassName() {
        FqNameUnsafe fqNameUnsafe = this.relativeClassName;
        if (fqNameUnsafe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/name/ClassId", "getRelativeClassName"));
        }
        return fqNameUnsafe;
    }

    @NotNull
    public ClassId createNestedClassId(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/name/ClassId", "createNestedClassId"));
        }
        ClassId classId = new ClassId(this.getPackageFqName(), this.relativeClassName.child(name));
        if (classId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/name/ClassId", "createNestedClassId"));
        }
        return classId;
    }

    @NotNull
    public ClassId getOuterClassId() {
        ClassId classId = new ClassId(this.getPackageFqName(), this.relativeClassName.parent());
        if (classId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/name/ClassId", "getOuterClassId"));
        }
        return classId;
    }

    public boolean isTopLevelClass() {
        return this.relativeClassName.parent().isRoot();
    }

    @NotNull
    public FqNameUnsafe asSingleFqName() {
        if (this.packageFqName.isRoot()) {
            FqNameUnsafe fqNameUnsafe = this.relativeClassName;
            if (fqNameUnsafe == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/name/ClassId", "asSingleFqName"));
            }
            return fqNameUnsafe;
        }
        FqNameUnsafe fqNameUnsafe = new FqNameUnsafe(this.packageFqName.asString() + "." + this.relativeClassName.asString());
        if (fqNameUnsafe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/name/ClassId", "asSingleFqName"));
        }
        return fqNameUnsafe;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassId id = (ClassId)o;
        if (!this.packageFqName.equals(id.packageFqName)) {
            return false;
        }
        return this.relativeClassName.equals(id.relativeClassName);
    }

    public int hashCode() {
        int result2 = this.packageFqName.hashCode();
        result2 = 31 * result2 + this.relativeClassName.hashCode();
        return result2;
    }

    public String toString() {
        if (this.packageFqName.isRoot()) {
            return "/" + this.relativeClassName;
        }
        return this.packageFqName.toString().replace('.', '/') + "/" + this.relativeClassName;
    }
}

