/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kdoc.parser;

public enum KDocKnownTag {
    AUTHOR(false, false),
    THROWS(true, false),
    EXCEPTION(true, false),
    PARAM(true, false),
    RETURN(false, false),
    SEE(false, false),
    SINCE(false, false),
    CONSTRUCTOR(false, true),
    PROPERTY(true, true);

    private final boolean takesReference;
    private final boolean startsSection;

    private KDocKnownTag(boolean takesReference, boolean startsSection) {
        this.takesReference = takesReference;
        this.startsSection = startsSection;
    }

    public boolean isReferenceRequired() {
        return this.takesReference;
    }

    public boolean isSectionStart() {
        return this.startsSection;
    }

    public static KDocKnownTag findByTagName(String tagName) {
        if (tagName.startsWith("@")) {
            tagName = tagName.substring(1);
        }
        try {
            return KDocKnownTag.valueOf(tagName.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }
}

