/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsExpressionStatement;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.metadata.MetadataPackage;
import com.google.dart.compiler.common.SourceInfoImpl;
import com.google.gwt.dev.js.AbortParsingException;
import com.google.gwt.dev.js.JsParser;
import com.google.gwt.dev.js.JsParserException;
import com.google.gwt.dev.js.rhino.ErrorReporter;
import com.google.gwt.dev.js.rhino.EvaluatorException;
import com.google.gwt.dev.js.rhino.Utils;
import com.intellij.openapi.util.TextRange;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.InlineStrategy;
import org.jetbrains.kotlin.builtins.InlineUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.patterns.DescriptorPredicate;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.patterns.PatternBuilder;
import org.jetbrains.kotlin.js.translate.reference.AbstractCallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetStringTemplateExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;

public final class CallExpressionTranslator
extends AbstractCallExpressionTranslator {
    @NotNull
    private static final DescriptorPredicate JSCODE_PATTERN = PatternBuilder.pattern("kotlin.js.js(String)");

    @NotNull
    public static JsNode translate(@NotNull JetCallExpression expression, @Nullable JsExpression receiver, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translate"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translate"));
        }
        if (CallExpressionTranslator.matchesJsCode(expression, context2)) {
            JsNode jsNode = new CallExpressionTranslator(expression, receiver, context2).translateJsCode();
            if (jsNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translate"));
            }
            return jsNode;
        }
        JsExpression callExpression = new CallExpressionTranslator(expression, receiver, context2).translate();
        if (CallExpressionTranslator.shouldBeInlined(expression, context2) && callExpression instanceof JsInvocation) {
            MetadataPackage.setInlineStrategy((JsInvocation)callExpression, InlineStrategy.IN_PLACE);
        }
        JsExpression jsExpression = callExpression;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translate"));
        }
        return jsExpression;
    }

    public static boolean shouldBeInlined(@NotNull JetCallExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "shouldBeInlined"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "shouldBeInlined"));
        }
        if (!context2.getConfig().isInlineEnabled()) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(expression, context2.bindingContext());
        assert (resolvedCall != null);
        CallableDescriptor descriptor = resolvedCall instanceof VariableAsFunctionResolvedCall ? ((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getVariableCall().getCandidateDescriptor() : resolvedCall.getCandidateDescriptor();
        if (descriptor instanceof SimpleFunctionDescriptor) {
            return ((SimpleFunctionDescriptor)descriptor).getInlineStrategy().isInline();
        }
        if (descriptor instanceof ValueParameterDescriptor) {
            DeclarationDescriptor containingDescriptor = descriptor.getContainingDeclaration();
            return InlineUtil.getInlineType(containingDescriptor).isInline() && !InlineUtil.hasNoinlineAnnotation(descriptor);
        }
        return false;
    }

    private static boolean matchesJsCode(@NotNull JetCallExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "matchesJsCode"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "matchesJsCode"));
        }
        FunctionDescriptor descriptor = CallUtilPackage.getFunctionResolvedCallWithAssert(expression, context2.bindingContext()).getResultingDescriptor();
        return JSCODE_PATTERN.apply(descriptor) && expression.getValueArguments().size() == 1;
    }

    private CallExpressionTranslator(@NotNull JetCallExpression expression, @Nullable JsExpression receiver, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "<init>"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "<init>"));
        }
        super(expression, receiver, context2);
    }

    @NotNull
    private JsExpression translate() {
        JsExpression jsExpression = CallTranslator.INSTANCE$.translate(this.context(), this.resolvedCall, this.receiver);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translate"));
        }
        return jsExpression;
    }

    @NotNull
    private JsNode translateJsCode() {
        List<? extends ValueArgument> arguments2 = this.expression.getValueArguments();
        JetExpression argumentExpression = arguments2.get(0).getArgumentExpression();
        if (!(argumentExpression instanceof JetStringTemplateExpression)) {
            this.context().getTrace().report(ErrorsJs.JSCODE_ARGUMENT_SHOULD_BE_LITERAL.on(this.expression));
            JsExpression jsExpression = this.program().getEmptyExpression();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translateJsCode"));
            }
            return jsExpression;
        }
        List<JsStatement> statements = this.parseJsCode(argumentExpression);
        int size = statements.size();
        if (size == 0) {
            JsExpression jsExpression = this.program().getEmptyExpression();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translateJsCode"));
            }
            return jsExpression;
        }
        if (size > 1) {
            JsBlock jsBlock = new JsBlock(statements);
            if (jsBlock == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translateJsCode"));
            }
            return jsBlock;
        }
        JsStatement resultStatement = statements.get(0);
        if (resultStatement instanceof JsExpressionStatement) {
            JsExpression jsExpression = ((JsExpressionStatement)resultStatement).getExpression();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translateJsCode"));
            }
            return jsExpression;
        }
        JsStatement jsStatement = resultStatement;
        if (jsStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translateJsCode"));
        }
        return jsStatement;
    }

    @NotNull
    private List<JsStatement> parseJsCode(@NotNull JetExpression jsCodeExpression) {
        if (jsCodeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsCodeExpression", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "parseJsCode"));
        }
        Object jsCode = BindingUtils.getCompileTimeValue(this.bindingContext(), jsCodeExpression);
        assert (jsCode instanceof String) : "jsCode must be compile time string";
        ArrayList<JsStatement> statements = new ArrayList<JsStatement>();
        JsCodeErrorReporter errorReporter = new JsCodeErrorReporter(jsCodeExpression);
        try {
            SourceInfoImpl info = new SourceInfoImpl(null, 0, 0, 0, 0);
            JsScope scope2 = this.context().scope();
            StringReader reader = new StringReader((String)jsCode);
            statements.addAll(JsParser.parse(info, scope2, reader, errorReporter, true));
        }
        catch (AbortParsingException e) {
            List<JsStatement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "parseJsCode"));
            }
            return list;
        }
        catch (JsParserException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ArrayList<JsStatement> arrayList = statements;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "parseJsCode"));
        }
        return arrayList;
    }

    private class JsCodeErrorReporter
    implements ErrorReporter {
        @NotNull
        private final JetExpression jsCodeExpression;

        private JsCodeErrorReporter(@NotNull JetExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator$JsCodeErrorReporter", "<init>"));
            }
            this.jsCodeExpression = expression;
        }

        @Override
        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            ParametrizedDiagnostic<JetExpression> diagnostic = this.getDiagnostic(ErrorsJs.JSCODE_ERROR, message, line, lineOffset);
            CallExpressionTranslator.this.context().getTrace().report(diagnostic);
            throw new AbortParsingException();
        }

        @Override
        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            ParametrizedDiagnostic<JetExpression> diagnostic = this.getDiagnostic(ErrorsJs.JSCODE_WARNING, message, line, lineOffset);
            CallExpressionTranslator.this.context().getTrace().report(diagnostic);
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            throw new RuntimeException(message);
        }

        private ParametrizedDiagnostic<JetExpression> getDiagnostic(@NotNull DiagnosticFactory2<JetExpression, String, List<TextRange>> diagnosticFactory, String message, int line, int lineOffset) {
            if (diagnosticFactory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnosticFactory", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator$JsCodeErrorReporter", "getDiagnostic"));
            }
            String text = (String)BindingUtils.getCompileTimeValue(CallExpressionTranslator.this.bindingContext(), this.jsCodeExpression);
            int offset = this.jsCodeExpression.getTextOffset() + this.offsetFromStart(text, line, lineOffset);
            assert (this.jsCodeExpression instanceof JetStringTemplateExpression) : "js argument is expected to be compile-time string literal";
            int quotesLength = this.jsCodeExpression.getFirstChild().getTextLength();
            TextRange textRange = new TextRange(offset += quotesLength, offset + 1);
            return diagnosticFactory.on(this.jsCodeExpression, message, Collections.singletonList(textRange));
        }

        private int offsetFromStart(String text, int line, int offset) {
            int i = 0;
            int lineCount = 0;
            int offsetInLine = 0;
            while (i < text.length()) {
                char c = text.charAt(i);
                if (lineCount == line && offsetInLine == offset) {
                    return i;
                }
                if (Utils.isEndOfLine(c)) {
                    offsetInLine = 0;
                    assert (++lineCount <= line);
                }
                ++i;
                ++offsetInLine;
            }
            return text.length();
        }
    }
}

