/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.di;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import javax.annotation.PreDestroy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.context.ContextPackage;
import org.jetbrains.kotlin.context.GlobalContextImpl;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.load.java.JavaClassFinderImpl;
import org.jetbrains.kotlin.load.java.components.JavaSourceElementFactoryImpl;
import org.jetbrains.kotlin.load.java.components.PsiBasedExternalAnnotationResolver;
import org.jetbrains.kotlin.load.java.components.PsiBasedMethodSignatureChecker;
import org.jetbrains.kotlin.load.java.components.TraceBasedErrorReporter;
import org.jetbrains.kotlin.load.java.components.TraceBasedExternalSignatureResolver;
import org.jetbrains.kotlin.load.java.components.TraceBasedJavaResolverCache;
import org.jetbrains.kotlin.load.java.lazy.GlobalJavaResolverContext;
import org.jetbrains.kotlin.load.java.lazy.LazyJavaPackageFragmentProvider;
import org.jetbrains.kotlin.load.java.lazy.SingleModuleClassResolver;
import org.jetbrains.kotlin.load.java.sam.SamConversionResolverImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaPropertyInitializerEvaluatorImpl;
import org.jetbrains.kotlin.load.kotlin.BinaryClassAnnotationAndConstantLoaderImpl;
import org.jetbrains.kotlin.load.kotlin.DeserializationComponentsForJava;
import org.jetbrains.kotlin.load.kotlin.DeserializedDescriptorResolver;
import org.jetbrains.kotlin.load.kotlin.JavaClassDataFinder;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinder;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.jvm.JavaDescriptorResolver;
import org.jetbrains.kotlin.resolve.jvm.JavaDescriptorResolverPostConstruct;
import org.jetbrains.kotlin.resolve.jvm.TopDownAnalyzerFacadeForJVM;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;

public class InjectorForJavaDescriptorResolver {
    private final Project project;
    private final BindingTrace bindingTrace;
    private final GlobalContextImpl globalContext;
    private final LockBasedStorageManager lockBasedStorageManager;
    private final ModuleDescriptorImpl module;
    private final JavaDescriptorResolver javaDescriptorResolver;
    private final JavaClassFinderImpl javaClassFinder;
    private final GlobalSearchScope globalSearchScope;
    private final TraceBasedExternalSignatureResolver traceBasedExternalSignatureResolver;
    private final TraceBasedJavaResolverCache traceBasedJavaResolverCache;
    private final TraceBasedErrorReporter traceBasedErrorReporter;
    private final PsiBasedMethodSignatureChecker psiBasedMethodSignatureChecker;
    private final PsiBasedExternalAnnotationResolver psiBasedExternalAnnotationResolver;
    private final JavaPropertyInitializerEvaluatorImpl javaPropertyInitializerEvaluator;
    private final SamConversionResolverImpl samConversionResolver;
    private final JavaSourceElementFactoryImpl javaSourceElementFactory;
    private final SingleModuleClassResolver singleModuleClassResolver;
    private final JavaDescriptorResolverPostConstruct javaDescriptorResolverPostConstruct;
    private final VirtualFileFinder virtualFileFinder;
    private final LazyJavaPackageFragmentProvider lazyJavaPackageFragmentProvider;
    private final GlobalJavaResolverContext globalJavaResolverContext;
    private final DeserializedDescriptorResolver deserializedDescriptorResolver;
    private final DeserializationComponentsForJava deserializationComponentsForJava;
    private final JavaClassDataFinder javaClassDataFinder;
    private final BinaryClassAnnotationAndConstantLoaderImpl binaryClassAnnotationAndConstantLoader;

    public InjectorForJavaDescriptorResolver(@NotNull Project project, @NotNull BindingTrace bindingTrace) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/di/InjectorForJavaDescriptorResolver", "<init>"));
        }
        if (bindingTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingTrace", "org/jetbrains/kotlin/di/InjectorForJavaDescriptorResolver", "<init>"));
        }
        this.project = project;
        this.bindingTrace = bindingTrace;
        this.globalContext = ContextPackage.GlobalContext();
        this.lockBasedStorageManager = this.globalContext.getStorageManager();
        this.module = TopDownAnalyzerFacadeForJVM.createJavaModule("<fake-jdr-module>");
        this.javaClassFinder = new JavaClassFinderImpl();
        this.virtualFileFinder = VirtualFileFinder.SERVICE.getInstance(project);
        this.traceBasedErrorReporter = new TraceBasedErrorReporter();
        this.deserializedDescriptorResolver = new DeserializedDescriptorResolver(this.traceBasedErrorReporter);
        this.psiBasedExternalAnnotationResolver = new PsiBasedExternalAnnotationResolver();
        this.traceBasedExternalSignatureResolver = new TraceBasedExternalSignatureResolver();
        this.psiBasedMethodSignatureChecker = new PsiBasedMethodSignatureChecker();
        this.traceBasedJavaResolverCache = new TraceBasedJavaResolverCache();
        this.javaPropertyInitializerEvaluator = new JavaPropertyInitializerEvaluatorImpl();
        this.samConversionResolver = SamConversionResolverImpl.INSTANCE$;
        this.javaSourceElementFactory = new JavaSourceElementFactoryImpl();
        this.singleModuleClassResolver = new SingleModuleClassResolver();
        this.globalJavaResolverContext = new GlobalJavaResolverContext(this.lockBasedStorageManager, this.getJavaClassFinder(), this.virtualFileFinder, this.deserializedDescriptorResolver, this.psiBasedExternalAnnotationResolver, this.traceBasedExternalSignatureResolver, this.traceBasedErrorReporter, this.psiBasedMethodSignatureChecker, this.traceBasedJavaResolverCache, this.javaPropertyInitializerEvaluator, this.samConversionResolver, this.javaSourceElementFactory, this.singleModuleClassResolver);
        this.lazyJavaPackageFragmentProvider = new LazyJavaPackageFragmentProvider(this.globalJavaResolverContext, this.getModule());
        this.javaDescriptorResolver = new JavaDescriptorResolver(this.lazyJavaPackageFragmentProvider, this.getModule());
        this.globalSearchScope = GlobalSearchScope.allScope(project);
        this.javaDescriptorResolverPostConstruct = new JavaDescriptorResolverPostConstruct();
        this.javaClassDataFinder = new JavaClassDataFinder(this.virtualFileFinder, this.deserializedDescriptorResolver);
        this.binaryClassAnnotationAndConstantLoader = new BinaryClassAnnotationAndConstantLoaderImpl(this.getModule(), this.lockBasedStorageManager, this.virtualFileFinder, this.traceBasedErrorReporter);
        this.deserializationComponentsForJava = new DeserializationComponentsForJava(this.lockBasedStorageManager, this.getModule(), this.javaClassDataFinder, this.binaryClassAnnotationAndConstantLoader, this.lazyJavaPackageFragmentProvider);
        this.javaClassFinder.setComponentPostConstruct(this.javaDescriptorResolverPostConstruct);
        this.javaClassFinder.setProject(project);
        this.javaClassFinder.setScope(this.globalSearchScope);
        this.traceBasedExternalSignatureResolver.setExternalAnnotationResolver(this.psiBasedExternalAnnotationResolver);
        this.traceBasedExternalSignatureResolver.setProject(project);
        this.traceBasedExternalSignatureResolver.setTrace(bindingTrace);
        this.traceBasedJavaResolverCache.setTrace(bindingTrace);
        this.traceBasedErrorReporter.setTrace(bindingTrace);
        this.psiBasedMethodSignatureChecker.setExternalAnnotationResolver(this.psiBasedExternalAnnotationResolver);
        this.psiBasedMethodSignatureChecker.setExternalSignatureResolver(this.traceBasedExternalSignatureResolver);
        this.singleModuleClassResolver.setResolver(this.javaDescriptorResolver);
        this.javaDescriptorResolverPostConstruct.setModule(this.module);
        this.javaDescriptorResolverPostConstruct.setProject(project);
        this.javaDescriptorResolverPostConstruct.setTrace(bindingTrace);
        this.deserializedDescriptorResolver.setComponents(this.deserializationComponentsForJava);
        this.javaClassFinder.initialize();
        this.javaDescriptorResolverPostConstruct.postCreate();
    }

    @PreDestroy
    public void destroy() {
    }

    public GlobalContextImpl getGlobalContext() {
        return this.globalContext;
    }

    public ModuleDescriptorImpl getModule() {
        return this.module;
    }

    public JavaDescriptorResolver getJavaDescriptorResolver() {
        return this.javaDescriptorResolver;
    }

    public JavaClassFinderImpl getJavaClassFinder() {
        return this.javaClassFinder;
    }
}

