/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.config;

import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;

public class CompilerConfiguration {
    private final Map<Key, Object> map = new HashMap<Key, Object>();
    private boolean readOnly = false;

    @Nullable
    public <T> T get(@NotNull CompilerConfigurationKey<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/config/CompilerConfiguration", "get"));
        }
        Object data2 = this.map.get(key.ideaKey);
        return (T)(data2 == null ? null : CompilerConfiguration.unmodifiable(data2));
    }

    @NotNull
    public <T> T get(@NotNull CompilerConfigurationKey<T> key, @NotNull T defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/config/CompilerConfiguration", "get"));
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "org/jetbrains/kotlin/config/CompilerConfiguration", "get"));
        }
        Object data2 = this.map.get(key.ideaKey);
        Object object2 = data2 == null ? defaultValue : CompilerConfiguration.unmodifiable(data2);
        if (object2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/config/CompilerConfiguration", "get"));
        }
        return object2;
    }

    @NotNull
    public <T> List<T> getList(@NotNull CompilerConfigurationKey<List<T>> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/config/CompilerConfiguration", "getList"));
        }
        List data2 = (List)this.map.get(key.ideaKey);
        if (data2 == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/config/CompilerConfiguration", "getList"));
            }
            return list;
        }
        List list = Collections.unmodifiableList(data2);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/config/CompilerConfiguration", "getList"));
        }
        return list;
    }

    public <T> void put(@NotNull CompilerConfigurationKey<T> key, @Nullable T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/config/CompilerConfiguration", "put"));
        }
        this.checkReadOnly();
        this.map.put(key.ideaKey, value);
    }

    public <T> void add(@NotNull CompilerConfigurationKey<List<T>> key, @NotNull T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/config/CompilerConfiguration", "add"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/config/CompilerConfiguration", "add"));
        }
        this.checkReadOnly();
        Key ideaKey = key.ideaKey;
        if (this.map.get(ideaKey) == null) {
            this.map.put(ideaKey, new ArrayList());
        }
        List list = (List)this.map.get(ideaKey);
        list.add(value);
    }

    public <T> void addAll(@NotNull CompilerConfigurationKey<List<T>> key, @NotNull Collection<T> values) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/config/CompilerConfiguration", "addAll"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "org/jetbrains/kotlin/config/CompilerConfiguration", "addAll"));
        }
        this.checkReadOnly();
        CompilerConfiguration.checkForNullElements(values);
        Key ideaKey = key.ideaKey;
        if (this.map.get(ideaKey) == null) {
            this.map.put(ideaKey, new ArrayList());
        }
        List list = (List)this.map.get(ideaKey);
        list.addAll(values);
    }

    public CompilerConfiguration copy() {
        CompilerConfiguration copy2 = new CompilerConfiguration();
        copy2.map.putAll(this.map);
        return copy2;
    }

    private void checkReadOnly() {
        if (this.readOnly) {
            throw new IllegalStateException("CompilerConfiguration is read-only");
        }
    }

    public void setReadOnly(boolean readOnly) {
        if (readOnly != this.readOnly) {
            this.checkReadOnly();
            this.readOnly = readOnly;
        }
    }

    @NotNull
    private static <T> T unmodifiable(@NotNull T object2) {
        if (object2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "org/jetbrains/kotlin/config/CompilerConfiguration", "unmodifiable"));
        }
        if (object2 instanceof List) {
            List list = Collections.unmodifiableList((List)object2);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/config/CompilerConfiguration", "unmodifiable"));
            }
            return (T)list;
        }
        if (object2 instanceof Map) {
            Map map = Collections.unmodifiableMap((Map)object2);
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/config/CompilerConfiguration", "unmodifiable"));
            }
            return (T)map;
        }
        if (object2 instanceof Collection) {
            Collection collection = Collections.unmodifiableCollection((Collection)object2);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/config/CompilerConfiguration", "unmodifiable"));
            }
            return (T)collection;
        }
        T t = object2;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/config/CompilerConfiguration", "unmodifiable"));
        }
        return t;
    }

    public String toString() {
        return this.map.toString();
    }

    private static <T> void checkForNullElements(Collection<T> values) {
        int index2 = 0;
        for (T value : values) {
            if (value == null) {
                throw new IllegalArgumentException("Element " + index2 + " is null, while null values in compiler configuration are not allowed");
            }
            ++index2;
        }
    }
}

