/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers;

import com.google.common.collect.Maps;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetArrayAccessExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetForExpression;
import org.jetbrains.kotlin.psi.JetMultiDeclaration;
import org.jetbrains.kotlin.psi.JetMultiDeclarationEntry;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetSuperExpression;
import org.jetbrains.kotlin.psi.JetThisExpression;
import org.jetbrains.kotlin.psi.JetTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.TasksPackage;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class DebugInfoUtil {
    private static final TokenSet MAY_BE_UNRESOLVED = TokenSet.create(JetTokens.IN_KEYWORD, JetTokens.NOT_IN);
    private static final TokenSet EXCLUDED = TokenSet.create(JetTokens.COLON, JetTokens.AS_KEYWORD, JetTokens.AS_SAFE, JetTokens.IS_KEYWORD, JetTokens.NOT_IS, JetTokens.OROR, JetTokens.ANDAND, JetTokens.EQ, JetTokens.EQEQEQ, JetTokens.EXCLEQEQEQ, JetTokens.ELVIS, JetTokens.EXCLEXCL);

    public static void markDebugAnnotations(@NotNull PsiElement root, final @NotNull BindingContext bindingContext, final @NotNull DebugInfoReporter debugInfoReporter) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/checkers/DebugInfoUtil", "markDebugAnnotations"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/checkers/DebugInfoUtil", "markDebugAnnotations"));
        }
        if (debugInfoReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugInfoReporter", "org/jetbrains/kotlin/checkers/DebugInfoUtil", "markDebugAnnotations"));
        }
        final HashMap<JetReferenceExpression, DiagnosticFactory<?>> markedWithErrorElements = Maps.newHashMap();
        for (Diagnostic diagnostic : bindingContext.getDiagnostics()) {
            DiagnosticFactory<?> factory2 = diagnostic.getFactory();
            if (Errors.UNRESOLVED_REFERENCE_DIAGNOSTICS.contains(diagnostic.getFactory())) {
                markedWithErrorElements.put((JetReferenceExpression)diagnostic.getPsiElement(), factory2);
                continue;
            }
            if (factory2 == Errors.SUPER_IS_NOT_AN_EXPRESSION || factory2 == Errors.SUPER_NOT_AVAILABLE) {
                JetSuperExpression superExpression = (JetSuperExpression)diagnostic.getPsiElement();
                markedWithErrorElements.put(superExpression.getInstanceReference(), factory2);
                continue;
            }
            if (factory2 == Errors.EXPRESSION_EXPECTED_PACKAGE_FOUND) {
                markedWithErrorElements.put((JetSimpleNameExpression)diagnostic.getPsiElement(), factory2);
                continue;
            }
            if (factory2 != Errors.UNSUPPORTED) continue;
            for (JetReferenceExpression reference : PsiTreeUtil.findChildrenOfType(diagnostic.getPsiElement(), JetReferenceExpression.class)) {
                markedWithErrorElements.put(reference, factory2);
            }
        }
        root.acceptChildren(new JetTreeVisitorVoid(){

            @Override
            public void visitForExpression(@NotNull JetForExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/checkers/DebugInfoUtil$1", "visitForExpression"));
                }
                JetExpression range = expression.getLoopRange();
                this.reportIfDynamicCall(range, range, BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL);
                this.reportIfDynamicCall(range, range, BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL);
                this.reportIfDynamicCall(range, range, BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL);
                super.visitForExpression(expression);
            }

            @Override
            public void visitMultiDeclaration(@NotNull JetMultiDeclaration multiDeclaration) {
                if (multiDeclaration == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiDeclaration", "org/jetbrains/kotlin/checkers/DebugInfoUtil$1", "visitMultiDeclaration"));
                }
                for (JetMultiDeclarationEntry entry : multiDeclaration.getEntries()) {
                    this.reportIfDynamicCall(entry, entry, BindingContext.COMPONENT_RESOLVED_CALL);
                }
                super.visitMultiDeclaration(multiDeclaration);
            }

            @Override
            public void visitProperty(@NotNull JetProperty property2) {
                if (property2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/checkers/DebugInfoUtil$1", "visitProperty"));
                }
                VariableDescriptor descriptor = bindingContext.get(BindingContext.VARIABLE, property2);
                if (descriptor instanceof PropertyDescriptor && property2.getDelegate() != null) {
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor;
                    this.reportIfDynamicCall(property2.getDelegate(), propertyDescriptor.getGetter(), BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL);
                    this.reportIfDynamicCall(property2.getDelegate(), propertyDescriptor.getSetter(), BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL);
                    this.reportIfDynamicCall(property2.getDelegate(), propertyDescriptor, BindingContext.DELEGATED_PROPERTY_PD_RESOLVED_CALL);
                }
                super.visitProperty(property2);
            }

            @Override
            public void visitThisExpression(@NotNull JetThisExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/checkers/DebugInfoUtil$1", "visitThisExpression"));
                }
                ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(expression, bindingContext);
                if (resolvedCall != null) {
                    DebugInfoUtil.reportIfDynamic(expression, resolvedCall.getResultingDescriptor(), debugInfoReporter);
                }
                super.visitThisExpression(expression);
            }

            @Override
            public void visitReferenceExpression(@NotNull JetReferenceExpression expression) {
                Collection<? extends PsiElement> labelTargets;
                Collection<? extends DeclarationDescriptor> declarationDescriptors;
                PsiElement labelTarget;
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/checkers/DebugInfoUtil$1", "visitReferenceExpression"));
                }
                super.visitReferenceExpression(expression);
                if (!BindingContextUtils.isExpressionWithValidReference(expression, bindingContext)) {
                    return;
                }
                IElementType referencedNameElementType = null;
                if (expression instanceof JetSimpleNameExpression) {
                    JetSimpleNameExpression nameExpression = (JetSimpleNameExpression)expression;
                    IElementType elementType = expression.getNode().getElementType();
                    if (elementType == JetNodeTypes.OPERATION_REFERENCE) {
                        referencedNameElementType = nameExpression.getReferencedNameElementType();
                        if (EXCLUDED.contains(referencedNameElementType)) {
                            return;
                        }
                    }
                    if (elementType == JetNodeTypes.LABEL || nameExpression.getReferencedNameElementType() == JetTokens.THIS_KEYWORD) {
                        return;
                    }
                }
                debugInfoReporter.preProcessReference(expression);
                String target = null;
                DeclarationDescriptor declarationDescriptor = bindingContext.get(BindingContext.REFERENCE_TARGET, expression);
                if (declarationDescriptor != null) {
                    target = declarationDescriptor.toString();
                    DebugInfoUtil.reportIfDynamic(expression, declarationDescriptor, debugInfoReporter);
                }
                if (target == null && (labelTarget = bindingContext.get(BindingContext.LABEL_TARGET, expression)) != null) {
                    target = labelTarget.getText();
                }
                if (target == null && (declarationDescriptors = bindingContext.get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, expression)) != null) {
                    target = "[" + declarationDescriptors.size() + " descriptors]";
                }
                if (target == null && (labelTargets = bindingContext.get(BindingContext.AMBIGUOUS_LABEL_TARGET, expression)) != null) {
                    target = "[" + labelTargets.size() + " elements]";
                }
                if (MAY_BE_UNRESOLVED.contains(referencedNameElementType)) {
                    return;
                }
                boolean resolved = target != null;
                boolean markedWithError = markedWithErrorElements.containsKey(expression);
                if (expression instanceof JetArrayAccessExpression && markedWithErrorElements.containsKey(((JetArrayAccessExpression)expression).getArrayExpression())) {
                    markedWithError = true;
                }
                JetType expressionType = bindingContext.get(BindingContext.EXPRESSION_TYPE, expression);
                DiagnosticFactory factory2 = (DiagnosticFactory)markedWithErrorElements.get(expression);
                if (declarationDescriptor != null && (ErrorUtils.isError(declarationDescriptor) || ErrorUtils.containsErrorType(expressionType)) && factory2 != Errors.EXPRESSION_EXPECTED_PACKAGE_FOUND) {
                    debugInfoReporter.reportElementWithErrorType(expression);
                }
                if (resolved && markedWithError) {
                    if (Errors.UNRESOLVED_REFERENCE_DIAGNOSTICS.contains(factory2)) {
                        debugInfoReporter.reportUnresolvedWithTarget(expression, target);
                    }
                } else if (!resolved && !markedWithError) {
                    debugInfoReporter.reportMissingUnresolved(expression);
                }
            }

            private <E extends JetElement, K, D extends CallableDescriptor> boolean reportIfDynamicCall(E element, K key, WritableSlice<K, ResolvedCall<D>> slice) {
                ResolvedCall<D> resolvedCall = bindingContext.get(slice, key);
                if (resolvedCall != null) {
                    return DebugInfoUtil.reportIfDynamic(element, resolvedCall.getResultingDescriptor(), debugInfoReporter);
                }
                return false;
            }
        });
    }

    private static boolean reportIfDynamic(JetElement element, DeclarationDescriptor declarationDescriptor, DebugInfoReporter debugInfoReporter) {
        if (declarationDescriptor != null && TasksPackage.isDynamic(declarationDescriptor)) {
            debugInfoReporter.reportDynamicCall(element, declarationDescriptor);
            return true;
        }
        return false;
    }

    public static abstract class DebugInfoReporter {
        public void preProcessReference(@NotNull JetReferenceExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/checkers/DebugInfoUtil$DebugInfoReporter", "preProcessReference"));
            }
        }

        public abstract void reportElementWithErrorType(@NotNull JetReferenceExpression var1);

        public abstract void reportMissingUnresolved(@NotNull JetReferenceExpression var1);

        public abstract void reportUnresolvedWithTarget(@NotNull JetReferenceExpression var1, @NotNull String var2);

        public void reportDynamicCall(@NotNull JetElement element, DeclarationDescriptor declarationDescriptor) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/checkers/DebugInfoUtil$DebugInfoReporter", "reportDynamicCall"));
            }
        }
    }
}

