/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import jline.AnsiWindowsTerminal;
import jline.Terminal;
import jline.UnixTerminal;
import jline.UnsupportedTerminal;
import jline.internal.Configuration;
import jline.internal.Log;

public class TerminalFactory {
    private static final InheritableThreadLocal<Terminal> holder = new InheritableThreadLocal();
    private static final Map<Flavor, Class<? extends Terminal>> FLAVORS = new HashMap<Flavor, Class<? extends Terminal>>();

    public static synchronized Terminal create() {
        Terminal t;
        block13: {
            if (Log.TRACE) {
                Log.trace(new Throwable("CREATE MARKER"));
            }
            String type2 = Configuration.getString("jline.terminal", "auto");
            if (System.getenv("TERM") == "dumb") {
                type2 = "none";
                Log.debug("$TERM=dumb; setting type=", type2);
            }
            Log.debug("Creating terminal; type=", type2);
            try {
                String tmp = type2.toLowerCase();
                if (tmp.equals("unix")) {
                    t = TerminalFactory.getFlavor(Flavor.UNIX);
                    break block13;
                }
                if (tmp.equals("win") | tmp.equals("windows")) {
                    t = TerminalFactory.getFlavor(Flavor.WINDOWS);
                    break block13;
                }
                if (tmp.equals("none") || tmp.equals("off") || tmp.equals("false")) {
                    t = new UnsupportedTerminal();
                    break block13;
                }
                if (tmp.equals("auto")) {
                    String os = Configuration.getOsName();
                    Flavor flavor = Flavor.UNIX;
                    if (os.contains("windows")) {
                        flavor = Flavor.WINDOWS;
                    }
                    t = TerminalFactory.getFlavor(flavor);
                    break block13;
                }
                try {
                    t = (Terminal)Thread.currentThread().getContextClassLoader().loadClass(type2).newInstance();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(MessageFormat.format("Invalid terminal type: {0}", type2), e);
                }
            }
            catch (Exception e) {
                Log.error("Failed to construct terminal; falling back to unsupported", e);
                t = new UnsupportedTerminal();
            }
        }
        Log.debug("Created Terminal: ", t);
        try {
            t.init();
        }
        catch (Throwable e) {
            Log.error("Terminal initialization failed; falling back to unsupported", e);
            return new UnsupportedTerminal();
        }
        return t;
    }

    public static synchronized void reset() {
        holder.remove();
    }

    public static synchronized void resetIf(Terminal t) {
        if (holder.get() == t) {
            TerminalFactory.reset();
        }
    }

    public static synchronized Terminal get() {
        Terminal t = (Terminal)holder.get();
        if (t == null) {
            t = TerminalFactory.create();
            holder.set(t);
        }
        return t;
    }

    public static Terminal getFlavor(Flavor flavor) throws Exception {
        Class<? extends Terminal> type2 = FLAVORS.get((Object)flavor);
        if (type2 != null) {
            return type2.newInstance();
        }
        throw new InternalError();
    }

    public static void registerFlavor(Flavor flavor, Class<? extends Terminal> type2) {
        FLAVORS.put(flavor, type2);
    }

    static {
        TerminalFactory.registerFlavor(Flavor.WINDOWS, AnsiWindowsTerminal.class);
        TerminalFactory.registerFlavor(Flavor.UNIX, UnixTerminal.class);
    }

    public static enum Flavor {
        WINDOWS,
        UNIX;

    }
}

