/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Function;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class NativeLibrary {
    private long handle;
    private final String libraryName;
    private final String libraryPath;
    private final Map functions = new HashMap();
    final int callFlags;
    final Map options;
    private static final Map libraries = new HashMap();
    private static final Map searchPaths = Collections.synchronizedMap(new HashMap());
    private static final List librarySearchPath = new LinkedList();
    static /* synthetic */ Class class$com$sun$jna$LastErrorException;

    private static String functionKey(String name, int flags) {
        return new StringBuffer().append(name).append("|").append(flags).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NativeLibrary(String libraryName, String libraryPath, long handle, Map options) {
        int callingConvention;
        this.libraryName = this.getLibraryName(libraryName);
        this.libraryPath = libraryPath;
        this.handle = handle;
        Object option = options.get("calling-convention");
        this.callFlags = callingConvention = option instanceof Integer ? (Integer)option : 0;
        this.options = options;
        if (Platform.isWindows() && "kernel32".equals(this.libraryName.toLowerCase())) {
            Map map = this.functions;
            synchronized (map) {
                Function f = new Function(this, "GetLastError", 1){

                    @Override
                    Object invoke(Object[] args, Class returnType, boolean b) {
                        return new Integer(Native.getLastError());
                    }
                };
                this.functions.put(NativeLibrary.functionKey("GetLastError", this.callFlags), f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NativeLibrary loadLibrary(String libraryName, Map options) {
        long handle;
        String libraryPath;
        block23: {
            List customPaths;
            LinkedList<String> searchPath = new LinkedList<String>();
            String webstartPath = Native.getWebStartLibraryPath(libraryName);
            if (webstartPath != null) {
                searchPath.add(webstartPath);
            }
            if ((customPaths = (List)searchPaths.get(libraryName)) != null) {
                List list = customPaths;
                synchronized (list) {
                    searchPath.addAll(0, customPaths);
                }
            }
            searchPath.addAll(NativeLibrary.initPaths("jna.library.path"));
            libraryPath = NativeLibrary.findLibraryPath(libraryName, searchPath);
            handle = 0L;
            try {
                handle = Native.open(libraryPath);
            }
            catch (UnsatisfiedLinkError e) {
                searchPath.addAll(librarySearchPath);
            }
            try {
                if (handle == 0L && (handle = Native.open(libraryPath = NativeLibrary.findLibraryPath(libraryName, searchPath))) == 0L) {
                    throw new UnsatisfiedLinkError(new StringBuffer().append("Failed to load library '").append(libraryName).append("'").toString());
                }
            }
            catch (UnsatisfiedLinkError e) {
                if (Platform.isLinux()) {
                    libraryPath = NativeLibrary.matchLibrary(libraryName, searchPath);
                    if (libraryPath != null) {
                        try {
                            handle = Native.open(libraryPath);
                        }
                        catch (UnsatisfiedLinkError e2) {
                            e = e2;
                        }
                    }
                } else if (Platform.isMac() && !libraryName.endsWith(".dylib")) {
                    libraryPath = new StringBuffer().append("/System/Library/Frameworks/").append(libraryName).append(".framework/").append(libraryName).toString();
                    if (new File(libraryPath).exists()) {
                        try {
                            handle = Native.open(libraryPath);
                        }
                        catch (UnsatisfiedLinkError e2) {
                            e = e2;
                        }
                    }
                } else if (Platform.isWindows()) {
                    libraryPath = NativeLibrary.findLibraryPath(new StringBuffer().append("lib").append(libraryName).toString(), searchPath);
                    try {
                        handle = Native.open(libraryPath);
                    }
                    catch (UnsatisfiedLinkError e2) {
                        e = e2;
                    }
                }
                if (handle != 0L) break block23;
                throw new UnsatisfiedLinkError(new StringBuffer().append("Unable to load library '").append(libraryName).append("': ").append(e.getMessage()).toString());
            }
        }
        return new NativeLibrary(libraryName, libraryPath, handle, options);
    }

    private String getLibraryName(String libraryName) {
        String suffix;
        int suffixStart;
        String simplified = libraryName;
        String BASE = "---";
        String template = NativeLibrary.mapLibraryName("---");
        int prefixEnd = template.indexOf("---");
        if (prefixEnd > 0 && simplified.startsWith(template.substring(0, prefixEnd))) {
            simplified = simplified.substring(prefixEnd);
        }
        if ((suffixStart = simplified.indexOf(suffix = template.substring(prefixEnd + "---".length()))) != -1) {
            simplified = simplified.substring(0, suffixStart);
        }
        return simplified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final NativeLibrary getInstance(String libraryName, Map options) {
        if ((options = new HashMap<String, Integer>(options)).get("calling-convention") == null) {
            options.put("calling-convention", new Integer(0));
        }
        if (Platform.isLinux() && "c".equals(libraryName)) {
            libraryName = null;
        }
        Map map = libraries;
        synchronized (map) {
            NativeLibrary library;
            WeakReference<NativeLibrary> ref = (WeakReference<NativeLibrary>)libraries.get(new StringBuffer().append(libraryName).append(options).toString());
            NativeLibrary nativeLibrary = library = ref != null ? (NativeLibrary)ref.get() : null;
            if (library == null) {
                library = libraryName == null ? new NativeLibrary("<process>", null, Native.open(null), options) : NativeLibrary.loadLibrary(libraryName, options);
                ref = new WeakReference<NativeLibrary>(library);
                libraries.put(new StringBuffer().append(library.getName()).append(options).toString(), ref);
                File file = library.getFile();
                if (file != null) {
                    libraries.put(new StringBuffer().append(file.getAbsolutePath()).append(options).toString(), ref);
                    libraries.put(new StringBuffer().append(file.getName()).append(options).toString(), ref);
                }
            }
            return library;
        }
    }

    Function getFunction(String name, Method method) {
        int flags = this.callFlags;
        Class<?>[] etypes = method.getExceptionTypes();
        for (int i = 0; i < etypes.length; ++i) {
            if (!(class$com$sun$jna$LastErrorException == null ? NativeLibrary.class$("com.sun.jna.LastErrorException") : class$com$sun$jna$LastErrorException).isAssignableFrom(etypes[i])) continue;
            flags |= 4;
        }
        return this.getFunction(name, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function getFunction(String functionName, int callFlags) {
        if (functionName == null) {
            throw new NullPointerException("Function name may not be null");
        }
        Map map = this.functions;
        synchronized (map) {
            String key = NativeLibrary.functionKey(functionName, callFlags);
            Function function = (Function)this.functions.get(key);
            if (function == null) {
                function = new Function(this, functionName, callFlags);
                this.functions.put(key, function);
            }
            return function;
        }
    }

    long getSymbolAddress(String name) {
        if (this.handle == 0L) {
            throw new UnsatisfiedLinkError("Library has been unloaded");
        }
        return Native.findSymbol(this.handle, name);
    }

    public String toString() {
        return new StringBuffer().append("Native Library <").append(this.libraryPath).append("@").append(this.handle).append(">").toString();
    }

    public String getName() {
        return this.libraryName;
    }

    public File getFile() {
        if (this.libraryPath == null) {
            return null;
        }
        return new File(this.libraryPath);
    }

    protected void finalize() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disposeAll() {
        HashSet values;
        Map map = libraries;
        synchronized (map) {
            values = new HashSet(libraries.values());
        }
        for (WeakReference ref : values) {
            NativeLibrary lib = (NativeLibrary)ref.get();
            if (lib == null) continue;
            lib.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object2 = libraries;
        synchronized (object2) {
            Iterator i = libraries.values().iterator();
            while (i.hasNext()) {
                WeakReference ref = (WeakReference)i.next();
                if (ref.get() != this) continue;
                i.remove();
            }
        }
        object2 = this;
        synchronized (object2) {
            if (this.handle != 0L) {
                Native.close(this.handle);
                this.handle = 0L;
            }
        }
    }

    private static List initPaths(String key) {
        String value = System.getProperty(key, "");
        if ("".equals(value)) {
            return Collections.EMPTY_LIST;
        }
        StringTokenizer st = new StringTokenizer(value, File.pathSeparator);
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            if ("".equals(path)) continue;
            list.add(path);
        }
        return list;
    }

    private static String findLibraryPath(String libName, List searchPath) {
        if (new File(libName).isAbsolute()) {
            return libName;
        }
        String name = NativeLibrary.mapLibraryName(libName);
        for (String path : searchPath) {
            File file = new File(path, name);
            if (file.exists()) {
                return file.getAbsolutePath();
            }
            if (!Platform.isMac() || !name.endsWith(".dylib") || !(file = new File(path, new StringBuffer().append(name.substring(0, name.lastIndexOf(".dylib"))).append(".jnilib").toString())).exists()) continue;
            return file.getAbsolutePath();
        }
        return name;
    }

    private static String mapLibraryName(String libName) {
        if (Platform.isMac()) {
            if (libName.startsWith("lib") && (libName.endsWith(".dylib") || libName.endsWith(".jnilib"))) {
                return libName;
            }
            String name = System.mapLibraryName(libName);
            if (name.endsWith(".jnilib")) {
                return new StringBuffer().append(name.substring(0, name.lastIndexOf(".jnilib"))).append(".dylib").toString();
            }
            return name;
        }
        if (Platform.isLinux() ? NativeLibrary.isVersionedName(libName) || libName.endsWith(".so") : Platform.isWindows() && (libName.endsWith(".drv") || libName.endsWith(".dll"))) {
            return libName;
        }
        return System.mapLibraryName(libName);
    }

    private static boolean isVersionedName(String name) {
        int so;
        if (name.startsWith("lib") && (so = name.lastIndexOf(".so.")) != -1 && so + 4 < name.length()) {
            for (int i = so + 4; i < name.length(); ++i) {
                char ch = name.charAt(i);
                if (Character.isDigit(ch) || ch == '.') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static String matchLibrary(final String libName, List searchPath) {
        File lib = new File(libName);
        if (lib.isAbsolute()) {
            searchPath = Arrays.asList(lib.getParent());
        }
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return (filename.startsWith(new StringBuffer().append("lib").append(libName).append(".so").toString()) || filename.startsWith(new StringBuffer().append(libName).append(".so").toString()) && libName.startsWith("lib")) && NativeLibrary.isVersionedName(filename);
            }
        };
        LinkedList<File> matches = new LinkedList<File>();
        Iterator<String> it = searchPath.iterator();
        while (it.hasNext()) {
            File[] files = new File(it.next()).listFiles(filter);
            if (files == null || files.length <= 0) continue;
            matches.addAll(Arrays.asList(files));
        }
        double bestVersion = -1.0;
        String bestMatch = null;
        Iterator it2 = matches.iterator();
        while (it2.hasNext()) {
            String path = ((File)it2.next()).getAbsolutePath();
            String ver = path.substring(path.lastIndexOf(".so.") + 4);
            double version = NativeLibrary.parseVersion(ver);
            if (!(version > bestVersion)) continue;
            bestVersion = version;
            bestMatch = path;
        }
        return bestMatch;
    }

    static double parseVersion(String ver) {
        double v = 0.0;
        double divisor = 1.0;
        int dot = ver.indexOf(".");
        while (ver != null) {
            String num;
            if (dot != -1) {
                num = ver.substring(0, dot);
                ver = ver.substring(dot + 1);
                dot = ver.indexOf(".");
            } else {
                num = ver;
                ver = null;
            }
            try {
                v += (double)Integer.parseInt(num) / divisor;
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
            divisor *= 100.0;
        }
        return v;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        if (Native.POINTER_SIZE == 0) {
            throw new Error("Native library not initialized");
        }
        String webstartPath = Native.getWebStartLibraryPath("jnidispatch");
        if (webstartPath != null) {
            librarySearchPath.add(webstartPath);
        }
        if (System.getProperty("jna.platform.library.path") == null && !Platform.isWindows()) {
            String platformPath = "";
            String sep = "";
            String archPath = "";
            if (Platform.isLinux() || Platform.isSolaris() || Platform.isFreeBSD()) {
                archPath = new StringBuffer().append(Platform.isSolaris() ? "/" : "").append(Pointer.SIZE * 8).toString();
            }
            String[] paths = new String[]{new StringBuffer().append("/usr/lib").append(archPath).toString(), new StringBuffer().append("/lib").append(archPath).toString(), "/usr/lib", "/lib"};
            if (Platform.isLinux()) {
                String cpu = "";
                String kernel = "linux";
                String libc = "gnu";
                if (Platform.isIntel()) {
                    cpu = Platform.is64Bit() ? "x86_64" : "i386";
                } else if (Platform.isPPC()) {
                    cpu = Platform.is64Bit() ? "powerpc64" : "powerpc";
                } else if (Platform.isARM()) {
                    cpu = "arm";
                    libc = "gnueabi";
                }
                String multiArchPath = new StringBuffer().append(cpu).append("-").append(kernel).append("-").append(libc).toString();
                paths = new String[]{new StringBuffer().append("/usr/lib/").append(multiArchPath).toString(), new StringBuffer().append("/lib/").append(multiArchPath).toString(), new StringBuffer().append("/usr/lib").append(archPath).toString(), new StringBuffer().append("/lib").append(archPath).toString(), "/usr/lib", "/lib"};
            }
            for (int i = 0; i < paths.length; ++i) {
                File dir = new File(paths[i]);
                if (!dir.exists() || !dir.isDirectory()) continue;
                platformPath = new StringBuffer().append(platformPath).append(sep).append(paths[i]).toString();
                sep = File.pathSeparator;
            }
            if (!"".equals(platformPath)) {
                System.setProperty("jna.platform.library.path", platformPath);
            }
        }
        librarySearchPath.addAll(NativeLibrary.initPaths("jna.platform.library.path"));
    }
}

