/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.lang.properties.charset.Native2AsciiCharset;
import com.intellij.openapi.fileTypes.BinaryFileDecompiler;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.CharsetUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.CharArrayUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LoadTextUtil {
    private static final boolean GUESS_UTF = Boolean.parseBoolean(System.getProperty("idea.guess.utf.encoding", "true"));
    private static final Key<String> CHARSET_WAS_DETECTED_FROM_BYTES = Key.create("CHARSET_WAS_DETECTED_FROM_BYTES");

    @NotNull
    private static Pair<CharSequence, String> convertLineSeparators(@NotNull CharBuffer buffer) {
        CharSequence result2;
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "convertLineSeparators"));
        }
        int dst = 0;
        int prev = 32;
        int crCount = 0;
        int lfCount = 0;
        int crlfCount = 0;
        int length = buffer.length();
        char[] bufferArray = CharArrayUtil.fromSequenceWithoutCopying(buffer);
        for (int src = 0; src < length; ++src) {
            int c = bufferArray != null ? bufferArray[src] : buffer.charAt(src);
            switch (c) {
                case 13: {
                    if (bufferArray != null) {
                        bufferArray[dst++] = 10;
                    } else {
                        buffer.put(dst++, '\n');
                    }
                    ++crCount;
                    break;
                }
                case 10: {
                    if (prev == 13) {
                        --crCount;
                        ++crlfCount;
                        break;
                    }
                    if (bufferArray != null) {
                        bufferArray[dst++] = 10;
                    } else {
                        buffer.put(dst++, '\n');
                    }
                    ++lfCount;
                    break;
                }
                default: {
                    if (bufferArray != null) {
                        bufferArray[dst++] = c;
                        break;
                    }
                    buffer.put(dst++, (char)c);
                }
            }
            prev = c;
        }
        String detectedLineSeparator = null;
        if (crlfCount > crCount && crlfCount > lfCount) {
            detectedLineSeparator = "\r\n";
        } else if (crCount > lfCount) {
            detectedLineSeparator = "\r";
        } else if (lfCount > 0) {
            detectedLineSeparator = "\n";
        }
        if (buffer.length() == dst) {
            result2 = buffer;
        } else {
            CharBuffer seq = buffer;
            result2 = seq.subSequence(0, dst);
        }
        Pair<CharSequence, String> pair = Pair.create(result2, detectedLineSeparator);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "convertLineSeparators"));
        }
        return pair;
    }

    public static Charset detectCharset(@NotNull VirtualFile virtualFile, @NotNull byte[] content, @NotNull FileType fileType) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectCharset"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectCharset"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectCharset"));
        }
        Charset charset = null;
        Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> guessed = LoadTextUtil.guessFromContent(virtualFile, content, content.length);
        if (guessed != null && guessed.first != null) {
            charset = (Charset)guessed.first;
        } else {
            String charsetName = fileType.getCharset(virtualFile, content);
            if (charsetName == null) {
                Charset specifiedExplicitly = EncodingRegistry.getInstance().getEncoding(virtualFile, true);
                if (specifiedExplicitly != null) {
                    charset = specifiedExplicitly;
                }
            } else {
                charset = CharsetToolkit.forName(charsetName);
            }
        }
        Charset charset2 = charset = charset == null ? EncodingRegistry.getInstance().getDefaultCharset() : charset;
        if (fileType.getName().equals("Properties") && EncodingRegistry.getInstance().isNative2AsciiForPropertiesFiles()) {
            charset = Native2AsciiCharset.wrap(charset);
        }
        virtualFile.setCharset(charset);
        return charset;
    }

    @NotNull
    public static Charset detectCharsetAndSetBOM(@NotNull VirtualFile virtualFile, @NotNull byte[] content) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectCharsetAndSetBOM"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectCharsetAndSetBOM"));
        }
        Charset charset = LoadTextUtil.doDetectCharsetAndSetBOM(virtualFile, content, true).getFirst();
        if (charset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectCharsetAndSetBOM"));
        }
        return charset;
    }

    @NotNull
    private static Pair<Charset, byte[]> doDetectCharsetAndSetBOM(@NotNull VirtualFile virtualFile, @NotNull byte[] content, boolean saveBOM) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "doDetectCharsetAndSetBOM"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "doDetectCharsetAndSetBOM"));
        }
        Pair<Charset, byte[]> pair = LoadTextUtil.doDetectCharsetAndSetBOM(virtualFile, content, saveBOM, virtualFile.getFileType());
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "doDetectCharsetAndSetBOM"));
        }
        return pair;
    }

    @NotNull
    private static Pair<Charset, byte[]> doDetectCharsetAndSetBOM(@NotNull VirtualFile virtualFile, @NotNull byte[] content, boolean saveBOM, @NotNull FileType fileType) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "doDetectCharsetAndSetBOM"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "doDetectCharsetAndSetBOM"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "doDetectCharsetAndSetBOM"));
        }
        Charset charset = virtualFile.isCharsetSet() ? virtualFile.getCharset() : LoadTextUtil.detectCharset(virtualFile, content, fileType);
        Pair<Charset, byte[]> bomAndCharset = LoadTextUtil.getBOMAndCharset(content, charset);
        byte[] bom = (byte[])bomAndCharset.second;
        if (saveBOM && bom != null && bom.length != 0) {
            virtualFile.setBOM(bom);
            LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, "auto-detected from BOM");
        }
        Pair<Charset, byte[]> pair = bomAndCharset;
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "doDetectCharsetAndSetBOM"));
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable(value="null means no luck, otherwise it's tuple(guessed encoding, hint about content if was unable to guess, BOM)")
    public static Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> guessFromContent(@NotNull VirtualFile virtualFile, @NotNull byte[] content, int length) {
        String detectedFromBytes;
        block9: {
            CharsetToolkit.GuessedEncoding guessed;
            block11: {
                CharsetToolkit toolkit;
                block10: {
                    if (virtualFile == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "guessFromContent"));
                    }
                    if (content == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "guessFromContent"));
                    }
                    toolkit = GUESS_UTF ? new CharsetToolkit(content, EncodingRegistry.getInstance().getDefaultCharset()) : null;
                    detectedFromBytes = null;
                    if (!GUESS_UTF) break block9;
                    toolkit.setEnforce8Bit(true);
                    Charset charset = toolkit.guessFromBOM();
                    if (charset == null) break block10;
                    detectedFromBytes = "auto-detected from BOM";
                    byte[] bom = CharsetToolkit.getMandatoryBom(charset);
                    if (bom == null) {
                        bom = CharsetToolkit.UTF8_BOM;
                    }
                    Trinity<Charset, Object, byte[]> trinity = Trinity.create(charset, null, bom);
                    LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, detectedFromBytes);
                    return trinity;
                }
                guessed = toolkit.guessFromContent(length);
                if (guessed != CharsetToolkit.GuessedEncoding.VALID_UTF8) break block11;
                detectedFromBytes = "auto-detected from bytes";
                Trinity<Charset, CharsetToolkit.GuessedEncoding, Object> trinity = Trinity.create(CharsetToolkit.UTF8_CHARSET, guessed, null);
                LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, detectedFromBytes);
                return trinity;
            }
            if (guessed != CharsetToolkit.GuessedEncoding.SEVEN_BIT) break block9;
            Trinity<Object, CharsetToolkit.GuessedEncoding, Object> trinity = Trinity.create(null, guessed, null);
            LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, detectedFromBytes);
            return trinity;
        }
        try {
            Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> trinity = null;
            return trinity;
        }
        finally {
            LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, detectedFromBytes);
        }
    }

    @NotNull
    private static Pair<Charset, byte[]> getBOMAndCharset(@NotNull byte[] content, Charset charset) {
        block7: {
            Pair<Charset, byte[]> pair;
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getBOMAndCharset"));
            }
            if (charset != null && charset.name().contains("UTF-8") && CharsetToolkit.hasUTF8Bom(content)) {
                Pair<Charset, byte[]> pair2 = Pair.create(charset, CharsetToolkit.UTF8_BOM);
                if (pair2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getBOMAndCharset"));
                }
                return pair2;
            }
            try {
                Charset fromBOM = CharsetToolkit.guessFromBOM(content);
                if (fromBOM == null) break block7;
                pair = Pair.create(fromBOM, CharsetToolkit.getMandatoryBom(fromBOM));
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getBOMAndCharset"));
            }
            return pair;
        }
        Pair<Charset, byte[]> pair = Pair.create(charset, ArrayUtil.EMPTY_BYTE_ARRAY);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getBOMAndCharset"));
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull Object requestor, @NotNull String text, long newModificationStamp) throws IOException {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "write"));
        }
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "write"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "write"));
        }
        Charset existing = virtualFile.getCharset();
        Pair<Charset, byte[]> chosen = LoadTextUtil.charsetForWriting(project, virtualFile, text, existing);
        Charset charset = (Charset)chosen.first;
        byte[] buffer = (byte[])chosen.second;
        if (charset != null && !charset.equals(existing)) {
            virtualFile.setCharset(charset);
        }
        LoadTextUtil.setDetectedFromBytesFlagBack(virtualFile, buffer);
        OutputStream outputStream = virtualFile.getOutputStream(requestor, newModificationStamp, -1L);
        try {
            outputStream.write(buffer);
        }
        finally {
            outputStream.close();
        }
    }

    @NotNull
    private static Pair<Charset, byte[]> charsetForWriting(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull String text, @Nullable Charset existing) {
        Charset fromBom;
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "charsetForWriting"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "charsetForWriting"));
        }
        Charset specified = LoadTextUtil.extractCharsetFromFileContent(project, virtualFile, text);
        Pair<Charset, byte[]> chosen = LoadTextUtil.chooseMostlyHarmlessCharset(existing, specified, text);
        Charset charset = (Charset)chosen.first;
        byte[] bom = virtualFile.getBOM();
        Charset charset2 = fromBom = bom == null ? null : CharsetToolkit.guessFromBOM(bom);
        if (fromBom != null && !fromBom.equals(charset)) {
            chosen = Pair.create(fromBom, LoadTextUtil.toBytes(text, fromBom));
        }
        Pair<Charset, byte[]> pair = chosen;
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "charsetForWriting"));
        }
        return pair;
    }

    public static void setDetectedFromBytesFlagBack(@NotNull VirtualFile virtualFile, @NotNull byte[] content) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "setDetectedFromBytesFlagBack"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "setDetectedFromBytesFlagBack"));
        }
        if (virtualFile.getBOM() == null) {
            LoadTextUtil.guessFromContent(virtualFile, content, content.length);
        } else {
            LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, "auto-detected from BOM");
        }
    }

    @NotNull
    public static Pair<Charset, byte[]> chooseMostlyHarmlessCharset(Charset existing, Charset specified, @NotNull String text) {
        block16: {
            byte[] out;
            block15: {
                block14: {
                    block13: {
                        Pair<Charset, byte[]> pair;
                        if (text == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
                        }
                        try {
                            if (existing != null) break block13;
                            pair = Pair.create(specified, LoadTextUtil.toBytes(text, specified));
                        }
                        catch (RuntimeException e) {
                            Pair<Charset, byte[]> pair2 = Pair.create(Charset.defaultCharset(), LoadTextUtil.toBytes(text, null));
                            if (pair2 == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
                            }
                            return pair2;
                        }
                        if (pair == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
                        }
                        return pair;
                    }
                    if (specified != null && !specified.equals(existing)) break block14;
                    Pair<Charset, byte[]> pair = Pair.create(specified, LoadTextUtil.toBytes(text, existing));
                    if (pair == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
                    }
                    return pair;
                }
                out = LoadTextUtil.isSupported(specified, text);
                if (out == null) break block15;
                Pair<Charset, byte[]> pair = Pair.create(specified, out);
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
                }
                return pair;
            }
            out = LoadTextUtil.isSupported(existing, text);
            if (out == null) break block16;
            Pair<Charset, byte[]> pair = Pair.create(existing, out);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
            }
            return pair;
        }
        Pair<Charset, byte[]> pair = Pair.create(specified, LoadTextUtil.toBytes(text, specified));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
        }
        return pair;
    }

    @NotNull
    private static byte[] toBytes(@NotNull String text, @Nullable Charset charset) throws RuntimeException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "toBytes"));
        }
        byte[] byArray = charset == null ? text.getBytes() : text.getBytes(charset);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "toBytes"));
        }
        return byArray;
    }

    @Nullable(value="null means not supported, otherwise it is converted byte stream")
    private static byte[] isSupported(@NotNull Charset charset, @NotNull String str) {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "isSupported"));
        }
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "isSupported"));
        }
        try {
            if (!charset.canEncode()) {
                return null;
            }
            byte[] bytes = str.getBytes(charset);
            if (!str.equals(new String(bytes, charset))) {
                return null;
            }
            return bytes;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Charset extractCharsetFromFileContent(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull String text) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "extractCharsetFromFileContent"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "extractCharsetFromFileContent"));
        }
        Charset charset = LoadTextUtil.charsetFromContentOrNull(project, virtualFile, text);
        if (charset == null) {
            charset = virtualFile.getCharset();
        }
        return charset;
    }

    @Nullable(value="returns null if cannot determine from content")
    public static Charset charsetFromContentOrNull(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull String text) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "charsetFromContentOrNull"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "charsetFromContentOrNull"));
        }
        return CharsetUtil.extractCharsetFromFileContent(project, virtualFile, virtualFile.getFileType(), text);
    }

    @NotNull
    public static CharSequence loadText(@NotNull VirtualFile file) {
        CharSequence charSequence;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "loadText"));
        }
        if (file instanceof LightVirtualFile) {
            CharSequence charSequence2 = ((LightVirtualFile)file).getContent();
            if (charSequence2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "loadText"));
            }
            return charSequence2;
        }
        if (file.isDirectory()) {
            throw new AssertionError((Object)("'" + file.getPresentableUrl() + "' is a directory"));
        }
        FileType fileType = file.getFileType();
        if (fileType.isBinary()) {
            BinaryFileDecompiler decompiler = (BinaryFileDecompiler)BinaryFileTypeDecompilers.INSTANCE.forFileType(fileType);
            if (decompiler != null) {
                CharSequence text = decompiler.decompile(file);
                StringUtil.assertValidSeparators(text);
                CharSequence charSequence3 = text;
                if (charSequence3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "loadText"));
                }
                return charSequence3;
            }
            throw new IllegalArgumentException("Attempt to load text for binary file which doesn't have a decompiler plugged in: " + file.getPresentableUrl());
        }
        try {
            byte[] bytes = file.contentsToByteArray();
            charSequence = LoadTextUtil.getTextByBinaryPresentation(bytes, file);
        }
        catch (IOException e) {
            CharSequence charSequence4 = ArrayUtil.EMPTY_CHAR_SEQUENCE;
            if (charSequence4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "loadText"));
            }
            return charSequence4;
        }
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "loadText"));
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, @NotNull VirtualFile virtualFile) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        CharSequence charSequence = LoadTextUtil.getTextByBinaryPresentation(bytes, virtualFile, true, true);
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, @NotNull VirtualFile virtualFile, boolean saveDetectedSeparators, boolean saveBOM) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        CharSequence charSequence = LoadTextUtil.getTextByBinaryPresentation(bytes, virtualFile, saveDetectedSeparators, saveBOM, virtualFile.getFileType());
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, @NotNull VirtualFile virtualFile, boolean saveDetectedSeparators, boolean saveBOM, @NotNull FileType fileType) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        Pair<Charset, byte[]> pair = LoadTextUtil.doDetectCharsetAndSetBOM(virtualFile, bytes, saveBOM, fileType);
        Charset charset = pair.getFirst();
        byte[] bom = pair.getSecond();
        int offset = bom == null ? 0 : bom.length;
        Pair<CharSequence, String> result2 = LoadTextUtil.convertBytes(bytes, charset, offset);
        if (saveDetectedSeparators) {
            virtualFile.setDetectedLineSeparator(result2.getSecond());
        }
        CharSequence charSequence = result2.getFirst();
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, Charset charset) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        Pair<Charset, byte[]> pair = LoadTextUtil.getBOMAndCharset(bytes, charset);
        byte[] bom = pair.getSecond();
        int offset = bom == null ? 0 : bom.length;
        Pair<CharSequence, String> result2 = LoadTextUtil.convertBytes(bytes, charset, offset);
        CharSequence charSequence = result2.getFirst();
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        return charSequence;
    }

    @NotNull
    private static Pair<CharSequence, String> convertBytes(@NotNull byte[] bytes, Charset charset, int startOffset) {
        CharBuffer charBuffer;
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "convertBytes"));
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, startOffset, bytes.length - startOffset);
        if (charset == null) {
            charset = CharsetToolkit.getDefaultSystemCharset();
        }
        if (charset == null) {
            charset = Charset.forName("ISO-8859-1");
        }
        try {
            charBuffer = charset.decode(byteBuffer);
        }
        catch (Exception e) {
            charBuffer = CharBuffer.wrap(ArrayUtil.EMPTY_CHAR_ARRAY);
        }
        Pair<CharSequence, String> pair = LoadTextUtil.convertLineSeparators(charBuffer);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "convertBytes"));
        }
        return pair;
    }

    public static void setCharsetWasDetectedFromBytes(@NotNull VirtualFile virtualFile, @Nullable(value="null if was not detected, otherwise the reason it was") String reason) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "setCharsetWasDetectedFromBytes"));
        }
        virtualFile.putUserData(CHARSET_WAS_DETECTED_FROM_BYTES, reason);
    }
}

