/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

public class JsParserException
extends Exception {
    private final SourceDetail sourceDetail;

    private static String createMessageWithDetail(String msg, SourceDetail sourceDetail) {
        if (sourceDetail == null) {
            return msg;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(sourceDetail.getFileName());
        sb.append('(');
        sb.append(sourceDetail.getLine());
        sb.append(')');
        sb.append(": ");
        sb.append(msg);
        if (sourceDetail.getLineSource() != null) {
            sb.append("\n> ");
            sb.append(sourceDetail.getLineSource());
            sb.append("\n> ");
            int n = sourceDetail.getLineOffset();
            for (int i = 0; i < n; ++i) {
                sb.append('-');
            }
            sb.append('^');
        }
        return sb.toString();
    }

    public JsParserException(String msg, int line, String lineSource, int lineOffset, String fileName) {
        this(msg, new SourceDetail(line, lineSource, lineOffset, fileName));
    }

    public JsParserException(String msg, SourceDetail sourceDetail) {
        super(JsParserException.createMessageWithDetail(msg, sourceDetail));
        this.sourceDetail = sourceDetail;
    }

    public static class SourceDetail {
        private final String fileName;
        private final int line;
        private final int lineOffset;
        private final String lineSource;

        public SourceDetail(int line, String lineSource, int lineOffset, String fileName) {
            this.line = line;
            this.lineSource = lineSource;
            this.lineOffset = lineOffset;
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public int getLine() {
            return this.line;
        }

        public int getLineOffset() {
            return this.lineOffset;
        }

        public String getLineSource() {
            return this.lineSource;
        }
    }
}

