/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.JsVisitorWithContext;
import com.google.dart.compiler.backend.js.ast.SourceInfoAwareJsNode;
import com.google.dart.compiler.util.AstUtil;
import org.jetbrains.annotations.NotNull;

public final class JsIf
extends SourceInfoAwareJsNode
implements JsStatement {
    private JsExpression ifExpression;
    private JsStatement thenStatement;
    private JsStatement elseStatement;

    public JsIf() {
    }

    public JsIf(JsExpression ifExpression, JsStatement thenStatement, JsStatement elseStatement) {
        this.ifExpression = ifExpression;
        this.thenStatement = thenStatement;
        this.elseStatement = elseStatement;
    }

    public JsIf(JsExpression ifExpression, JsStatement thenStatement) {
        this.ifExpression = ifExpression;
        this.thenStatement = thenStatement;
    }

    public JsStatement getElseStatement() {
        return this.elseStatement;
    }

    public JsExpression getIfExpression() {
        return this.ifExpression;
    }

    public JsStatement getThenStatement() {
        return this.thenStatement;
    }

    public void setElseStatement(JsStatement elseStatement) {
        this.elseStatement = elseStatement;
    }

    public void setIfExpression(JsExpression ifExpression) {
        this.ifExpression = ifExpression;
    }

    public void setThenStatement(JsStatement thenStatement) {
        this.thenStatement = thenStatement;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitIf(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor) {
        visitor.accept(this.ifExpression);
        visitor.accept(this.thenStatement);
        if (this.elseStatement != null) {
            visitor.accept(this.elseStatement);
        }
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.ifExpression = v.accept(this.ifExpression);
            this.thenStatement = v.acceptStatement(this.thenStatement);
            if (this.elseStatement != null) {
                this.elseStatement = v.acceptStatement(this.elseStatement);
            }
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsIf deepCopy() {
        JsExpression ifCopy = AstUtil.deepCopy(this.ifExpression);
        JsStatement thenCopy = AstUtil.deepCopy(this.thenStatement);
        JsStatement elseCopy = AstUtil.deepCopy(this.elseStatement);
        JsIf jsIf = new JsIf(ifCopy, thenCopy, elseCopy).withMetadataFrom(this);
        if (jsIf == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsIf", "deepCopy"));
        }
        return jsIf;
    }
}

