/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableListIterator;

class RegularImmutableList<E>
extends ImmutableList<E> {
    private final transient int offset;
    private final transient int size;
    private final transient Object[] array;

    RegularImmutableList(Object[] array, int offset, int size) {
        this.offset = offset;
        this.size = size;
        this.array = array;
    }

    RegularImmutableList(Object[] array) {
        this(array, 0, array.length);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    boolean isPartialView() {
        return this.size != this.array.length;
    }

    @Override
    int copyIntoArray(Object[] dst, int dstOff) {
        System.arraycopy(this.array, this.offset, dst, dstOff, this.size);
        return dstOff + this.size;
    }

    @Override
    public E get(int index2) {
        Preconditions.checkElementIndex(index2, this.size);
        return (E)this.array[index2 + this.offset];
    }

    @Override
    public int indexOf(Object object2) {
        if (object2 == null) {
            return -1;
        }
        for (int i = 0; i < this.size; ++i) {
            if (!this.array[this.offset + i].equals(object2)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object2) {
        if (object2 == null) {
            return -1;
        }
        for (int i = this.size - 1; i >= 0; --i) {
            if (!this.array[this.offset + i].equals(object2)) continue;
            return i;
        }
        return -1;
    }

    @Override
    ImmutableList<E> subListUnchecked(int fromIndex, int toIndex) {
        return new RegularImmutableList<E>(this.array, this.offset + fromIndex, toIndex - fromIndex);
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int index2) {
        return Iterators.forArray(this.array, this.offset, this.size, index2);
    }
}

