/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.operation;

import com.google.common.collect.Lists;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.util.AstUtil;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.resolve.calls.tasks.TasksPackage;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.operation.IntrinsicIncrementTranslator;
import org.jetbrains.k2js.translate.operation.OverloadedIncrementTranslator;
import org.jetbrains.k2js.translate.reference.AccessTranslationUtils;
import org.jetbrains.k2js.translate.reference.CachedAccessTranslator;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;
import org.jetbrains.k2js.translate.utils.TemporariesUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public abstract class IncrementTranslator
extends AbstractTranslator {
    @NotNull
    protected final JetUnaryExpression expression;
    @NotNull
    protected final CachedAccessTranslator accessTranslator;

    public static boolean isIncrement(IElementType operationToken) {
        return OperatorConventions.INCREMENT_OPERATIONS.contains(operationToken);
    }

    @NotNull
    public static JsExpression translate(@NotNull JetUnaryExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/operation/IncrementTranslator", "translate"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/operation/IncrementTranslator", "translate"));
        }
        if (TranslationUtils.hasCorrespondingFunctionIntrinsic(context2, expression) || IncrementTranslator.isDynamic(context2, expression)) {
            JsExpression jsExpression = IntrinsicIncrementTranslator.doTranslate(expression, context2);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/IncrementTranslator", "translate"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = new OverloadedIncrementTranslator(expression, context2).translateIncrementExpression();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/IncrementTranslator", "translate"));
        }
        return jsExpression;
    }

    protected IncrementTranslator(@NotNull JetUnaryExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/operation/IncrementTranslator", "<init>"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/operation/IncrementTranslator", "<init>"));
        }
        super(context2);
        this.expression = expression;
        JetExpression baseExpression = PsiUtils.getBaseExpression(expression);
        this.accessTranslator = AccessTranslationUtils.getCachedAccessTranslator(baseExpression, this.context());
    }

    @NotNull
    protected JsExpression translateIncrementExpression() {
        JsExpression jsExpression = this.withTemporariesInitialized(this.doTranslateIncrementExpression());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/IncrementTranslator", "translateIncrementExpression"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression doTranslateIncrementExpression() {
        if (PsiUtils.isPrefix(this.expression)) {
            JsExpression jsExpression = this.asPrefix();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/IncrementTranslator", "doTranslateIncrementExpression"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = this.asPostfix();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/IncrementTranslator", "doTranslateIncrementExpression"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression asPrefix() {
        JsExpression getExpression = this.accessTranslator.translateAsGet();
        JsExpression reassignment = this.variableReassignment(getExpression);
        JsExpression getNewValue = this.accessTranslator.translateAsGet();
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.COMMA, reassignment, getNewValue);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/IncrementTranslator", "asPrefix"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    private JsExpression asPostfix() {
        TemporaryVariable t1 = this.context().declareTemporary(this.accessTranslator.translateAsGet());
        TemporaryVariable t2 = this.context().declareTemporary(t1.reference());
        JsExpression variableReassignment = this.variableReassignment(t1.reference());
        JsBinaryOperation jsBinaryOperation = AstUtil.newSequence(t1.assignmentExpression(), t2.assignmentExpression(), variableReassignment, t2.reference());
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/IncrementTranslator", "asPostfix"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    private JsExpression variableReassignment(@NotNull JsExpression toCallMethodUpon) {
        if (toCallMethodUpon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toCallMethodUpon", "org/jetbrains/k2js/translate/operation/IncrementTranslator", "variableReassignment"));
        }
        JsExpression overloadedMethodCallOnPropertyGetter = this.operationExpression(toCallMethodUpon);
        JsExpression jsExpression = this.accessTranslator.translateAsSet(overloadedMethodCallOnPropertyGetter);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/IncrementTranslator", "variableReassignment"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression withTemporariesInitialized(@NotNull JsExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/operation/IncrementTranslator", "withTemporariesInitialized"));
        }
        List<TemporaryVariable> temporaries = this.accessTranslator.declaredTemporaries();
        ArrayList<JsExpression> expressions = Lists.newArrayList(TemporariesUtils.temporariesInitialization(temporaries));
        expressions.add(expression);
        JsExpression jsExpression = JsAstUtils.newSequence(expressions);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/IncrementTranslator", "withTemporariesInitialized"));
        }
        return jsExpression;
    }

    @NotNull
    abstract JsExpression operationExpression(@NotNull JsExpression var1);

    private static boolean isDynamic(TranslationContext context2, JetUnaryExpression expression) {
        CallableDescriptor operationDescriptor = BindingUtils.getCallableDescriptorForOperationExpression(context2.bindingContext(), expression);
        return TasksPackage.isDynamic(operationDescriptor);
    }
}

