/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsCatch;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsTry;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.jvm.internal.InternalPackage;
import kotlin.reflect.jvm.internal.KClassImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetCatchClause;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFinallySection;
import org.jetbrains.jet.lang.psi.JetTryExpression;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.expression.CatchTranslator;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.JsAstUtils;

@KotlinClass(abiVersion=19, data={"\u0010\u0006)iAK]=Ue\u0006t7\u000f\\1u_JT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0003le)\u001c(\"\u0003;sC:\u001cH.\u0019;f\u0015))\u0007\u0010\u001d:fgNLwN\u001c\u0006\u0013\u0003\n\u001cHO]1diR\u0013\u0018M\\:mCR|'OC\u0004hK:,'/\u00197\u000b\rqJg.\u001b;?\u0015AQU\r\u001e+ss\u0016C\bO]3tg&|gNC\u0002kKRTA\u0001\\1oO*\u0019\u0001o]5\u000b\u000f\r|g\u000e^3yi*\u0011BK]1og2\fG/[8o\u0007>tG/\u001a=u\u001559W\r^#yaJ,7o]5p]*)!j\u001d+ss*\u00191m\\7\u000b\r\u001d|wn\u001a7f\u0015\u0011!\u0017M\u001d;\u000b\u0011\r|W\u000e]5mKJTqAY1dW\u0016tGM\u0003\u0002kg*\u0019\u0011m\u001d;\u000b!Q\u0014\u0018M\\:mCR,\u0017i\u001d\"m_\u000e\\'\"\u0004&fi\u0016C\bO]3tg&|gNC\u0004Kg\ncwnY69\u0004)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011QA\u0001C\u0002\u0011\u000b)1\u0001\u0002\u0002\t\u00011\u0001QA\u0001C\u0002\u0011\u000f)1\u0001B\u0002\t\u00071\u0001QA\u0001C\u0001\u0011\u0015)!\u0001\u0002\u0003\t\f\u0015\u0011A\u0011\u0002\u0005\u0007\u000b\r!Q\u0001#\u0003\r\u0001\u0015\u0011A1\u0001E\u0007\u000b\r!a\u0001C\u0004\r\u0001\u0015\u0011A!\u0002E\u0005\u000b\t!a\u0001C\u0004\u0006\u0003!EQA\u0001\u0003\t\u0011%)!\u0001\"\u0005\t\u0014\u0015\u0011A!\u0003\u0005\u000b\u000b\t!\u0019\u0002#\u0006\u0006\u0005\u0011Q\u0001bC\u0003\u0003\t+A9\"B\u0002\u0005\u0017!AA\u0002A\u0003\u0003\t-A\u0001\"B\u0002\u0005\u000b!eA\u0002A\u0003\u0004\t-AQ\u0002\u0004\u0001\u0006\u0005\u0011Y\u0001\"D\u0003\u0003\t\u0015AI\u0002B\u0002\r\u0006e\u0011Q!\u0001E\u0004[=!\u0001\r\u0002M\u0003C\t)\u0011\u0001c\u0003V\u0007!)1\u0001\"\u0002\n\u0003!9Qb\u0001C\b\u0013\u0005Aq!l\u0005\u0005\u0007a\u0011\u0011EA\u0003\u0002\u0011/\t6a\u0001\u0003\u0003\u0013\u0005AA\"L\u000b\u0005\u0003aaQt\u0002\u0003\u0001\u0011\u000bi1!B\u0001\t\u001a1\u0005\u0001k\u0001\u0001\"\u0007\u0015\t\u0001\"\u0004G\u0001#\u000e)A\u0001D\u0005\u0002\u00117i\u0011\u0001\u0003\b6=\u0015iBa9\u0001\u0019\tu5A\u0001\u0001E\u0003\u001b\t)\u0011\u0001c\u0003Q\u0007\u0001ij\u0001\u0002\u0001\t\u000e5\u0011Q!\u0001E\u0007!\u000e\u0005\u0011EA\u0003\u0002\u0011\u000b\t6a\u0002\u0003\u0005\u0013\u0005!\u0001!D\u0001\t\u000f5\t\u0001r\u0002"})
public final class TryTranslator
extends AbstractTranslator
implements KObject {
    public static final /* synthetic */ KClassImpl $kotlinClass;
    @NotNull
    private final JetTryExpression expression;

    static {
        $kotlinClass = InternalPackage.kClassFromKotlin(TryTranslator.class);
    }

    @NotNull
    public final JsTry translate() {
        JsBlock tryBlock = this.translateAsBlock(this.expression.getTryBlock());
        List<JetCatchClause> list = this.expression.getCatchClauses();
        Intrinsics.checkExpressionValueIsNotNull(list, "expression.getCatchClauses()");
        TranslationContext translationContext = this.context();
        Intrinsics.checkExpressionValueIsNotNull(translationContext, "context()");
        CatchTranslator catchTranslator = new CatchTranslator(list, translationContext);
        JsCatch catchBlock = catchTranslator.translate();
        JetFinallySection jetFinallySection = this.expression.getFinallyBlock();
        JetBlockExpression finallyExpression = jetFinallySection != null ? jetFinallySection.getFinalExpression() : null;
        JsBlock finallyBlock = this.translateAsBlock(finallyExpression);
        JsTry jsTry = new JsTry(tryBlock, catchBlock, finallyBlock);
        if (jsTry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/TryTranslator", "translate"));
        }
        return jsTry;
    }

    private final JsBlock translateAsBlock(@JetValueParameter(name="expression", type="?") JetExpression expression) {
        if (expression == null) {
            return null;
        }
        JsStatement statement = Translation.translateAsStatementAndMergeInBlockIfNeeded(expression, this.context());
        return JsAstUtils.convertToBlock(statement);
    }

    @NotNull
    public final JetTryExpression getExpression() {
        JetTryExpression jetTryExpression = this.expression;
        if (jetTryExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/TryTranslator", "getExpression"));
        }
        return jetTryExpression;
    }

    public TryTranslator(@JetValueParameter(name="expression") @NotNull JetTryExpression expression, @JetValueParameter(name="context") @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/TryTranslator", "<init>"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/TryTranslator", "<init>"));
        }
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        super(context2);
        this.expression = expression;
    }
}

