/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsVars;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.JetMultiDeclaration;
import org.jetbrains.jet.lang.psi.JetMultiDeclarationEntry;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.k2js.translate.callTranslator.CallTranslator;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;

public class MultiDeclarationTranslator
extends AbstractTranslator {
    @NotNull
    private final JetMultiDeclaration multiDeclaration;
    @NotNull
    private final JsName multiObjectName;
    @Nullable
    private final JsExpression initializer;

    @NotNull
    public static JsVars translate(@NotNull JetMultiDeclaration multiDeclaration, @NotNull JsName multiObjectName, @Nullable JsExpression initializer, @NotNull TranslationContext context2) {
        if (multiDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiDeclaration", "org/jetbrains/k2js/translate/expression/MultiDeclarationTranslator", "translate"));
        }
        if (multiObjectName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiObjectName", "org/jetbrains/k2js/translate/expression/MultiDeclarationTranslator", "translate"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/MultiDeclarationTranslator", "translate"));
        }
        JsVars jsVars = new MultiDeclarationTranslator(multiDeclaration, multiObjectName, initializer, context2).translate();
        if (jsVars == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/MultiDeclarationTranslator", "translate"));
        }
        return jsVars;
    }

    private MultiDeclarationTranslator(@NotNull JetMultiDeclaration multiDeclaration, @NotNull JsName multiObjectName, @Nullable JsExpression initializer, @NotNull TranslationContext context2) {
        if (multiDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiDeclaration", "org/jetbrains/k2js/translate/expression/MultiDeclarationTranslator", "<init>"));
        }
        if (multiObjectName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiObjectName", "org/jetbrains/k2js/translate/expression/MultiDeclarationTranslator", "<init>"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/MultiDeclarationTranslator", "<init>"));
        }
        super(context2);
        this.multiDeclaration = multiDeclaration;
        this.multiObjectName = multiObjectName;
        this.initializer = initializer;
    }

    private JsVars translate() {
        ArrayList<JsVars.JsVar> jsVars = new ArrayList<JsVars.JsVar>();
        if (this.initializer != null) {
            jsVars.add(new JsVars.JsVar(this.multiObjectName, this.initializer));
        }
        JsNameRef multiObjNameRef = this.multiObjectName.makeRef();
        for (JetMultiDeclarationEntry entry : this.multiDeclaration.getEntries()) {
            ResolvedCall<FunctionDescriptor> entryInitCall = this.context().bindingContext().get(BindingContext.COMPONENT_RESOLVED_CALL, entry);
            assert (entryInitCall != null) : "Entry init call must be not null";
            JsExpression entryInitializer = CallTranslator.INSTANCE$.translate(this.context(), entryInitCall, multiObjNameRef);
            VariableDescriptor descriptor = BindingContextUtils.getNotNull(this.context().bindingContext(), BindingContext.VARIABLE, entry);
            JsName name = this.context().getNameForDescriptor(descriptor);
            jsVars.add(new JsVars.JsVar(name, entryInitializer));
        }
        return new JsVars(jsVars, true);
    }
}

