/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsBreak;
import com.google.dart.compiler.backend.js.ast.JsConditional;
import com.google.dart.compiler.backend.js.ast.JsContinue;
import com.google.dart.compiler.backend.js.ast.JsEmpty;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunctionScope;
import com.google.dart.compiler.backend.js.ast.JsIf;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLabel;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsNullLiteral;
import com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import com.google.dart.compiler.backend.js.ast.JsReturn;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import com.google.dart.compiler.backend.js.ast.JsThrow;
import com.google.dart.compiler.backend.js.ast.JsTry;
import com.google.dart.compiler.backend.js.ast.JsVars;
import com.google.dart.compiler.backend.js.ast.metadata.MetadataPackage;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetBreakExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetCallableReferenceExpression;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetContinueExpression;
import org.jetbrains.jet.lang.psi.JetDoWhileExpression;
import org.jetbrains.jet.lang.psi.JetDotQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetExpressionWithLabel;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetIfExpression;
import org.jetbrains.jet.lang.psi.JetIsExpression;
import org.jetbrains.jet.lang.psi.JetLabeledExpression;
import org.jetbrains.jet.lang.psi.JetMultiDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetPostfixExpression;
import org.jetbrains.jet.lang.psi.JetPrefixExpression;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetReturnExpression;
import org.jetbrains.jet.lang.psi.JetSafeQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateExpression;
import org.jetbrains.jet.lang.psi.JetSuperExpression;
import org.jetbrains.jet.lang.psi.JetThisExpression;
import org.jetbrains.jet.lang.psi.JetThrowExpression;
import org.jetbrains.jet.lang.psi.JetTryExpression;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.psi.JetWhileExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.bindingContextUtil.BindingContextUtilPackage;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.NullValue;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.lang.InlineUtil;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.declaration.ClassTranslator;
import org.jetbrains.k2js.translate.expression.LiteralFunctionTranslator;
import org.jetbrains.k2js.translate.expression.MultiDeclarationTranslator;
import org.jetbrains.k2js.translate.expression.StringTemplateTranslator;
import org.jetbrains.k2js.translate.expression.TryTranslator;
import org.jetbrains.k2js.translate.expression.WhenTranslator;
import org.jetbrains.k2js.translate.expression.loopTranslator.LoopTranslatorPackage;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.general.TranslatorVisitor;
import org.jetbrains.k2js.translate.operation.BinaryOperationTranslator;
import org.jetbrains.k2js.translate.operation.UnaryOperationTranslator;
import org.jetbrains.k2js.translate.reference.AccessTranslationUtils;
import org.jetbrains.k2js.translate.reference.CallExpressionTranslator;
import org.jetbrains.k2js.translate.reference.CallableReferenceTranslator;
import org.jetbrains.k2js.translate.reference.QualifiedExpressionTranslator;
import org.jetbrains.k2js.translate.reference.ReferenceTranslator;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.ErrorReportingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class ExpressionVisitor
extends TranslatorVisitor<JsNode> {
    @Override
    @NotNull
    public JsNode visitConstantExpression(@NotNull JetConstantExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitConstantExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitConstantExpression"));
        }
        JsNode jsNode = ExpressionVisitor.translateConstantExpression(expression, context2).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitConstantExpression"));
        }
        return jsNode;
    }

    @NotNull
    private static JsNode translateConstantExpression(@NotNull JetConstantExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
        }
        CompileTimeConstant<?> compileTimeValue = context2.bindingContext().get(BindingContext.COMPILE_TIME_VALUE, expression);
        assert (compileTimeValue != null) : ErrorReportingUtils.message(expression, "Expression is not compile time value: " + expression.getText() + " ");
        if (compileTimeValue instanceof NullValue) {
            JsNullLiteral jsNullLiteral = JsLiteral.NULL;
            if (jsNullLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
            }
            return jsNullLiteral;
        }
        Object value = BindingUtils.getCompileTimeValue(context2.bindingContext(), expression, compileTimeValue);
        if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            JsNumberLiteral jsNumberLiteral = context2.program().getNumberLiteral(((Number)value).intValue());
            if (jsNumberLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
            }
            return jsNumberLiteral;
        }
        if (value instanceof Long) {
            JsExpression jsExpression = JsAstUtils.newLong((Long)value, context2);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
            }
            return jsExpression;
        }
        if (value instanceof Number) {
            JsNumberLiteral jsNumberLiteral = context2.program().getNumberLiteral(((Number)value).doubleValue());
            if (jsNumberLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
            }
            return jsNumberLiteral;
        }
        if (value instanceof Boolean) {
            JsLiteral.JsBooleanLiteral jsBooleanLiteral = JsLiteral.getBoolean((Boolean)value);
            if (jsBooleanLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
            }
            return jsBooleanLiteral;
        }
        if (value instanceof String) {
            JsStringLiteral jsStringLiteral = context2.program().getStringLiteral((String)value);
            if (jsStringLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
            }
            return jsStringLiteral;
        }
        if (value instanceof Character) {
            JsStringLiteral jsStringLiteral = context2.program().getStringLiteral(value.toString());
            if (jsStringLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
            }
            return jsStringLiteral;
        }
        throw new AssertionError((Object)ErrorReportingUtils.message(expression, "Unsupported constant expression: " + expression.getText() + " "));
    }

    @Override
    @NotNull
    public JsNode visitBlockExpression(@NotNull JetBlockExpression jetBlock, @NotNull TranslationContext context2) {
        if (jetBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetBlock", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitBlockExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitBlockExpression"));
        }
        List<JetElement> statements = jetBlock.getStatements();
        JsBlock jsBlock = new JsBlock();
        for (JetElement statement : statements) {
            assert (statement instanceof JetExpression) : "Elements in JetBlockExpression should be of type JetExpression";
            JsNode jsNode = Translation.translateExpression((JetExpression)statement, context2, jsBlock);
            JsStatement jsStatement = JsAstUtils.convertToStatement(jsNode);
            if (JsAstUtils.isEmptyStatement(jsStatement)) continue;
            jsBlock.getStatements().add(jsStatement);
        }
        JsBlock jsBlock2 = jsBlock;
        if (jsBlock2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitBlockExpression"));
        }
        return jsBlock2;
    }

    @Override
    public JsNode visitMultiDeclaration(@NotNull JetMultiDeclaration multiDeclaration, @NotNull TranslationContext context2) {
        if (multiDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiDeclaration", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitMultiDeclaration"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitMultiDeclaration"));
        }
        JetExpression jetInitializer = multiDeclaration.getInitializer();
        assert (jetInitializer != null) : "Initializer for multi declaration must be not null";
        JsExpression initializer = Translation.translateAsExpression(jetInitializer, context2);
        return MultiDeclarationTranslator.translate(multiDeclaration, context2.scope().declareTemporary(), initializer, context2);
    }

    @Override
    @NotNull
    public JsNode visitReturnExpression(@NotNull JetReturnExpression jetReturnExpression, @NotNull TranslationContext context2) {
        if (jetReturnExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetReturnExpression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitReturnExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitReturnExpression"));
        }
        JetExpression returned = jetReturnExpression.getReturnedExpression();
        if (returned == null) {
            JsNode jsNode = new JsReturn(null).source(jetReturnExpression);
            if (jsNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitReturnExpression"));
            }
            return jsNode;
        }
        JsExpression jsReturnExpression = Translation.translateAsExpression(returned, context2);
        if (JsAstUtils.isEmptyExpression(jsReturnExpression)) {
            JsExpression jsExpression = context2.getEmptyExpression();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitReturnExpression"));
            }
            return jsExpression;
        }
        JsNode jsNode = new JsReturn(jsReturnExpression).source(jetReturnExpression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitReturnExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitParenthesizedExpression(@NotNull JetParenthesizedExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitParenthesizedExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitParenthesizedExpression"));
        }
        JetExpression expressionInside = expression.getExpression();
        if (expressionInside != null) {
            JsNode jsNode = Translation.translateExpression(expressionInside, context2);
            if (jsNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitParenthesizedExpression"));
            }
            return jsNode;
        }
        JsEmpty jsEmpty = context2.getEmptyStatement();
        if (jsEmpty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitParenthesizedExpression"));
        }
        return jsEmpty;
    }

    @Override
    @NotNull
    public JsNode visitBinaryExpression(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitBinaryExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitBinaryExpression"));
        }
        JsExpression jsExpression = BinaryOperationTranslator.translate(expression, context2);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitBinaryExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitProperty(@NotNull JetProperty expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitProperty"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitProperty"));
        }
        VariableDescriptor descriptor = BindingContextUtils.getNotNull(context2.bindingContext(), BindingContext.VARIABLE, expression);
        JsExpression initializer = TranslationUtils.translateInitializerForProperty(expression, context2);
        if (initializer != null && JsAstUtils.isEmptyExpression(initializer)) {
            JsExpression jsExpression = context2.getEmptyExpression();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitProperty"));
            }
            return jsExpression;
        }
        JsName name = context2.getNameForDescriptor(descriptor);
        if (BindingContextUtils.isVarCapturedInClosure(context2.bindingContext(), descriptor)) {
            JsNameRef alias = Namer.getCapturedVarAccessor(name.makeRef());
            initializer = JsAstUtils.wrapValue(alias, initializer == null ? JsLiteral.NULL : initializer);
        }
        JsNode jsNode = JsAstUtils.newVar(name, initializer).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitProperty"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitCallableReferenceExpression(@NotNull JetCallableReferenceExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitCallableReferenceExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitCallableReferenceExpression"));
        }
        JsExpression jsExpression = CallableReferenceTranslator.INSTANCE$.translate(expression, context2);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitCallableReferenceExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitCallExpression(@NotNull JetCallExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitCallExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitCallExpression"));
        }
        if (CallExpressionTranslator.shouldBeInlined(expression, context2) && BindingContextUtilPackage.isUsedAsExpression(expression, context2.bindingContext())) {
            TemporaryVariable temporaryVariable = context2.declareTemporary(null);
            JsNode callResult = CallExpressionTranslator.translate(expression, null, context2).source(expression);
            assert (callResult instanceof JsExpression);
            JsExpression assignment = JsAstUtils.assignment(temporaryVariable.reference(), (JsExpression)callResult);
            context2.addStatementToCurrentBlock(assignment.makeStmt());
            JsNameRef jsNameRef = temporaryVariable.reference();
            if (jsNameRef == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitCallExpression"));
            }
            return jsNameRef;
        }
        JsNode jsNode = CallExpressionTranslator.translate(expression, null, context2).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitCallExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitIfExpression(@NotNull JetIfExpression expression, @NotNull TranslationContext context2) {
        JsStatement elseStatement;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitIfExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitIfExpression"));
        }
        assert (expression.getCondition() != null) : "condition should not ne null: " + expression.getText();
        JsExpression testExpression = Translation.translateAsExpression(expression.getCondition(), context2);
        if (JsAstUtils.isEmptyExpression(testExpression)) {
            JsExpression jsExpression = testExpression;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitIfExpression"));
            }
            return jsExpression;
        }
        boolean isKotlinExpression = BindingContextUtilPackage.isUsedAsExpression(expression, context2.bindingContext());
        JetExpression thenExpression = expression.getThen();
        assert (thenExpression != null) : "then expression should not be null: " + expression.getText();
        JetExpression elseExpression = expression.getElse();
        JsStatement thenStatement = Translation.translateAsStatementAndMergeInBlockIfNeeded(thenExpression, context2);
        JsStatement jsStatement = elseStatement = elseExpression != null ? Translation.translateAsStatementAndMergeInBlockIfNeeded(elseExpression, context2) : null;
        if (isKotlinExpression) {
            boolean canBeJsExpression;
            JsExpression jsThenExpression = JsAstUtils.extractExpressionFromStatement(thenStatement);
            JsExpression jsElseExpression = JsAstUtils.extractExpressionFromStatement(elseStatement);
            boolean bl = canBeJsExpression = jsThenExpression != null && jsElseExpression != null;
            if (canBeJsExpression) {
                JsExpression jsExpression = new JsConditional(testExpression, jsThenExpression, jsElseExpression).source(expression);
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitIfExpression"));
                }
                return jsExpression;
            }
        }
        JsIf ifStatement = new JsIf(testExpression, thenStatement, elseStatement);
        JsNode jsNode = ifStatement.source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitIfExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsExpression visitSimpleNameExpression(@NotNull JetSimpleNameExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitSimpleNameExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitSimpleNameExpression"));
        }
        JsExpression jsExpression = ReferenceTranslator.translateSimpleNameWithQualifier(expression, null, context2).source(expression);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitSimpleNameExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitWhileExpression(@NotNull JetWhileExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitWhileExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitWhileExpression"));
        }
        JsNode jsNode = LoopTranslatorPackage.createWhile(false, expression, context2);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitWhileExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitDoWhileExpression(@NotNull JetDoWhileExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitDoWhileExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitDoWhileExpression"));
        }
        JsNode jsNode = LoopTranslatorPackage.createWhile(true, expression, context2);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitDoWhileExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitStringTemplateExpression(@NotNull JetStringTemplateExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitStringTemplateExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitStringTemplateExpression"));
        }
        JsStringLiteral stringLiteral = ExpressionVisitor.resolveAsStringConstant(expression, context2);
        if (stringLiteral != null) {
            JsStringLiteral jsStringLiteral = stringLiteral;
            if (jsStringLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitStringTemplateExpression"));
            }
            return jsStringLiteral;
        }
        JsNode jsNode = ExpressionVisitor.resolveAsTemplate(expression, context2).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitStringTemplateExpression"));
        }
        return jsNode;
    }

    @NotNull
    private static JsNode resolveAsTemplate(@NotNull JetStringTemplateExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "resolveAsTemplate"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "resolveAsTemplate"));
        }
        JsExpression jsExpression = StringTemplateTranslator.translate(expression, context2);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "resolveAsTemplate"));
        }
        return jsExpression;
    }

    @Nullable
    private static JsStringLiteral resolveAsStringConstant(@NotNull JetExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "resolveAsStringConstant"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "resolveAsStringConstant"));
        }
        Object value = BindingUtils.getCompileTimeValue(context2.bindingContext(), expression);
        if (value == null) {
            return null;
        }
        assert (value instanceof String) : "Compile time constant template should be a String constant.";
        String constantString = (String)value;
        return context2.program().getStringLiteral(constantString);
    }

    @Override
    @NotNull
    public JsNode visitDotQualifiedExpression(@NotNull JetDotQualifiedExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitDotQualifiedExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitDotQualifiedExpression"));
        }
        JsNode jsNode = QualifiedExpressionTranslator.translateQualifiedExpression(expression, context2);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitDotQualifiedExpression"));
        }
        return jsNode;
    }

    @Override
    public JsNode visitLabeledExpression(@NotNull JetLabeledExpression expression, TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitLabeledExpression"));
        }
        JetExpression baseExpression = expression.getBaseExpression();
        assert (baseExpression != null);
        JsScope scope2 = context2.scope();
        assert (scope2 instanceof JsFunctionScope) : "Labeled statement is unexpected outside of function scope";
        JsFunctionScope functionScope = (JsFunctionScope)scope2;
        String labelIdent = ExpressionVisitor.getReferencedName(expression.getTargetLabel());
        JsName labelName = functionScope.enterLabel(labelIdent);
        JsStatement baseStatement = Translation.translateAsStatement(baseExpression, context2);
        functionScope.exitLabel();
        return new JsLabel(labelName, baseStatement).source(expression);
    }

    @Override
    @NotNull
    public JsNode visitPrefixExpression(@NotNull JetPrefixExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitPrefixExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitPrefixExpression"));
        }
        JsExpression jsExpression = UnaryOperationTranslator.translate(expression, context2).source(expression);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitPrefixExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitPostfixExpression(@NotNull JetPostfixExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitPostfixExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitPostfixExpression"));
        }
        JsExpression jsExpression = UnaryOperationTranslator.translate(expression, context2).source(expression);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitPostfixExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitIsExpression(@NotNull JetIsExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitIsExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitIsExpression"));
        }
        JsExpression jsExpression = Translation.patternTranslator(context2).translateIsExpression(expression);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitIsExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitSafeQualifiedExpression(@NotNull JetSafeQualifiedExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitSafeQualifiedExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitSafeQualifiedExpression"));
        }
        JsNode jsNode = QualifiedExpressionTranslator.translateQualifiedExpression(expression, context2).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitSafeQualifiedExpression"));
        }
        return jsNode;
    }

    @Override
    @Nullable
    public JsNode visitWhenExpression(@NotNull JetWhenExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitWhenExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitWhenExpression"));
        }
        return WhenTranslator.translate(expression, context2);
    }

    @Override
    @NotNull
    public JsNode visitBinaryWithTypeRHSExpression(@NotNull JetBinaryExpressionWithTypeRHS expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitBinaryWithTypeRHSExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitBinaryWithTypeRHSExpression"));
        }
        JsExpression jsExpression = Translation.translateAsExpression(expression.getLeft(), context2);
        if (expression.getOperationReference().getReferencedNameElementType() != JetTokens.AS_KEYWORD) {
            JsExpression jsExpression2 = jsExpression.source(expression);
            if (jsExpression2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitBinaryWithTypeRHSExpression"));
            }
            return jsExpression2;
        }
        JetTypeReference right = expression.getRight();
        assert (right != null);
        JetType rightType = BindingContextUtils.getNotNull(context2.bindingContext(), BindingContext.TYPE, right);
        JetType leftType = BindingContextUtils.getNotNull(context2.bindingContext(), BindingContext.EXPRESSION_TYPE, expression.getLeft());
        if (TypeUtils.isNullableType(rightType) || !TypeUtils.isNullableType(leftType)) {
            JsExpression jsExpression3 = jsExpression.source(expression);
            if (jsExpression3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitBinaryWithTypeRHSExpression"));
            }
            return jsExpression3;
        }
        JsExpression jsExpression4 = TranslationUtils.sure(jsExpression, context2).source(expression);
        if (jsExpression4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitBinaryWithTypeRHSExpression"));
        }
        return jsExpression4;
    }

    private static String getReferencedName(JetSimpleNameExpression expression) {
        return expression.getReferencedName().replaceAll("^@", "").replaceAll("(?:^`(.*)`$)", "$1");
    }

    private static JsNameRef getTargetLabel(JetExpressionWithLabel expression, TranslationContext context2) {
        JetSimpleNameExpression labelElement = expression.getTargetLabel();
        if (labelElement == null) {
            return null;
        }
        String labelIdent = ExpressionVisitor.getReferencedName(labelElement);
        JsScope scope2 = context2.scope();
        assert (scope2 instanceof JsFunctionScope) : "Labeled statement is unexpected outside of function scope";
        JsName labelName = ((JsFunctionScope)scope2).findLabel(labelIdent);
        assert (labelName != null);
        return labelName.makeRef();
    }

    @Override
    @NotNull
    public JsNode visitBreakExpression(@NotNull JetBreakExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitBreakExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitBreakExpression"));
        }
        JsNode jsNode = new JsBreak(ExpressionVisitor.getTargetLabel(expression, context2)).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitBreakExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitContinueExpression(@NotNull JetContinueExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitContinueExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitContinueExpression"));
        }
        JsNode jsNode = new JsContinue(ExpressionVisitor.getTargetLabel(expression, context2)).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitContinueExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitFunctionLiteralExpression(@NotNull JetFunctionLiteralExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitFunctionLiteralExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitFunctionLiteralExpression"));
        }
        JsExpression jsExpression = new LiteralFunctionTranslator(context2).translate(expression.getFunctionLiteral());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitFunctionLiteralExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitNamedFunction(@NotNull JetNamedFunction expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitNamedFunction"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitNamedFunction"));
        }
        JsExpression alias = new LiteralFunctionTranslator(context2).translate(expression);
        FunctionDescriptor descriptor = BindingUtils.getFunctionDescriptor(context2.bindingContext(), expression);
        JsName name = context2.getNameForDescriptor(descriptor);
        if (InlineUtil.getInlineType(descriptor).isInline()) {
            MetadataPackage.setStaticRef(name, alias);
        }
        JsNode jsNode = new JsVars(new JsVars.JsVar(name, alias)).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitNamedFunction"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitThisExpression(@NotNull JetThisExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitThisExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitThisExpression"));
        }
        DeclarationDescriptor thisExpression = BindingUtils.getDescriptorForReferenceExpression(context2.bindingContext(), expression.getInstanceReference());
        assert (thisExpression != null) : "This expression must reference a descriptor: " + expression.getText();
        JsExpression jsExpression = context2.getDispatchReceiver(JsDescriptorUtils.getReceiverParameterForDeclaration(thisExpression)).source(expression);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitThisExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitArrayAccessExpression(@NotNull JetArrayAccessExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitArrayAccessExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitArrayAccessExpression"));
        }
        JsExpression jsExpression = AccessTranslationUtils.translateAsGet(expression, context2);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitArrayAccessExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitSuperExpression(@NotNull JetSuperExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitSuperExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitSuperExpression"));
        }
        DeclarationDescriptor superClassDescriptor = context2.bindingContext().get(BindingContext.REFERENCE_TARGET, expression.getInstanceReference());
        assert (superClassDescriptor != null) : ErrorReportingUtils.message(expression);
        JsExpression jsExpression = ReferenceTranslator.translateAsFQReference(superClassDescriptor, context2);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitSuperExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitForExpression(@NotNull JetForExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitForExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitForExpression"));
        }
        JsNode jsNode = LoopTranslatorPackage.translateForExpression(expression, context2).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitForExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitTryExpression(@NotNull JetTryExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitTryExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitTryExpression"));
        }
        JsTry jsTry = new TryTranslator(expression, context2).translate();
        if (jsTry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitTryExpression"));
        }
        return jsTry;
    }

    @Override
    @NotNull
    public JsNode visitThrowExpression(@NotNull JetThrowExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitThrowExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitThrowExpression"));
        }
        JetExpression thrownExpression = expression.getThrownExpression();
        assert (thrownExpression != null) : "Thrown expression must not be null";
        JsNode jsNode = new JsThrow(Translation.translateAsExpression(thrownExpression, context2)).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitThrowExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitObjectLiteralExpression(@NotNull JetObjectLiteralExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitObjectLiteralExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitObjectLiteralExpression"));
        }
        JsExpression jsExpression = ClassTranslator.generateObjectLiteral(expression.getObjectDeclaration(), context2);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitObjectLiteralExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitObjectDeclaration(@NotNull JetObjectDeclaration expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitObjectDeclaration"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitObjectDeclaration"));
        }
        DeclarationDescriptor descriptor = BindingUtils.getDescriptorForElement(context2.bindingContext(), expression);
        JsName name = context2.getNameForDescriptor(descriptor);
        JsInvocation value = ClassTranslator.generateClassCreation(expression, context2);
        JsNode jsNode = JsAstUtils.newVar(name, value).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/ExpressionVisitor", "visitObjectDeclaration"));
        }
        return jsNode;
    }
}

