/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.inline;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsExpressionStatement;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLabel;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsReturn;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.SourceInfoAwareJsNode;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.k2js.inline.InlineableResult;
import org.jetbrains.k2js.inline.clean.CleanPackage;
import org.jetbrains.k2js.inline.context.FunctionContext;
import org.jetbrains.k2js.inline.context.InliningContext;
import org.jetbrains.k2js.inline.context.NamingContext;
import org.jetbrains.k2js.inline.context.StatementContext;
import org.jetbrains.k2js.inline.util.UtilPackage;

class FunctionInlineMutator {
    private final JsInvocation call;
    private final InliningContext inliningContext;
    private final FunctionContext functionContext;
    private final JsFunction invokedFunction;
    private final boolean isResultNeeded;
    private final NamingContext namingContext;
    private JsBlock body;
    private JsExpression resultExpr;
    private JsLabel breakLabel;

    public static InlineableResult getInlineableCallReplacement(@NotNull JsInvocation call, @NotNull InliningContext inliningContext) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/k2js/inline/FunctionInlineMutator", "getInlineableCallReplacement"));
        }
        if (inliningContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inliningContext", "org/jetbrains/k2js/inline/FunctionInlineMutator", "getInlineableCallReplacement"));
        }
        FunctionInlineMutator mutator = new FunctionInlineMutator(call, inliningContext);
        mutator.process();
        SourceInfoAwareJsNode inlineableBody = mutator.body;
        if (mutator.breakLabel != null) {
            mutator.breakLabel.setStatement((JsStatement)((Object)inlineableBody));
            inlineableBody = mutator.breakLabel;
        }
        JsExpression resultExpression = null;
        if (mutator.isResultNeeded) {
            resultExpression = mutator.resultExpr;
        }
        return new InlineableResult((JsStatement)((Object)inlineableBody), resultExpression);
    }

    private FunctionInlineMutator(@NotNull JsInvocation call, @NotNull InliningContext inliningContext) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/k2js/inline/FunctionInlineMutator", "<init>"));
        }
        if (inliningContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inliningContext", "org/jetbrains/k2js/inline/FunctionInlineMutator", "<init>"));
        }
        this.resultExpr = null;
        this.breakLabel = null;
        this.inliningContext = inliningContext;
        this.call = call;
        this.functionContext = inliningContext.getFunctionContext();
        this.invokedFunction = this.functionContext.getFunctionDefinition(call);
        this.body = this.invokedFunction.getBody().deepCopy();
        this.isResultNeeded = this.isResultNeeded(call);
        this.namingContext = inliningContext.newNamingContext();
    }

    private void process() {
        List<JsExpression> arguments2 = this.getArguments();
        List<JsParameter> parameters2 = this.getParameters();
        this.replaceThis();
        CleanPackage.removeDefaultInitializers(arguments2, parameters2, this.body);
        UtilPackage.aliasArgumentsIfNeeded(this.namingContext, arguments2, parameters2);
        UtilPackage.renameLocalNames(this.namingContext, this.invokedFunction);
        this.removeStatementsAfterTopReturn();
        if (this.isResultNeeded && FunctionInlineMutator.canBeExpression(this.body)) {
            this.resultExpr = FunctionInlineMutator.asExpression(this.body);
            this.body.getStatements().clear();
            this.resultExpr = (JsExpression)this.namingContext.applyRenameTo(this.resultExpr);
        } else {
            this.processReturns();
            this.namingContext.applyRenameTo(this.body);
        }
    }

    private void replaceThis() {
        if (!FunctionInlineMutator.hasThisReference(this.body)) {
            return;
        }
        JsExpression thisReplacement = FunctionInlineMutator.getThisReplacement(this.call);
        if (thisReplacement == null) {
            return;
        }
        if (UtilPackage.needToAlias(thisReplacement)) {
            JsName thisName = this.namingContext.getFreshName(this.getThisAlias());
            this.namingContext.newVar(thisName, thisReplacement);
            thisReplacement = thisName.makeRef();
        }
        UtilPackage.replaceThisReference(this.body, thisReplacement);
    }

    private void removeStatementsAfterTopReturn() {
        List<JsStatement> statements = this.body.getStatements();
        int statementsSize = statements.size();
        for (int i = 0; i < statementsSize; ++i) {
            JsStatement statement = statements.get(i);
            if (!(statement instanceof JsReturn)) continue;
            statements.subList(i + 1, statementsSize).clear();
            break;
        }
    }

    private void processReturns() {
        int returnCount = UtilPackage.collectInstances(JsReturn.class, this.body).size();
        if (returnCount == 0) {
            this.resultExpr = JsLiteral.UNDEFINED;
        } else {
            this.doReplaceReturns(returnCount);
        }
    }

    private void doReplaceReturns(int returnCount) {
        boolean hasReturnOnTopLevel;
        JsReturn returnOnTop = ContainerUtil.findInstance(this.body.getStatements(), JsReturn.class);
        boolean bl = hasReturnOnTopLevel = returnOnTop != null;
        if (this.isResultNeeded) {
            JsName resultName = this.namingContext.getFreshName(this.getResultLabel());
            this.namingContext.newVar(resultName, null);
            this.resultExpr = resultName.makeRef();
        }
        boolean needBreakLabel = returnCount != 1 || !hasReturnOnTopLevel;
        JsNameRef breakLabelRef = null;
        if (needBreakLabel) {
            JsName breakName = this.namingContext.getFreshName(this.getBreakLabel());
            breakLabelRef = breakName.makeRef();
            this.breakLabel = new JsLabel(breakName);
        }
        assert (this.resultExpr == null || this.resultExpr instanceof JsNameRef);
        UtilPackage.replaceReturns(this.body, (JsNameRef)this.resultExpr, breakLabelRef);
    }

    @NotNull
    private List<JsExpression> getArguments() {
        List<JsExpression> arguments2 = this.call.getArguments();
        if (UtilPackage.isCallInvocation(this.call)) {
            List<JsExpression> list = arguments2.subList(1, arguments2.size());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/inline/FunctionInlineMutator", "getArguments"));
            }
            return list;
        }
        List<JsExpression> list = arguments2;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/inline/FunctionInlineMutator", "getArguments"));
        }
        return list;
    }

    private boolean isResultNeeded(JsInvocation call) {
        StatementContext statementContext = this.inliningContext.getStatementContext();
        JsStatement currentStatement = statementContext.getCurrentStatement();
        return !(currentStatement instanceof JsExpressionStatement) || call != ((JsExpressionStatement)currentStatement).getExpression();
    }

    @NotNull
    private List<JsParameter> getParameters() {
        List<JsParameter> list = this.invokedFunction.getParameters();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/inline/FunctionInlineMutator", "getParameters"));
        }
        return list;
    }

    @NotNull
    private String getResultLabel() {
        String string = this.getLabelPrefix() + "result";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/inline/FunctionInlineMutator", "getResultLabel"));
        }
        return string;
    }

    @NotNull
    private String getBreakLabel() {
        String string = this.getLabelPrefix() + "break";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/inline/FunctionInlineMutator", "getBreakLabel"));
        }
        return string;
    }

    @NotNull
    private String getThisAlias() {
        if ("$this" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/inline/FunctionInlineMutator", "getThisAlias"));
        }
        return "$this";
    }

    @NotNull
    String getLabelPrefix() {
        String labelPrefix;
        String ident = UtilPackage.getSimpleIdent(this.call);
        String string = labelPrefix = ident != null ? ident : "inline$";
        if (labelPrefix.endsWith("$")) {
            String string2 = labelPrefix;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/inline/FunctionInlineMutator", "getLabelPrefix"));
            }
            return string2;
        }
        String string3 = labelPrefix + "$";
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/inline/FunctionInlineMutator", "getLabelPrefix"));
        }
        return string3;
    }

    @Nullable
    private static JsExpression getThisReplacement(JsInvocation call) {
        if (UtilPackage.isCallInvocation(call)) {
            return call.getArguments().get(0);
        }
        if (UtilPackage.hasCallerQualifier(call)) {
            return UtilPackage.getCallerQualifier(call);
        }
        return null;
    }

    private static boolean hasThisReference(JsBlock body) {
        List<JsLiteral.JsThisRef> thisRefs = UtilPackage.collectInstances(JsLiteral.JsThisRef.class, body);
        return !thisRefs.isEmpty();
    }

    private static boolean canBeExpression(JsBlock body) {
        List<JsStatement> statements = body.getStatements();
        return statements.size() == 1 && statements.get(0) instanceof JsReturn;
    }

    private static JsExpression asExpression(JsBlock body) {
        assert (FunctionInlineMutator.canBeExpression(body));
        List<JsStatement> statements = body.getStatements();
        JsReturn returnStatement = (JsReturn)statements.get(0);
        return returnStatement.getExpression();
    }
}

