/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.facade;

import com.google.common.base.Predicates;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.util.TextOutputImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.OutputFileCollection;
import org.jetbrains.jet.SimpleOutputFile;
import org.jetbrains.jet.SimpleOutputFileCollection;
import org.jetbrains.jet.analyzer.AnalysisResult;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.diagnostics.DiagnosticUtils;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.PsiPackage;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.Diagnostics;
import org.jetbrains.jet.utils.fileUtils.FileUtilsPackage;
import org.jetbrains.js.compiler.JsSourceGenerationVisitor;
import org.jetbrains.js.compiler.sourcemap.SourceMap3Builder;
import org.jetbrains.js.compiler.sourcemap.SourceMapBuilder;
import org.jetbrains.k2js.analyze.TopDownAnalyzerFacadeForJS;
import org.jetbrains.k2js.config.Config;
import org.jetbrains.k2js.facade.FacadeUtils;
import org.jetbrains.k2js.facade.MainCallParameters;
import org.jetbrains.k2js.facade.SourceMapBuilderConsumer;
import org.jetbrains.k2js.facade.Status;
import org.jetbrains.k2js.facade.exceptions.TranslationException;
import org.jetbrains.k2js.inline.JsInliner;
import org.jetbrains.k2js.translate.general.Translation;

public final class K2JSTranslator {
    public static final String FLUSH_SYSTEM_OUT = "Kotlin.out.flush();\n";
    public static final String GET_SYSTEM_OUT = "Kotlin.out.buffer;\n";
    @NotNull
    private final Config config;

    public static Status<OutputFileCollection> translateWithMainCallParameters(@NotNull MainCallParameters mainCall, @NotNull List<JetFile> files, @NotNull File outputFile, @Nullable File outputPrefixFile, @Nullable File outputPostfixFile, @NotNull Config config, @NotNull Consumer<JsNode> astConsumer) throws TranslationException, IOException {
        if (mainCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainCall", "org/jetbrains/k2js/facade/K2JSTranslator", "translateWithMainCallParameters"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/k2js/facade/K2JSTranslator", "translateWithMainCallParameters"));
        }
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFile", "org/jetbrains/k2js/facade/K2JSTranslator", "translateWithMainCallParameters"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/k2js/facade/K2JSTranslator", "translateWithMainCallParameters"));
        }
        if (astConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astConsumer", "org/jetbrains/k2js/facade/K2JSTranslator", "translateWithMainCallParameters"));
        }
        K2JSTranslator translator = new K2JSTranslator(config);
        TextOutputImpl output = new TextOutputImpl();
        SourceMap3Builder sourceMapBuilder = config.isSourcemap() ? new SourceMap3Builder(outputFile, output, new SourceMapBuilderConsumer()) : null;
        Status<String> codeStatus = translator.generateProgramCode(files, mainCall, output, sourceMapBuilder, astConsumer);
        if (codeStatus.isFail()) {
            return Status.fail();
        }
        String programCode = codeStatus.getResult();
        String prefix = FileUtilsPackage.readTextOrEmpty(outputPrefixFile);
        String postfix = FileUtilsPackage.readTextOrEmpty(outputPostfixFile);
        StringBuilder outBuilder = new StringBuilder(programCode.length() + prefix.length() + postfix.length());
        outBuilder.append(prefix).append(programCode).append(postfix);
        List<File> sourceFiles = ContainerUtil.map(files, new Function<JetFile, File>(){

            @Override
            public File fun(JetFile file) {
                VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
                if (virtualFile == null) {
                    return new File(file.getName());
                }
                return VfsUtilCore.virtualToIoFile(virtualFile);
            }
        });
        SimpleOutputFile jsFile = new SimpleOutputFile(sourceFiles, outputFile.getName(), outBuilder.toString());
        SmartList<SimpleOutputFile> outputFiles = new SmartList<SimpleOutputFile>(jsFile);
        if (sourceMapBuilder != null) {
            sourceMapBuilder.skipLinesAtBeginning(StringUtil.getLineBreakCount(prefix));
            SimpleOutputFile sourcemapFile = new SimpleOutputFile(sourceFiles, sourceMapBuilder.getOutFile().getName(), sourceMapBuilder.build());
            outputFiles.add(sourcemapFile);
        }
        SimpleOutputFileCollection outputFileCollection = new SimpleOutputFileCollection(outputFiles);
        return Status.success(outputFileCollection);
    }

    public K2JSTranslator(@NotNull Config config) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/k2js/facade/K2JSTranslator", "<init>"));
        }
        this.config = config;
    }

    @NotNull
    public Status<String> translateStringWithCallToMain(@NotNull String programText, @NotNull String argumentsString) throws TranslationException {
        if (programText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "programText", "org/jetbrains/k2js/facade/K2JSTranslator", "translateStringWithCallToMain"));
        }
        if (argumentsString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentsString", "org/jetbrains/k2js/facade/K2JSTranslator", "translateStringWithCallToMain"));
        }
        JetFile file = PsiPackage.JetPsiFactory(this.getProject()).createFile("test", programText);
        Status<String> status = this.generateProgramCode(file, MainCallParameters.mainWithArguments(FacadeUtils.parseString(argumentsString)));
        if (status.isFail()) {
            Status<String> status2 = status;
            if (status2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/facade/K2JSTranslator", "translateStringWithCallToMain"));
            }
            return status2;
        }
        String code = FLUSH_SYSTEM_OUT + status.getResult() + "\n" + GET_SYSTEM_OUT;
        Status<String> status3 = Status.success(code);
        if (status3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/facade/K2JSTranslator", "translateStringWithCallToMain"));
        }
        return status3;
    }

    @NotNull
    public Status<String> generateProgramCode(@NotNull JetFile file, @NotNull MainCallParameters mainCallParameters) throws TranslationException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/k2js/facade/K2JSTranslator", "generateProgramCode"));
        }
        if (mainCallParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainCallParameters", "org/jetbrains/k2js/facade/K2JSTranslator", "generateProgramCode"));
        }
        Status<String> status = this.generateProgramCode(Collections.singletonList(file), mainCallParameters);
        if (status == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/facade/K2JSTranslator", "generateProgramCode"));
        }
        return status;
    }

    @NotNull
    public Status<String> generateProgramCode(@NotNull List<JetFile> files, @NotNull MainCallParameters mainCallParameters) throws TranslationException {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/k2js/facade/K2JSTranslator", "generateProgramCode"));
        }
        if (mainCallParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainCallParameters", "org/jetbrains/k2js/facade/K2JSTranslator", "generateProgramCode"));
        }
        Status<String> status = this.generateProgramCode(files, mainCallParameters, new TextOutputImpl(), null, Consumer.EMPTY_CONSUMER);
        if (status == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/facade/K2JSTranslator", "generateProgramCode"));
        }
        return status;
    }

    @NotNull
    public Status<String> generateProgramCode(@NotNull List<JetFile> files, @NotNull MainCallParameters mainCallParameters, @NotNull TextOutputImpl output, @Nullable SourceMapBuilder sourceMapBuilder, @NotNull Consumer<JsNode> astConsumer) throws TranslationException {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/k2js/facade/K2JSTranslator", "generateProgramCode"));
        }
        if (mainCallParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainCallParameters", "org/jetbrains/k2js/facade/K2JSTranslator", "generateProgramCode"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "org/jetbrains/k2js/facade/K2JSTranslator", "generateProgramCode"));
        }
        if (astConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astConsumer", "org/jetbrains/k2js/facade/K2JSTranslator", "generateProgramCode"));
        }
        JsProgram program = this.generateProgram(files, mainCallParameters);
        Diagnostics diagnostics = this.config.getTrace().getBindingContext().getDiagnostics();
        if (DiagnosticUtils.hasError(diagnostics)) {
            Status<String> status = Status.fail();
            if (status == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/facade/K2JSTranslator", "generateProgramCode"));
            }
            return status;
        }
        program = JsInliner.process(program);
        program.accept(new JsSourceGenerationVisitor(output, sourceMapBuilder));
        astConsumer.consume(program);
        Status<String> status = Status.success(output.toString());
        if (status == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/facade/K2JSTranslator", "generateProgramCode"));
        }
        return status;
    }

    @NotNull
    public JsProgram generateProgram(@NotNull List<JetFile> filesToTranslate, @NotNull MainCallParameters mainCallParameters) throws TranslationException {
        if (filesToTranslate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToTranslate", "org/jetbrains/k2js/facade/K2JSTranslator", "generateProgram"));
        }
        if (mainCallParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainCallParameters", "org/jetbrains/k2js/facade/K2JSTranslator", "generateProgram"));
        }
        AnalysisResult analysisResult = TopDownAnalyzerFacadeForJS.analyzeFiles(filesToTranslate, Predicates.<PsiFile>alwaysTrue(), this.config);
        BindingContext bindingContext = analysisResult.getBindingContext();
        TopDownAnalyzerFacadeForJS.checkForErrors(Config.withJsLibAdded(filesToTranslate, this.config), bindingContext);
        ModuleDescriptor moduleDescriptor = analysisResult.getModuleDescriptor();
        JsProgram jsProgram = Translation.generateAst(bindingContext, filesToTranslate, mainCallParameters, moduleDescriptor, this.config);
        if (jsProgram == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/facade/K2JSTranslator", "generateProgram"));
        }
        return jsProgram;
    }

    @NotNull
    private Project getProject() {
        Project project = this.config.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/facade/K2JSTranslator", "getProject"));
        }
        return project;
    }
}

