/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.config;

import com.google.common.base.Predicates;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kotlin.Function1;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.analyzer.AnalysisResult;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetPsiFactory;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.utils.PathUtil;
import org.jetbrains.k2js.analyze.TopDownAnalyzerFacadeForJS;
import org.jetbrains.k2js.config.Config;
import org.jetbrains.k2js.config.EcmaVersion;
import org.jetbrains.k2js.config.LibrarySourcesConfig;

public class LibrarySourcesConfigWithCaching
extends LibrarySourcesConfig {
    public static final List<String> JS_STDLIB = Arrays.asList(PathUtil.getKotlinPathsForDistDirectory().getJsStdLibJarPath().getAbsolutePath());
    private static List<JetFile> jsLibFiles;
    private static AnalysisResult result;
    private BindingContext libraryContext;
    private ModuleDescriptor libraryModule;
    private final boolean isUnitTestConfig;

    public LibrarySourcesConfigWithCaching(@NotNull Project project, @NotNull String moduleId, @NotNull EcmaVersion ecmaVersion, boolean sourcemap, boolean inlineEnabled, boolean isUnitTestConfig) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/k2js/config/LibrarySourcesConfigWithCaching", "<init>"));
        }
        if (moduleId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleId", "org/jetbrains/k2js/config/LibrarySourcesConfigWithCaching", "<init>"));
        }
        if (ecmaVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ecmaVersion", "org/jetbrains/k2js/config/LibrarySourcesConfigWithCaching", "<init>"));
        }
        super(project, moduleId, JS_STDLIB, ecmaVersion, sourcemap, inlineEnabled);
        this.isUnitTestConfig = isUnitTestConfig;
    }

    @Override
    @NotNull
    public List<JetFile> generateLibFiles() {
        if (jsLibFiles == null) {
            jsLibFiles = super.generateLibFiles();
        }
        List<JetFile> list = jsLibFiles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/config/LibrarySourcesConfigWithCaching", "generateLibFiles"));
        }
        return list;
    }

    @Override
    @Nullable
    public ModuleDescriptor getLibraryModule() {
        if (this.libraryModule == null) {
            this.libraryModule = this.getResult().getModuleDescriptor();
        }
        return this.libraryModule;
    }

    @Override
    @Nullable
    public BindingContext getLibraryContext() {
        if (this.libraryContext == null) {
            this.libraryContext = this.getResult().getBindingContext();
        }
        return this.libraryContext;
    }

    @Override
    public boolean isTestConfig() {
        return this.isUnitTestConfig;
    }

    @Override
    protected JetFile getJetFileByVirtualFile(VirtualFile file, String moduleName, PsiManager psiManager) {
        JetFile jetFile;
        try {
            String text = StringUtil.convertLineSeparators(new String(file.contentsToByteArray(false), file.getCharset()));
            jetFile = new JetPsiFactory(this.getProject()).createPhysicalFile(file.getName(), text);
        }
        catch (IOException e) {
            JetFile jetFileByVirtualFile = super.getJetFileByVirtualFile(file, moduleName, psiManager);
            jetFile = new JetPsiFactory(this.getProject()).createPhysicalFile(file.getPath(), jetFileByVirtualFile.getText());
        }
        LibrarySourcesConfigWithCaching.setupPsiFile(jetFile, moduleName);
        return jetFile;
    }

    private AnalysisResult getResult() {
        if (result == null) {
            result = TopDownAnalyzerFacadeForJS.analyzeFiles(this.generateLibFiles(), Predicates.<PsiFile>alwaysFalse(), LibrarySourcesConfigWithCaching.createConfigWithoutLibFiles(this.getProject(), this.getModuleId(), this.getTarget()));
        }
        return result;
    }

    @NotNull
    private static Config createConfigWithoutLibFiles(@NotNull Project project, @NotNull String moduleId, @NotNull EcmaVersion ecmaVersion) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/k2js/config/LibrarySourcesConfigWithCaching", "createConfigWithoutLibFiles"));
        }
        if (moduleId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleId", "org/jetbrains/k2js/config/LibrarySourcesConfigWithCaching", "createConfigWithoutLibFiles"));
        }
        if (ecmaVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ecmaVersion", "org/jetbrains/k2js/config/LibrarySourcesConfigWithCaching", "createConfigWithoutLibFiles"));
        }
        Config config = new Config(project, moduleId, ecmaVersion, false, false){

            @Override
            @NotNull
            protected List<JetFile> generateLibFiles() {
                List<JetFile> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/config/LibrarySourcesConfigWithCaching$1", "generateLibFiles"));
                }
                return list;
            }

            @Override
            public boolean checkLibFilesAndReportErrors(@NotNull Function1<String, Unit> report2) {
                if (report2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "report", "org/jetbrains/k2js/config/LibrarySourcesConfigWithCaching$1", "checkLibFilesAndReportErrors"));
                }
                return false;
            }
        };
        if (config == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/config/LibrarySourcesConfigWithCaching", "createConfigWithoutLibFiles"));
        }
        return config;
    }
}

