/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.PossiblyBareType;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeReconstructionResult;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class TypeReconstructionUtil {
    @NotNull
    public static JetType reconstructBareType(@NotNull JetTypeReference right, @NotNull PossiblyBareType possiblyBareTarget, @Nullable JetType subjectType, @NotNull BindingTrace trace) {
        JetType targetType;
        TypeReconstructionResult reconstructionResult;
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/jet/lang/types/expressions/TypeReconstructionUtil", "reconstructBareType"));
        }
        if (possiblyBareTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "possiblyBareTarget", "org/jetbrains/jet/lang/types/expressions/TypeReconstructionUtil", "reconstructBareType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/types/expressions/TypeReconstructionUtil", "reconstructBareType"));
        }
        if (subjectType == null) {
            subjectType = KotlinBuiltIns.getInstance().getAnyType();
        }
        if (!(reconstructionResult = possiblyBareTarget.reconstruct(subjectType)).isAllArgumentsInferred()) {
            TypeConstructor typeConstructor2 = possiblyBareTarget.getBareTypeConstructor();
            trace.report(Errors.NO_TYPE_ARGUMENTS_ON_RHS.on(right, typeConstructor2.getParameters().size(), TypeReconstructionUtil.allStarProjectionsString(typeConstructor2)));
        }
        if ((targetType = reconstructionResult.getResultingType()) != null) {
            if (possiblyBareTarget.isBare()) {
                trace.record(BindingContext.TYPE, right, targetType);
            }
            JetType jetType = targetType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/TypeReconstructionUtil", "reconstructBareType"));
            }
            return jetType;
        }
        JetType jetType = ErrorUtils.createErrorType("Failed to reconstruct type: " + right.getText());
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/TypeReconstructionUtil", "reconstructBareType"));
        }
        return jetType;
    }

    @NotNull
    private static String allStarProjectionsString(@NotNull TypeConstructor constructor2) {
        if (constructor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/jet/lang/types/expressions/TypeReconstructionUtil", "allStarProjectionsString"));
        }
        int size = constructor2.getParameters().size();
        assert (size != 0) : "No projections possible for a nilary type constructor" + constructor2;
        ClassifierDescriptor declarationDescriptor = constructor2.getDeclarationDescriptor();
        assert (declarationDescriptor != null) : "No declaration descriptor for type constructor " + constructor2;
        String name = declarationDescriptor.getName().asString();
        String string = TypeReconstructionUtil.getTypeNameAndStarProjectionsString(name, size);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/TypeReconstructionUtil", "allStarProjectionsString"));
        }
        return string;
    }

    @NotNull
    public static String getTypeNameAndStarProjectionsString(@NotNull String name, int size) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/types/expressions/TypeReconstructionUtil", "getTypeNameAndStarProjectionsString"));
        }
        StringBuilder builder = new StringBuilder(name);
        builder.append("<");
        for (int i = 0; i < size; ++i) {
            builder.append("*");
            if (i == size - 1) break;
            builder.append(", ");
        }
        builder.append(">");
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/TypeReconstructionUtil", "getTypeNameAndStarProjectionsString"));
        }
        return string;
    }
}

