/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import com.google.common.base.Predicates;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.context.GlobalContext;
import org.jetbrains.jet.di.InjectorForTopDownAnalyzerBasic;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.PackageLikeBuilder;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.resolve.AdditionalCheckerProvider;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.types.DynamicTypesSettings;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;

class LocalClassifierAnalyzer {
    LocalClassifierAnalyzer() {
    }

    public static void processClassOrObject(@NotNull GlobalContext globalContext, final @Nullable WritableScope scope2, @NotNull ExpressionTypingContext context2, final @NotNull DeclarationDescriptor containingDeclaration, @NotNull JetClassOrObject object2, @NotNull AdditionalCheckerProvider additionalCheckerProvider, @NotNull DynamicTypesSettings dynamicTypesSettings) {
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "org/jetbrains/jet/lang/types/expressions/LocalClassifierAnalyzer", "processClassOrObject"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/LocalClassifierAnalyzer", "processClassOrObject"));
        }
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/lang/types/expressions/LocalClassifierAnalyzer", "processClassOrObject"));
        }
        if (object2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "org/jetbrains/jet/lang/types/expressions/LocalClassifierAnalyzer", "processClassOrObject"));
        }
        if (additionalCheckerProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalCheckerProvider", "org/jetbrains/jet/lang/types/expressions/LocalClassifierAnalyzer", "processClassOrObject"));
        }
        if (dynamicTypesSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dynamicTypesSettings", "org/jetbrains/jet/lang/types/expressions/LocalClassifierAnalyzer", "processClassOrObject"));
        }
        TopDownAnalysisParameters topDownAnalysisParameters = TopDownAnalysisParameters.createForLocalDeclarations(globalContext.getStorageManager(), globalContext.getExceptionTracker(), Predicates.equalTo(object2.getContainingFile()));
        InjectorForTopDownAnalyzerBasic injector = new InjectorForTopDownAnalyzerBasic(object2.getProject(), topDownAnalysisParameters, context2.trace, DescriptorUtils.getContainingModule(containingDeclaration), additionalCheckerProvider, dynamicTypesSettings);
        TopDownAnalysisContext c = new TopDownAnalysisContext(topDownAnalysisParameters);
        c.setOuterDataFlowInfo(context2.dataFlowInfo);
        injector.getTopDownAnalyzer().doProcess(c, context2.scope, new PackageLikeBuilder(){

            @Override
            @NotNull
            public DeclarationDescriptor getOwnerForChildren() {
                DeclarationDescriptor declarationDescriptor = containingDeclaration;
                if (declarationDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/LocalClassifierAnalyzer$1", "getOwnerForChildren"));
                }
                return declarationDescriptor;
            }

            @Override
            public void addClassifierDescriptor(@NotNull MutableClassDescriptor classDescriptor) {
                if (classDescriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/types/expressions/LocalClassifierAnalyzer$1", "addClassifierDescriptor"));
                }
                if (scope2 != null) {
                    scope2.addClassifierDescriptor(classDescriptor);
                }
            }

            @Override
            public void addFunctionDescriptor(@NotNull SimpleFunctionDescriptor functionDescriptor) {
                if (functionDescriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/types/expressions/LocalClassifierAnalyzer$1", "addFunctionDescriptor"));
                }
                throw new UnsupportedOperationException();
            }

            @Override
            public void addPropertyDescriptor(@NotNull PropertyDescriptor propertyDescriptor) {
                if (propertyDescriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/types/expressions/LocalClassifierAnalyzer$1", "addPropertyDescriptor"));
                }
            }

            @Override
            public PackageLikeBuilder.ClassObjectStatus setClassObjectDescriptor(@NotNull MutableClassDescriptor classObjectDescriptor2) {
                if (classObjectDescriptor2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classObjectDescriptor", "org/jetbrains/jet/lang/types/expressions/LocalClassifierAnalyzer$1", "setClassObjectDescriptor"));
                }
                return null;
            }
        }, Collections.singletonList(object2));
    }
}

