/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.types.Approximation;
import org.jetbrains.jet.lang.types.Flexibility;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@KotlinSyntheticClass(abiVersion=19, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class TypesPackage$flexibleTypes$0031e623 {
    public static final boolean isFlexible(@JetValueParameter(name="$receiver") JetType $receiver) {
        return $receiver.getCapability(Flexibility.class) != null;
    }

    @NotNull
    public static final Flexibility flexibility(@JetValueParameter(name="$receiver") JetType $receiver) {
        Flexibility flexibility = $receiver.getCapability(Flexibility.class);
        if (flexibility == null) {
            Intrinsics.throwNpe();
        }
        if (flexibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypesPackage$flexibleTypes$0031e623", "flexibility"));
        }
        return flexibility;
    }

    public static final boolean isNullabilityFlexible(@JetValueParameter(name="$receiver") JetType $receiver) {
        Flexibility flexibility = $receiver.getCapability(Flexibility.class);
        if (flexibility == null) {
            return false;
        }
        Flexibility flexibility2 = flexibility;
        return TypeUtils.isNullableType(flexibility2.getLowerBound()) != TypeUtils.isNullableType(flexibility2.getUpperBound());
    }

    @Nullable
    public static final JetType singleBestRepresentative(@JetValueParameter(name="$receiver") Collection<? extends JetType> $receiver) {
        Object v1;
        block4: {
            if ($receiver.size() == 1) {
                return (JetType)KotlinPackage.first((Iterable)$receiver);
            }
            Iterable iterable = $receiver;
            for (Object t : iterable) {
                boolean bl;
                block3: {
                    JetType candidate = (JetType)t;
                    Iterable iterable2 = $receiver;
                    for (Object t2 : iterable2) {
                        JetType other = (JetType)t2;
                        if (!Intrinsics.areEqual(candidate, other) ? JetTypeChecker.DEFAULT.equalTypes(candidate, other) : true) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
                if (!bl) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        return v1;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final TypeProjection singleBestRepresentative(@JetValueParameter(name="$receiver") Collection<? extends TypeProjection> $receiver) {
        Object object2;
        Object object3;
        TypeProjection typeProjection;
        Object object42;
        Iterable iterable;
        if ($receiver.size() == 1) {
            return (TypeProjection)KotlinPackage.first((Iterable)$receiver);
        }
        Iterable iterable2 = iterable = (Iterable)$receiver;
        Iterable iterable3 = new ArrayList();
        for (Object object42 : iterable2) {
            void it;
            typeProjection = (TypeProjection)object42;
            object3 = iterable3;
            object2 = it.getProjectionKind();
            object3.add(object2);
        }
        Set projectionKinds = KotlinPackage.toSet((ArrayList)iterable3);
        if (projectionKinds.size() != 1) {
            return null;
        }
        iterable2 = $receiver;
        iterable3 = iterable2;
        Collection collection = new ArrayList();
        object42 = iterable3.iterator();
        while (object42.hasNext()) {
            void it;
            TypeProjection typeProjection2 = typeProjection = object42.next();
            object3 = collection;
            object2 = it.getType();
            object3.add(object2);
        }
        JetType bestType = TypesPackage$flexibleTypes$0031e623.singleBestRepresentative((ArrayList)collection);
        if (bestType == null) {
            return null;
        }
        return new TypeProjectionImpl((Variance)KotlinPackage.single(projectionKinds), bestType);
    }

    @NotNull
    public static final JetType lowerIfFlexible(@JetValueParameter(name="$receiver") JetType $receiver) {
        JetType jetType = TypesPackage$flexibleTypes$0031e623.isFlexible($receiver) ? TypesPackage$flexibleTypes$0031e623.flexibility($receiver).getLowerBound() : $receiver;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypesPackage$flexibleTypes$0031e623", "lowerIfFlexible"));
        }
        return jetType;
    }

    @NotNull
    public static final JetType upperIfFlexible(@JetValueParameter(name="$receiver") JetType $receiver) {
        JetType jetType = TypesPackage$flexibleTypes$0031e623.isFlexible($receiver) ? TypesPackage$flexibleTypes$0031e623.flexibility($receiver).getUpperBound() : $receiver;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypesPackage$flexibleTypes$0031e623", "upperIfFlexible"));
        }
        return jetType;
    }

    public static final boolean assertNotNull(@JetValueParameter(name="$receiver") Approximation.Info $receiver) {
        return TypesPackage$flexibleTypes$0031e623.upperIfFlexible($receiver.getFrom()).isMarkedNullable() ? !TypeUtils.isNullableType($receiver.getTo()) : false;
    }

    @Nullable
    public static final Approximation.Info getApproximationTo(@JetValueParameter(name="$receiver") JetType $receiver, @JetValueParameter(name="expectedType") @NotNull JetType expectedType, @JetValueParameter(name="extras") @NotNull Approximation.DataFlowExtras extras) {
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/types/TypesPackage$flexibleTypes$0031e623", "getApproximationTo"));
        }
        if (extras == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extras", "org/jetbrains/jet/lang/types/TypesPackage$flexibleTypes$0031e623", "getApproximationTo"));
        }
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        Intrinsics.checkParameterIsNotNull(extras, "extras");
        Approximation approximation = $receiver.getCapability(Approximation.class);
        return approximation != null ? approximation.approximateToExpectedType(expectedType, extras) : null;
    }

    public static Approximation.Info getApproximationTo$default(JetType jetType, JetType jetType2, Approximation.DataFlowExtras dataFlowExtras, int n) {
        if ((n & 2) != 0) {
            dataFlowExtras = Approximation.DataFlowExtras.EMPTY.INSTANCE$;
        }
        return TypesPackage$flexibleTypes$0031e623.getApproximationTo(jetType, jetType2, dataFlowExtras);
    }
}

