/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.varianceChecker;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.Map;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.platform.platformStatic;
import kotlin.reflect.jvm.internal.InternalPackage;
import kotlin.reflect.jvm.internal.KClassImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.impl.FunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyAccessorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.jet.lang.diagnostics.DiagnosticSink;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetCallableDeclaration;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetTypeConstraint;
import org.jetbrains.jet.lang.psi.JetTypeElement;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.source.SourcePackage$KotlinSourceElement$aaf94477;
import org.jetbrains.jet.lang.resolve.typeBinding.TypeArgumentBinding;
import org.jetbrains.jet.lang.resolve.typeBinding.TypeBinding;
import org.jetbrains.jet.lang.resolve.typeBinding.TypeBindingPackage$TypeBinding$86120a0d;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.TypeCheckingProcedure;

@KotlinClass(abiVersion=19, data={"^\u0004)ya+\u0019:jC:\u001cWm\u00115fG.,'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\u0007),GO\u0003\u0003mC:<'b\u0002:fg>dg/\u001a\u0006\u0010m\u0006\u0014\u0018.\u00198dK\u000eCWmY6fe*\u0019\u0011I\\=\u000b\r-|G\u000f\\5o\u0015\u0019a\u0014N\\5u}))AO]1dK*a!)\u001b8eS:<GK]1dK*)1\r[3dW*\t1M\u0003\fU_B$un\u001e8B]\u0006d\u0017p]5t\u0007>tG/\u001a=u\u0015\u0011)f.\u001b;\u000b\u0019\rDWmY6DY\u0006\u001c8/Z:\u000b\u0019\rDWmY6NK6\u0014WM]:\u000b\u000fA\u0014xnY3tg*qb+\u0019:jC:\u001cWmQ8oM2L7\r\u001e#jC\u001etwn\u001d;jG\u0012\u000bG/\u0019.\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0003\u000b\t!!\u0001C\u0002\u0006\u0007\u0011\u0015\u0001\u0002\u0001\u0007\u0001\u000b\u0005AA!B\u0002\u0005\b!\u001dA\u0002A\u0003\u0004\t\tAY\u0001\u0004\u0001\u0006\u0005\u0011\u0011\u00012B\u0003\u0004\t\tAq\u0001\u0004\u0001\u0006\u0007\u0011\u001d\u0001r\u0002\u0007\u0001\u000b\t!!\u0001C\u0004\u0005\u00011\u0019\u0011\u0003A\r\u0003\u000b\u0005AA\u0001h\u0005.\u0017\u0011\tG\u0001G\u0003\"\u0005\u0015\t\u0001\u0012B+\u0004\t\u0015\u0019A!B\u0005\u0002\u0011\u0015i3\u0003\u0002\u0001\u0019\ru5A\u0001\u0001E\u0007\u001b\t)\u0011\u0001c\u0003Q\u0007\u0001\t#!B\u0001\t\rE\u001bQ\u0001\u0002\u0004\n\u0003\u0011\u0001Q\"\u0001E\u0007[M!\u0011\u0001\u0007\u0005\u001e\u000e\u0011\u0001\u0001RB\u0007\u0003\u000b\u0005AY\u0001U\u0002\u0001C\t)\u0011\u0001\u0003\u0004R\u0007\u0015!\u0001\"C\u0001\u0005\u00015\t\u0001RB\u0017\u0014\t\u0005A\n\"(\u0004\u0005\u0001!5QBA\u0003\u0002\u0011\u0017\u00016\u0001A\u0011\u0003\u000b\u0005Aa!U\u0002\u0006\t#I\u0011\u0001\u0002\u0001\u000e\u0003!5Qf\u0005\u0003\u00011%ij\u0001\u0002\u0001\t\u000e5\u0011Q!\u0001E\u0006!\u000e\u0001\u0011EA\u0003\u0002\u0011\u0019\t6!\u0002\u0003\n\u0013\u0005!\u0001!D\u0001\t\u000eU&Rq\u0005\u0003d\u0002a%QT\u0002\u0003\u0001\u0011\u0015i!!B\u0001\t\nA\u001b\u0001!\t\u0002\u0006\u0003!\u0019\u0011kA\u0003\u0005\n%\tA\u0001A\u0007\u0002\u0011\u0015\u0001"})
public final class VarianceChecker
implements KObject {
    public static final /* synthetic */ KClassImpl $kotlinClass;
    private final BindingTrace trace;
    public static final object OBJECT$;

    static {
        $kotlinClass = InternalPackage.kClassFromKotlin(VarianceChecker.class);
        OBJECT$ = object.$init$b$3();
    }

    public final void process(@JetValueParameter(name="c") @NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/varianceChecker/VarianceChecker", "process"));
        }
        Intrinsics.checkParameterIsNotNull(c, "c");
        Iterator<CallableMemberDescriptor> iterator2 = c.getMembers().values().iterator();
        while (iterator2.hasNext()) {
            CallableMemberDescriptor member;
            CallableMemberDescriptor callableMemberDescriptor = member = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor, "member");
            OBJECT$.recordPrivateToThisIfNeeded(this.trace, callableMemberDescriptor);
        }
        this.check(c);
    }

    public final void check(@JetValueParameter(name="c") @NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/varianceChecker/VarianceChecker", "check"));
        }
        Intrinsics.checkParameterIsNotNull(c, "c");
        this.checkClasses(c);
        this.checkMembers(c);
    }

    private final void checkClasses(@JetValueParameter(name="c") TopDownAnalysisContext c) {
        Map<JetClassOrObject, ClassDescriptorWithResolutionScopes> map = c.getDeclaredClasses();
        if (map == null) {
            Intrinsics.throwNpe();
        }
        for (JetClassOrObject jetClassOrObject : map.keySet()) {
            if (!(jetClassOrObject instanceof JetClass)) continue;
            for (JetDelegationSpecifier specifier : ((JetClass)jetClassOrObject).getDelegationSpecifiers()) {
                Boolean bl;
                JetTypeReference jetTypeReference = specifier.getTypeReference();
                if (jetTypeReference != null) {
                    BindingContext bindingContext = this.trace.getBindingContext();
                    Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.getBindingContext()");
                    bl = object.checkTypePosition$b$2(OBJECT$, jetTypeReference, bindingContext, Variance.OUT_VARIANCE, this.trace);
                    continue;
                }
                bl = null;
            }
            JetTypeParameterListOwner jetTypeParameterListOwner = (JetTypeParameterListOwner)((Object)jetClassOrObject);
            BindingContext bindingContext = this.trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.getBindingContext()");
            object.checkTypeParameters$b$1(OBJECT$, jetTypeParameterListOwner, bindingContext, Variance.OUT_VARIANCE, this.trace);
        }
    }

    private final void checkMembers(@JetValueParameter(name="c") TopDownAnalysisContext c) {
        Iterator<Map.Entry<JetCallableDeclaration, CallableMemberDescriptor>> iterator2 = KotlinPackage.iterator(c.getMembers());
        while (iterator2.hasNext()) {
            Map.Entry<JetCallableDeclaration, CallableMemberDescriptor> entry = iterator2.next();
            JetCallableDeclaration declaration = KotlinPackage.component1(entry);
            CallableMemberDescriptor descriptor = KotlinPackage.component2(entry);
            if (Visibilities.isPrivate(descriptor.getVisibility())) continue;
            BindingContext bindingContext = this.trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.getBindingContext()");
            JetCallableDeclaration jetCallableDeclaration = declaration;
            Intrinsics.checkExpressionValueIsNotNull(jetCallableDeclaration, "declaration");
            CallableDescriptor callableDescriptor = descriptor;
            Intrinsics.checkExpressionValueIsNotNull(callableDescriptor, "descriptor");
            object.checkCallableDeclaration$b$0(OBJECT$, bindingContext, jetCallableDeclaration, callableDescriptor, this.trace);
        }
    }

    public VarianceChecker(@JetValueParameter(name="trace") @NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/varianceChecker/VarianceChecker", "<init>"));
        }
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        this.trace = trace;
    }

    @platformStatic
    public static final void recordPrivateToThisIfNeeded(@JetValueParameter(name="trace") @NotNull BindingTrace trace, @JetValueParameter(name="descriptor") @NotNull CallableMemberDescriptor descriptor) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/varianceChecker/VarianceChecker", "recordPrivateToThisIfNeeded"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/varianceChecker/VarianceChecker", "recordPrivateToThisIfNeeded"));
        }
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(descriptor, "descriptor");
        OBJECT$.recordPrivateToThisIfNeeded(trace, descriptor);
    }

    @KotlinClass(abiVersion=19, data={"+\u0006)qb+\u0019:jC:\u001cWmQ8oM2L7\r\u001e#jC\u001etwn\u001d;jG\u0012\u000bG/\u0019\u0006\u0010-\u0006\u0014\u0018.\u00198dK\u000eCWmY6fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(b\u00016fi*!A.\u00198h\u0015\u001d\u0011Xm]8mm\u0016TqB^1sS\u0006t7-Z\"iK\u000e\\WM\u001d\u0006\u0004\u0003:L(BB6pi2LgN\u0003\u0004=S:LGO\u0010\u0006\u000fG>tG/Y5oS:<G+\u001f9f\u0015\u001dQU\r\u001e+za\u0016TQ\u0001^=qKNTQ\u0002^=qKB\u000b'/Y7fi\u0016\u0014(b\u0006+za\u0016\u0004\u0016M]1nKR,'\u000fR3tGJL\u0007\u000f^8s\u0015-!Wm]2sSB$xN]:\u000b%=\u001c7-\u001e:sK:\u001cW\rU8tSRLwN\u001c\u0006\t-\u0006\u0014\u0018.\u00198dK*\tr-\u001a;D_:$\u0018-\u001b8j]\u001e$\u0016\u0010]3\u000b+\u001d,GoT2dkJ\u0014XM\\2f!>\u001c\u0018\u000e^5p]*\u0001r-\u001a;UsB,\u0007+\u0019:b[\u0016$XM\u001d;\u000b\u0005A\u0011!\u0002\u0002\u0005\u0001!\rQA\u0001C\u0001\u0011\t)!\u0001B\u0001\t\u0006\u0015\u0011A1\u0001\u0005\u0004\u000b\t!!\u0001c\u0002\u0006\u0007\u0011\u0015\u0001\u0012\u0001\u0007\u0001\u000b\r!1\u0001\u0003\u0001\r\u0001\u0015\t\u0001\u0012B\u0003\u0004\t\u0011AA\u0001\u0004\u0001\u0006\u0005\u0011\r\u0001RB\u0003\u0004\t\u0015Aa\u0001\u0004\u0001\u0006\u0005\u0011\r\u0001\u0002C\u0003\u0004\t\u0019Ay\u0001\u0004\u0001\u0006\u0007\u0011)\u0001\"\u0003\u0007\u0001\u000b\t!Q\u0001\u0003\u0004\u0006\u0005\u00111\u0001rB\u0003\u0003\t\u0015A\u0011\u0002\u0002\u0001\r\be\u0011Q!\u0001E\u0005[=!\u0001\r\u0002M\u0006C\t)\u0011\u0001c\u0003V\u0007!)1\u0001b\u0003\n\u0003!=Qb\u0001C\n\u0013\u0005Ay!L\b\u0005A\u0012A\n\"\t\u0002\u0006\u0003!9Qk\u0001\u0005\u0006\u0007\u0011E\u0011\"\u0001E\t\u001b\r!!\"C\u0001\t\u00125zA\u0001\u0019\u0003\u0019\u000f\u0005\u0012Q!\u0001E\u0007+\u000eAQa\u0001\u0003\b\u0013\u0005A\u0001\"D\u0002\u0005\u0016%\t\u0001\u0002C[(\u000b\u001b\"1\u001d\u0001\r\u0006;\u001b!\u0001\u0001c\u0003\u000e\u0005\u0015\t\u00012\u0002)\u0004\u0001u5A\u0001\u0001\u0005\b\u001b\t)\u0011\u0001#\u0004Q\u0007\u0003ij\u0001\u0002\u0001\t\u00125\u0011Q!\u0001\u0005\b!\u000e\t\u0011EA\u0003\u0002\u0011\u000f\t6!\u0003\u0003\u0006\u0013\u0005!\u0001!D\u0001\t\u00105\t\u0001\u0002C\u0007\u0002\u0011#\u0001"})
    public static final class VarianceConflictDiagnosticData
    implements KObject {
        public static final /* synthetic */ KClassImpl $kotlinClass;
        @NotNull
        private final JetType containingType;
        @NotNull
        private final TypeParameterDescriptor typeParameter;
        @NotNull
        private final Variance occurrencePosition;

        static {
            $kotlinClass = InternalPackage.kClassFromKotlin(VarianceConflictDiagnosticData.class);
        }

        @NotNull
        public final JetType getContainingType() {
            JetType jetType = this.containingType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/varianceChecker/VarianceChecker$VarianceConflictDiagnosticData", "getContainingType"));
            }
            return jetType;
        }

        @NotNull
        public final TypeParameterDescriptor getTypeParameter() {
            TypeParameterDescriptor typeParameterDescriptor = this.typeParameter;
            if (typeParameterDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/varianceChecker/VarianceChecker$VarianceConflictDiagnosticData", "getTypeParameter"));
            }
            return typeParameterDescriptor;
        }

        @NotNull
        public final Variance getOccurrencePosition() {
            Variance variance = this.occurrencePosition;
            if (variance == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/varianceChecker/VarianceChecker$VarianceConflictDiagnosticData", "getOccurrencePosition"));
            }
            return variance;
        }

        public VarianceConflictDiagnosticData(@JetValueParameter(name="containingType") @NotNull JetType containingType, @JetValueParameter(name="typeParameter") @NotNull TypeParameterDescriptor typeParameter, @JetValueParameter(name="occurrencePosition") @NotNull Variance occurrencePosition) {
            if (containingType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingType", "org/jetbrains/jet/lang/resolve/varianceChecker/VarianceChecker$VarianceConflictDiagnosticData", "<init>"));
            }
            if (typeParameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/jet/lang/resolve/varianceChecker/VarianceChecker$VarianceConflictDiagnosticData", "<init>"));
            }
            if (occurrencePosition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "occurrencePosition", "org/jetbrains/jet/lang/resolve/varianceChecker/VarianceChecker$VarianceConflictDiagnosticData", "<init>"));
            }
            Intrinsics.checkParameterIsNotNull(containingType, "containingType");
            Intrinsics.checkParameterIsNotNull(typeParameter, "typeParameter");
            Intrinsics.checkParameterIsNotNull(occurrencePosition, "occurrencePosition");
            this.containingType = containingType;
            this.typeParameter = typeParameter;
            this.occurrencePosition = occurrencePosition;
        }
    }

    @KotlinClass(abiVersion=19, data={"\u0002\f)\u0011Ch\u00197bgNlsN\u00196fGRlcm\u001c:.-\u0006\u0014\u0018.\u00198dK\u000eCWmY6fezRqBV1sS\u0006t7-Z\"iK\u000e\\WM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\rQW\r\u001e\u0006\u0005Y\u0006twMC\u0004sKN|GN^3\u000b\u001fY\f'/[1oG\u0016\u001c\u0005.Z2lKJT1!\u00118z\u0015\u0019Yw\u000e\u001e7j]*A2\r[3dW\u000e\u000bG\u000e\\1cY\u0016$Um\u00197be\u0006$\u0018n\u001c8\u000b\u000bQ\u0014\u0018mY3\u000b\u001d\tKg\u000eZ5oO\u000e{g\u000e^3yi*YA-Z2mCJ\fG/[8o\u0015YQU\r^\"bY2\f'\r\\3EK\u000ed\u0017M]1uS>t'b\u00019tS*QA-Z:de&\u0004Ho\u001c:\u000b%\r\u000bG\u000e\\1cY\u0016$Um]2sSB$xN\u001d\u0006\fI\u0016\u001c8M]5qi>\u00148O\u0003\beS\u0006<gn\\:uS\u000e\u001c\u0016N\\6\u000b\u001d\u0011K\u0017m\u001a8pgRL7mU5oW*YA-[1h]>\u001cH/[2t\u0015\u001d\u0011un\u001c7fC:TA\"[:JeJ,G.\u001a<b]RT1C]3d_J$\u0007K]5wCR,Gk\u001c+iSNT\u0001dQ1mY\u0006\u0014G.Z'f[\n,'\u000fR3tGJL\u0007\u000f^8s\u0015\u0011)f.\u001b;\u000b7I,7m\u001c:e!JLg/\u0019;f)>$\u0006.[:JM:+W\rZ3e\u00151\u0011\u0015N\u001c3j]\u001e$&/Y2f\u0015\r\tg\u000e\u001a\u0006\u0006_RDWM\u001d\u0006\u0005U\u00064\u0018MC\rKKR$\u0016\u0010]3QCJ\fW.\u001a;fe2K7\u000f^(x]\u0016\u0014(bE2iK\u000e\\G+\u001f9f!\u0006\u0014\u0018-\\3uKJ\u001c(\u0002\u0004;za\u0016\u0004vn]5uS>t'\u0002\u0003,be&\fgnY3\u000b\u000bQL\b/Z:\u000b!)+G\u000fV=qKJ+g-\u001a:f]\u000e,'\"E2iK\u000e\\G+\u001f9f!>\u001c\u0018\u000e^5p]*A\u0001o\\:ji&|gNC\u0006UsB,')\u001b8eS:<'b\u0003;za\u0016\u0014\u0015N\u001c3j]\u001eT!\u0002U:j\u000b2,W.\u001a8u\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*q1m\u001c8uC&t\u0017N\\4UsB,'b\u0002&fiRK\b/\u001aX\u0003\u0015\t\u0001\"A\u0003\u0003\t\u0001A\u0019!\u0002\u0002\u0005\u0002!\u0011QA\u0001\u0003\u0002\u0011\u000b)!\u0001b\u0001\t\u0007\u0015\u0011AA\u0001E\u0004\u000b\r!)\u0001#\u0001\r\u0001\u0015\u0019Aa\u0001\u0005\u0001\u0019\u0001)\u0011\u0001#\u0003\u0006\u0007\u0011!\u0001\u0002\u0002\u0007\u0001\u000b\r!!\u0001\u0003\u0004\r\u0001\u0015\u0011A1\u0001E\b\u000b\r!Y\u0001C\u0004\r\u0001\u0015\u0011A1\u0001\u0005\n\u000b\r!i\u0001#\u0005\r\u0001\u0015\u0011A1\u0001E\u000b\u000b\r!y\u0001\u0003\u0006\r\u0001\u0015\u0019A\u0001\u0002\u0005\f\u0019\u0001)!\u0001\u0002\u0002\t\r\u0015\u0011A1\u0002\u0005\b\u000b\t!i\u0001#\u0005\u0006\u0005\u0011=\u0001BC\u0003\u0004\t\u001bAI\u0002\u0004\u0001\u0006\u0007\u0011!\u0001\"\u0004\u0007\u0001\u000b\t!i\u0001#\u0007\u0006\u0007\u0011\u0011\u0001B\u0004\u0007\u0001\u000b\t!!\u0001\u0003\b\u0006\u0003!}QA\u0001C\u000e\u0011\u000b)!\u0001\u0002\b\t\u0017\u0015\u0019A1\u0002\u0005\u0011\u0019\u0001)!\u0001b\u0001\t%\u0015\u0019Aq\u0004E\u0012\u0019\u0001)!\u0001b\u0003\t!\u0015\u0011Aq\u0004E\u0012\u000b\r!Y\u0001#\n\r\u0001\u0015\u0011A1\u0002E\u0013\u000b\t!!\u0001#\u000b\u0006\u0007\u0011\u0015\u0002\u0002\u0006\u0007\u0001\u000b\u0005AY#\u0002\u0002\u0005(!1RA\u0001\u0003\u0015\u0011\u001f)1\u0001\"\u000b\t+1\u0001Qa\u0001C\u0010\u0011]a\u0001!\u0002\u0002\u0005&!!RA\u0001C\u0010\u0011]!\u00019\u0001G\u00043\t)\u0011\u0001#\u0003.`\u0011\t\u0001$BO\u0007\t\u0001AY!\u0004\u0002\u0006\u0003!)\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001RB\u0007\u0003\u000b\u0005Aa\u0001UB\u0001;\u001b!\u0001\u0001\u0003\u0005\u000e\u0005\u0015\t\u0001b\u0002)\u0004\u0003u5A\u0001\u0001E\n\u001b\t)\u0011\u0001\u0003\u0005Q\u0007\u0007\t#!B\u0001\t\u0012E\u001b1\u0002B\u0003\n\u0003\u0011\u0005Q\"\u0001\u0005\n\u001b\u0005A\u0019\"D\u0001\t\u00155\t\u0001RC\u0017\u0014\t\u0005A:\"(\u0004\u0005\u0001!AQBA\u0003\u0002\u0011\u001d\u00016\u0001A\u0011\u0003\u000b\u0005A\t\"U\u0002\u0006\t/I\u0011\u0001\"\u0001\u000e\u0003!QQf\u0005\u0003\u000211ij\u0001\u0002\u0001\t\u00115\u0011Q!\u0001\u0005\f!\u000e\u0001\u0011EA\u0003\u0002\u0011/\t6!\u0002\u0003\r\u0013\u0005!\u0001!D\u0001\t\u00195fB\u0011\u0001M\u000e;\u001b!\u0001\u0001c\u0003\u000e\u0005\u0015\t\u0001\u0012\u0004)\u0004\u0001u5A\u0001\u0001\u0005\t\u001b\t)\u0011\u0001C\u0006Q\u0007\u0003\t#!B\u0001\t\u0018E\u001bq\u0001b\u0007\n\u0003\u0011\u0001Q\"\u0001\u0005\u000e\u001b\u0005AA\"L\r\u0005\u0003U\u0011Q!\u0001E\t1;iz\u0001\u0002\u0001\t\u001f5\u0019Q!\u0001E\t\u0019\u0003\u00016\u0011A\u0011\u0003\u000b\u0005A\t\"U\u0002\b\t;I\u0011\u0001\"\u0001\u000e\u0003\u0011\u0005Q\"\u0001E\u000f[-\"\u0011!\u0006\u0002\u0006\u0003!y\u0001\u0014EO\u0007\t\u0001AY!\u0004\u0002\u0006\u0003!)\u0001k!\u0001\u001e\u000e\u0011\u0001\u0001\"E\u0007\u0003\u000b\u0005A\u0001\u0003U\u0002\u0002;\u001b!\u0001\u0001c\u0005\u000e\u0005\u0015\t\u0001\u0002\u0003)\u0004\u0004\u0005\u0012Q!\u0001E\t#\u000eYA\u0011E\u0005\u0002\t\u0003i\u0011\u0001#\t\u000e\u0003!IQ\"\u0001\u0005\u0012\u001b\u0005A)\"\f\u0017\u0005\u0003U\u0011Q!\u0001E\u00121Mij\u0001\u0002\u0001\t\f5\u0011Q!\u0001\u0005\u0006!\u000e\u0005QT\u0002\u0003\u0001\u0011Oi!!B\u0001\t!A\u001b\u0011!(\u0004\u0005\u0001!MQBA\u0003\u0002\u0011!\u000161A\u0011\u0004\u000b\u0005A\t\u0002$\u0001R\u0007-!1#C\u0001\t\u001e5\t\u0001BE\u0007\u0002\u0011%i\u0011\u0001C\t\u000e\u0003!UQf\f\u0003\u0002+\u0019)\u0011\u0001C\n\n\u0007%\u0011Q!\u0001\u0005\u00161Mij\u0001\u0002\u0001\t.5\u0011Q!\u0001E\u0016!\u000e\u0005QT\u0002\u0003\u0001\u0011Oi!!B\u0001\t!A\u001b\u0011!(\u0004\u0005\u0001!MQBA\u0003\u0002\u0011!\u000161A\u0011\u0003\u000b\u0005A\t\"U\u0002\f\tMI\u0011\u0001\"\u0001\u000e\u0003!1R\"\u0001E\u0017\u001b\u0005A\u0011#D\u0001\t\u00165.C!A\u000b\u0007\u000b\u0005A1#C\u0002\n\u0005\u0015\t\u0001\"\u0006\r\u0014;\u001b!\u0001\u0001c\n\u000e\u0005\u0015\t\u0001\u0002\u0005)\u0004\u0002u5A\u0001\u0001E\n\u001b\t)\u0011\u0001\u0003\u0005Q\u0007\u0005\t#!B\u0001\t\u0012E\u001b\u0011\u0002B\n\n\u0003\u0011\u0005Q\"\u0001\u0005\u0017\u001b\u0005A\u0011#D\u0001\t\u0016U\u0002\u0001"})
    public static final class object
    implements KObject {
        public static final /* synthetic */ KClassImpl $kotlinClass;

        static {
            $kotlinClass = InternalPackage.kClassFromKotlin(object.class);
        }

        @platformStatic
        public final void recordPrivateToThisIfNeeded(@JetValueParameter(name="trace") @NotNull BindingTrace trace, @JetValueParameter(name="descriptor") @NotNull CallableMemberDescriptor descriptor) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/varianceChecker/VarianceChecker$object", "recordPrivateToThisIfNeeded"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/varianceChecker/VarianceChecker$object", "recordPrivateToThisIfNeeded"));
            }
            Intrinsics.checkParameterIsNotNull(trace, "trace");
            Intrinsics.checkParameterIsNotNull(descriptor, "descriptor");
            if (!this.isIrrelevant(descriptor) ? Intrinsics.areEqual(descriptor.getVisibility(), Visibilities.PRIVATE) ^ true : true) {
                return;
            }
            PsiElement psiElement = SourcePackage$KotlinSourceElement$aaf94477.getPsi(descriptor.getSource());
            if (!(psiElement instanceof JetCallableDeclaration)) {
                return;
            }
            BindingContext bindingContext = trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.getBindingContext()");
            JetCallableDeclaration jetCallableDeclaration = (JetCallableDeclaration)psiElement;
            CallableDescriptor callableDescriptor = descriptor;
            DiagnosticSink diagnosticSink = DiagnosticSink.DO_NOTHING;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticSink, "DiagnosticSink.DO_NOTHING");
            if (!this.checkCallableDeclaration(bindingContext, jetCallableDeclaration, callableDescriptor, diagnosticSink)) {
                this.recordPrivateToThis(descriptor);
            }
        }

        private final boolean isIrrelevant(@JetValueParameter(name="descriptor") CallableDescriptor descriptor) {
            boolean bl;
            block2: {
                DeclarationDescriptor containingClass = descriptor.getContainingDeclaration();
                if (!(containingClass instanceof ClassDescriptor)) {
                    return true;
                }
                Iterable iterable = ((ClassDescriptor)containingClass).getTypeConstructor().getParameters();
                for (Object t : iterable) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)t;
                    if (Intrinsics.areEqual(it.getVariance(), Variance.INVARIANT)) continue;
                    bl = false;
                    break block2;
                }
                bl = true;
            }
            return bl;
        }

        private final void recordPrivateToThis(@JetValueParameter(name="descriptor") CallableMemberDescriptor descriptor) {
            if (descriptor instanceof FunctionDescriptorImpl) {
                ((FunctionDescriptorImpl)descriptor).setVisibility(Visibilities.PRIVATE_TO_THIS);
            } else if (descriptor instanceof PropertyDescriptorImpl) {
                ((PropertyDescriptorImpl)descriptor).setVisibility(Visibilities.PRIVATE_TO_THIS);
                Iterator<PropertyAccessorDescriptor> iterator2 = ((PropertyDescriptorImpl)descriptor).getAccessors().iterator();
                while (iterator2.hasNext()) {
                    PropertyAccessorDescriptor accessor;
                    PropertyAccessorDescriptor propertyAccessorDescriptor = accessor = iterator2.next();
                    if (propertyAccessorDescriptor == null) {
                        throw new TypeCastException("org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor! cannot be cast to org.jetbrains.jet.lang.descriptors.impl.PropertyAccessorDescriptorImpl");
                    }
                    ((PropertyAccessorDescriptorImpl)propertyAccessorDescriptor).setVisibility(Visibilities.PRIVATE_TO_THIS);
                }
            } else {
                throw (Throwable)new IllegalStateException("Unexpected descriptor type: " + descriptor.getClass().getName());
            }
        }

        private final boolean checkCallableDeclaration(@JetValueParameter(name="trace") BindingContext trace, @JetValueParameter(name="declaration") JetCallableDeclaration declaration, @JetValueParameter(name="descriptor") CallableDescriptor descriptor, @JetValueParameter(name="diagnosticSink") DiagnosticSink diagnosticSink) {
            if (this.isIrrelevant(descriptor)) {
                return true;
            }
            boolean noError = true;
            noError &= this.checkTypeParameters(declaration, trace, Variance.IN_VARIANCE, diagnosticSink);
            JetTypeReference jetTypeReference = declaration.getReceiverTypeReference();
            noError = this.and(noError, jetTypeReference != null ? this.checkTypePosition(jetTypeReference, trace, Variance.IN_VARIANCE, diagnosticSink) : null);
            for (JetParameter parameter : declaration.getValueParameters()) {
                JetTypeReference jetTypeReference2 = parameter.getTypeReference();
                noError = this.and(noError, jetTypeReference2 != null ? this.checkTypePosition(jetTypeReference2, trace, Variance.IN_VARIANCE, diagnosticSink) : null);
            }
            Variance returnTypePosition = (descriptor instanceof VariableDescriptor ? ((VariableDescriptor)descriptor).isVar() : false) ? Variance.INVARIANT : Variance.OUT_VARIANCE;
            TypeBinding<PsiElement> typeBinding = TypeBindingPackage$TypeBinding$86120a0d.createTypeBindingForReturnType(declaration, trace);
            noError = this.and(noError, typeBinding != null ? Boolean.valueOf(this.checkTypePosition(typeBinding, returnTypePosition, diagnosticSink)) : null);
            return noError;
        }

        private final boolean checkTypeParameters(@JetValueParameter(name="$receiver") JetTypeParameterListOwner $receiver, @JetValueParameter(name="trace") BindingContext trace, @JetValueParameter(name="typePosition") Variance typePosition, @JetValueParameter(name="diagnosticSink") DiagnosticSink diagnosticSink) {
            boolean noError = true;
            for (JetTypeParameter typeParameter : $receiver.getTypeParameters()) {
                JetTypeReference jetTypeReference = typeParameter.getExtendsBound();
                noError = this.and(noError, jetTypeReference != null ? this.checkTypePosition(jetTypeReference, trace, typePosition, diagnosticSink) : null);
            }
            for (JetTypeConstraint typeConstraint : $receiver.getTypeConstraints()) {
                JetTypeReference jetTypeReference = typeConstraint.getBoundTypeReference();
                noError = this.and(noError, jetTypeReference != null ? this.checkTypePosition(jetTypeReference, trace, typePosition, diagnosticSink) : null);
            }
            return noError;
        }

        private final Boolean checkTypePosition(@JetValueParameter(name="$receiver") JetTypeReference $receiver, @JetValueParameter(name="trace") BindingContext trace, @JetValueParameter(name="position") Variance position, @JetValueParameter(name="diagnosticSink") DiagnosticSink diagnosticSink) {
            TypeBinding<JetTypeElement> typeBinding = TypeBindingPackage$TypeBinding$86120a0d.createTypeBinding($receiver, trace);
            return typeBinding != null ? Boolean.valueOf(this.checkTypePosition(typeBinding, position, diagnosticSink)) : null;
        }

        private final boolean checkTypePosition(@JetValueParameter(name="$receiver") TypeBinding<? extends PsiElement> $receiver, @JetValueParameter(name="position") Variance position, @JetValueParameter(name="diagnosticSink") DiagnosticSink diagnosticSink) {
            return this.checkTypePosition($receiver, $receiver.getJetType(), position, diagnosticSink);
        }

        private final boolean checkTypePosition(@JetValueParameter(name="$receiver") TypeBinding<? extends PsiElement> $receiver, @JetValueParameter(name="containingType") JetType containingType, @JetValueParameter(name="position") Variance position, @JetValueParameter(name="diagnosticSink") DiagnosticSink diagnosticSink) {
            ClassifierDescriptor classifierDescriptor = $receiver.getJetType().getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor instanceof TypeParameterDescriptor) {
                Variance declarationVariance = ((TypeParameterDescriptor)classifierDescriptor).getVariance();
                if (!declarationVariance.allowsPosition(position)) {
                    diagnosticSink.report(Errors.TYPE_VARIANCE_CONFLICT.on($receiver.getPsiElement(), new VarianceConflictDiagnosticData(containingType, (TypeParameterDescriptor)classifierDescriptor, position)));
                }
                return declarationVariance.allowsPosition(position);
            }
            boolean noError = true;
            for (TypeArgumentBinding<? extends PsiElement> argumentBinding : $receiver.getArgumentBindings()) {
                Variance newPosition;
                Variance variance;
                TypeCheckingProcedure.EnrichedProjectionKind projectionKind;
                TypeCheckingProcedure.EnrichedProjectionKind enrichedProjectionKind;
                if (!(argumentBinding == null) ? argumentBinding.getTypeParameterDescriptor() == null : true) continue;
                if (TypeCheckingProcedure.getEffectiveProjectionKind(argumentBinding.getTypeParameterDescriptor(), argumentBinding.getTypeProjection()) == null) {
                    Intrinsics.throwNpe();
                }
                if (Intrinsics.areEqual((Object)(enrichedProjectionKind = projectionKind), (Object)TypeCheckingProcedure.EnrichedProjectionKind.OUT)) {
                    variance = position;
                } else if (Intrinsics.areEqual((Object)enrichedProjectionKind, (Object)TypeCheckingProcedure.EnrichedProjectionKind.IN)) {
                    variance = position.opposite();
                } else if (Intrinsics.areEqual((Object)enrichedProjectionKind, (Object)TypeCheckingProcedure.EnrichedProjectionKind.INV)) {
                    variance = Variance.INVARIANT;
                } else if (Intrinsics.areEqual((Object)enrichedProjectionKind, (Object)TypeCheckingProcedure.EnrichedProjectionKind.STAR)) {
                    variance = null;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                if (!((newPosition = variance) != null)) continue;
                noError &= this.checkTypePosition(argumentBinding.getTypeBinding(), containingType, newPosition, diagnosticSink);
            }
            return noError;
        }

        private final boolean and(@JetValueParameter(name="$receiver") boolean $receiver, @JetValueParameter(name="other", type="?") Boolean other) {
            return other == null ? $receiver : $receiver & other;
        }

        private object() {
        }

        public static final /* synthetic */ boolean checkCallableDeclaration$b$0(@JetValueParameter(name="$this", type="?") object $this, @JetValueParameter(name="trace") @NotNull BindingContext trace, @JetValueParameter(name="declaration") @NotNull JetCallableDeclaration declaration, @JetValueParameter(name="descriptor") @NotNull CallableDescriptor descriptor, @JetValueParameter(name="diagnosticSink") @NotNull DiagnosticSink diagnosticSink) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/varianceChecker/VarianceChecker$object", "checkCallableDeclaration$b$0"));
            }
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/varianceChecker/VarianceChecker$object", "checkCallableDeclaration$b$0"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/varianceChecker/VarianceChecker$object", "checkCallableDeclaration$b$0"));
            }
            if (diagnosticSink == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnosticSink", "org/jetbrains/jet/lang/resolve/varianceChecker/VarianceChecker$object", "checkCallableDeclaration$b$0"));
            }
            return $this.checkCallableDeclaration(trace, declaration, descriptor, diagnosticSink);
        }

        public static final /* synthetic */ boolean checkTypeParameters$b$1(@JetValueParameter(name="$this", type="?") object $this, @JetValueParameter(name="$receiver") JetTypeParameterListOwner $receiver, @JetValueParameter(name="trace") @NotNull BindingContext trace, @JetValueParameter(name="typePosition") @NotNull Variance typePosition, @JetValueParameter(name="diagnosticSink") @NotNull DiagnosticSink diagnosticSink) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/varianceChecker/VarianceChecker$object", "checkTypeParameters$b$1"));
            }
            if (typePosition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typePosition", "org/jetbrains/jet/lang/resolve/varianceChecker/VarianceChecker$object", "checkTypeParameters$b$1"));
            }
            if (diagnosticSink == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnosticSink", "org/jetbrains/jet/lang/resolve/varianceChecker/VarianceChecker$object", "checkTypeParameters$b$1"));
            }
            return $this.checkTypeParameters($receiver, trace, typePosition, diagnosticSink);
        }

        @Nullable
        public static final /* synthetic */ Boolean checkTypePosition$b$2(@JetValueParameter(name="$this", type="?") object $this, @JetValueParameter(name="$receiver") JetTypeReference $receiver, @JetValueParameter(name="trace") @NotNull BindingContext trace, @JetValueParameter(name="position") @NotNull Variance position, @JetValueParameter(name="diagnosticSink") @NotNull DiagnosticSink diagnosticSink) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/varianceChecker/VarianceChecker$object", "checkTypePosition$b$2"));
            }
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/jet/lang/resolve/varianceChecker/VarianceChecker$object", "checkTypePosition$b$2"));
            }
            if (diagnosticSink == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnosticSink", "org/jetbrains/jet/lang/resolve/varianceChecker/VarianceChecker$object", "checkTypePosition$b$2"));
            }
            return $this.checkTypePosition($receiver, trace, position, diagnosticSink);
        }

        @NotNull
        public static final /* synthetic */ object $init$b$3() {
            object object2 = new object();
            if (object2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/varianceChecker/VarianceChecker$object", "$init$b$3"));
            }
            return object2;
        }
    }
}

