/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.jvm.internal.InternalPackage;
import kotlin.reflect.jvm.internal.KClassImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassImpl;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinBinaryClassCache;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.jet.lang.resolve.kotlin.VirtualFileFinder;
import org.jetbrains.jet.lang.resolve.name.ClassId;
import org.jetbrains.kotlin.util.UtilPackage$coreLib$6cf4a23f;

@KotlinClass(abiVersion=19, data={"k\u0004)ab+\u001b:uk\u0006dg)\u001b7f\u0017>$H.\u001b8DY\u0006\u001c8OR5oI\u0016\u0014(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0004U\u0016$(\u0002\u00027b]\u001eTqA]3t_24XM\u0003\u0004l_Rd\u0017N\u001c\u0006\u0012-&\u0014H/^1m\r&dWMR5oI\u0016\u0014(B\u0002\u001fj]&$hHC\u0007dY\u0006\u001c8OR5mK:\u000bW.\u001a\u0006\u0007U\u000ec\u0017m]:\u000b\u0013)\u000bg/Y\"mCN\u001c(\u0002\u00026bm\u0006T\u0011b\u001d;sk\u000e$XO]3\u000b\rM#(/\u001b8h\u0015=1\u0017N\u001c3L_Rd\u0017N\\\"mCN\u001c(\"\u00036bm\u0006\u001cE.Y:t\u0015QYu\u000e\u001e7j]*3XNQ5oCJL8\t\\1tg*91\r\\1tg&#'bB\"mCN\u001c\u0018\n\u001a\u0006\u0005]\u0006lWMc\u0001\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0003\u000b\t!!\u0001C\u0002\u0006\u0007\u0011\u0015\u0001\u0002\u0001\u0007\u0001\u000b\r!)\u0001c\u0002\r\u0001\u0015\u0011AA\u0001\u0005\u0007\u000b\t!A\u0001#\u0004\u0006\u0007\u0011%\u00012\u0002\u0007\u0001\u000b\u0005A1!B\u0002\u0005\f!9A\u0002A\u0003\u0002\u0011\u0019)!\u0001\"\u0004\t\u0005\u0015\u0011Aa\u0002\u0005\b\u000b\t!I\u0001c\u0003\u0006\u0007\u0011\u0015\u0001\u0012\u0003\u0007\u0001\u000b\t!)\u0001#\u0005\u0006\u0005\u0011\u0011\u0001BC\u0003\u0004\t'A\u0019\u0002\u0004\u0001\u0006\u0005\u0011M\u00012\u0003\u0003\u0014\u0019\rI\"!B\u0001\t\b5\u001aB!\u0001M\u0005;\u001b!\u0001\u0001C\u0003\u000e\u0005\u0015\t\u0001\"\u0002)\u0004\u0001\u0005\u0012Q!\u0001\u0005\u0007#\u000e)A\u0011B\u0005\u0002\u0011\u001fi\u0011\u0001\u0003\u0005.)\u0011Y\u0001tBO\u0007\t\u0001A\u0001\"\u0004\u0002\u0006\u0003!)\u0001k\u0001\u0001\"\u0007\u0015\t\u0001\u0012\u0003G\u0001#\u000e)AqB\u0005\u0002\u0011%i\u0011\u0001\u0003\u0005.)\u0011Y\u0001tBO\u0007\t\u0001A\u0011\"\u0004\u0002\u0006\u0003!Q\u0001k\u0001\u0001\"\u0007\u0015\t\u0001\u0012\u0003G\u0001#\u000e)AqB\u0005\u0002\u0011%i\u0011\u0001#\u00066\u0017\u0015QAa9\u0001\u0019\t\u0005\u0012Q!\u0001\u0005\u0004#\u000e\u0019A\u0001B\u0005\u0002\t\u0001\u0001"})
public abstract class VirtualFileKotlinClassFinder
implements KObject,
VirtualFileFinder {
    public static final /* synthetic */ KClassImpl $kotlinClass;

    static {
        $kotlinClass = InternalPackage.kClassFromKotlin(VirtualFileKotlinClassFinder.class);
    }

    @Override
    @Nullable
    public KotlinJvmBinaryClass findKotlinClass(@JetValueParameter(name="classId") @NotNull ClassId classId) {
        if (classId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClassFinder", "findKotlinClass"));
        }
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        VirtualFile virtualFile = this.findVirtualFileWithHeader(classId.asSingleFqName().toSafe());
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        return KotlinBinaryClassCache.getKotlinBinaryClass(file);
    }

    @Override
    @Nullable
    public KotlinJvmBinaryClass findKotlinClass(@JetValueParameter(name="javaClass") @NotNull JavaClass javaClass) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClassFinder", "findKotlinClass"));
        }
        Intrinsics.checkParameterIsNotNull(javaClass, "javaClass");
        JavaClass javaClass2 = javaClass;
        if (javaClass2 == null) {
            throw new TypeCastException("org.jetbrains.jet.lang.resolve.java.structure.JavaClass cannot be cast to org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassImpl");
        }
        PsiFile psiFile = ((PsiClass)((JavaClassImpl)javaClass2).getPsi()).getContainingFile();
        if (psiFile == null) {
            Intrinsics.throwNpe();
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        if (((JavaClassImpl)javaClass).getOuterClass() != null) {
            VirtualFile virtualFile2 = file.getParent();
            if (virtualFile2 == null) {
                Intrinsics.throwNpe();
            }
            VirtualFile virtualFile3 = UtilPackage$coreLib$6cf4a23f.sure(virtualFile2.findChild(this.classFileName(javaClass) + ".class"), "Virtual file not found for " + javaClass);
            Intrinsics.checkExpressionValueIsNotNull(virtualFile3, "file.getParent()!!.findC\u2026ot found for $javaClass\")");
            file = virtualFile3;
        }
        return KotlinBinaryClassCache.getKotlinBinaryClass(file);
    }

    private final String classFileName(@JetValueParameter(name="jClass") JavaClass jClass) {
        JavaClass outerClass = jClass.getOuterClass();
        if (outerClass == null) {
            String string = jClass.getName().asString();
            Intrinsics.checkExpressionValueIsNotNull(string, "jClass.getName().asString()");
            return string;
        }
        return this.classFileName(outerClass) + "$" + jClass.getName().asString();
    }
}

