/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.structure.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.structure.JavaArrayType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifier;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifierType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaPrimitiveType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeParameter;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeSubstitutor;
import org.jetbrains.jet.lang.resolve.java.structure.JavaWildcardType;

public class JavaTypeSubstitutorImpl
implements JavaTypeSubstitutor {
    private final Map<JavaTypeParameter, JavaType> substitutionMap;

    public JavaTypeSubstitutorImpl(@NotNull Map<JavaTypeParameter, JavaType> substitutionMap) {
        if (substitutionMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutionMap", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "<init>"));
        }
        this.substitutionMap = substitutionMap;
    }

    @Override
    @NotNull
    public JavaType substitute(@NotNull JavaType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "substitute"));
        }
        JavaType substitutedType = this.substituteInternal(type2);
        JavaType javaType = substitutedType != null ? substitutedType : this.correctSubstitutionForRawType(type2);
        if (javaType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "substitute"));
        }
        return javaType;
    }

    @NotNull
    private JavaType correctSubstitutionForRawType(@NotNull JavaType original) {
        JavaClassifier classifier2;
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "correctSubstitutionForRawType"));
        }
        if (original instanceof JavaClassifierType && (classifier2 = ((JavaClassifierType)original).getClassifier()) instanceof JavaTypeParameter) {
            JavaType javaType = this.rawTypeForTypeParameter((JavaTypeParameter)classifier2);
            if (javaType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "correctSubstitutionForRawType"));
            }
            return javaType;
        }
        JavaType javaType = original;
        if (javaType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "correctSubstitutionForRawType"));
        }
        return javaType;
    }

    @Nullable
    private JavaType substituteInternal(@NotNull JavaType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "substituteInternal"));
        }
        if (type2 instanceof JavaClassifierType) {
            JavaClassifierType classifierType = (JavaClassifierType)type2;
            JavaClassifier classifier2 = classifierType.getClassifier();
            if (classifier2 instanceof JavaTypeParameter) {
                return this.substitute((JavaTypeParameter)classifier2);
            }
            if (classifier2 instanceof JavaClass) {
                JavaClass javaClass = (JavaClass)classifier2;
                HashMap<JavaTypeParameter, JavaType> substMap = new HashMap<JavaTypeParameter, JavaType>();
                this.processClass(javaClass, classifierType.getSubstitutor(), substMap);
                return javaClass.createImmediateType(new JavaTypeSubstitutorImpl(substMap));
            }
            return type2;
        }
        if (type2 instanceof JavaPrimitiveType) {
            return type2;
        }
        if (type2 instanceof JavaArrayType) {
            JavaType componentType = ((JavaArrayType)type2).getComponentType();
            JavaType substitutedComponentType = this.substitute(componentType);
            if (substitutedComponentType == componentType) {
                return type2;
            }
            return substitutedComponentType.createArrayType();
        }
        if (type2 instanceof JavaWildcardType) {
            return this.substituteWildcardType((JavaWildcardType)type2);
        }
        return type2;
    }

    private void processClass(@NotNull JavaClass javaClass, @NotNull JavaTypeSubstitutor substitutor, @NotNull Map<JavaTypeParameter, JavaType> substMap) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "processClass"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "processClass"));
        }
        if (substMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substMap", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "processClass"));
        }
        List<JavaTypeParameter> typeParameters = javaClass.getTypeParameters();
        for (JavaTypeParameter typeParameter : typeParameters) {
            JavaType substitutedParam = substitutor.substitute(typeParameter);
            if (substitutedParam == null) {
                substMap.put(typeParameter, null);
                continue;
            }
            substMap.put(typeParameter, this.substituteInternal(substitutedParam));
        }
        if (javaClass.isStatic()) {
            return;
        }
        JavaClass outerClass = javaClass.getOuterClass();
        if (outerClass != null) {
            this.processClass(outerClass, substitutor, substMap);
        }
    }

    @Nullable
    private JavaType substituteWildcardType(@NotNull JavaWildcardType wildcardType) {
        if (wildcardType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wildcardType", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "substituteWildcardType"));
        }
        JavaType bound = wildcardType.getBound();
        if (bound == null) {
            return wildcardType;
        }
        JavaType newBound = this.substituteInternal(bound);
        if (newBound == null) {
            return null;
        }
        return JavaTypeSubstitutorImpl.rebound(wildcardType, newBound);
    }

    @NotNull
    private static JavaWildcardType rebound(@NotNull JavaWildcardType type2, @NotNull JavaType newBound) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "rebound"));
        }
        if (newBound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newBound", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "rebound"));
        }
        if (type2.getTypeProvider().createJavaLangObjectType().equals(newBound)) {
            JavaWildcardType javaWildcardType = type2.getTypeProvider().createUnboundedWildcard();
            if (javaWildcardType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "rebound"));
            }
            return javaWildcardType;
        }
        if (type2.isExtends()) {
            JavaWildcardType javaWildcardType = type2.getTypeProvider().createUpperBoundWildcard(newBound);
            if (javaWildcardType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "rebound"));
            }
            return javaWildcardType;
        }
        JavaWildcardType javaWildcardType = type2.getTypeProvider().createLowerBoundWildcard(newBound);
        if (javaWildcardType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "rebound"));
        }
        return javaWildcardType;
    }

    @NotNull
    private JavaType rawTypeForTypeParameter(@NotNull JavaTypeParameter typeParameter) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "rawTypeForTypeParameter"));
        }
        Collection<JavaClassifierType> bounds = typeParameter.getUpperBounds();
        if (!bounds.isEmpty()) {
            JavaType javaType = this.substitute(bounds.iterator().next());
            if (javaType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "rawTypeForTypeParameter"));
            }
            return javaType;
        }
        JavaType javaType = typeParameter.getTypeProvider().createJavaLangObjectType();
        if (javaType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "rawTypeForTypeParameter"));
        }
        return javaType;
    }

    @Override
    @Nullable
    public JavaType substitute(@NotNull JavaTypeParameter typeParameter) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "substitute"));
        }
        if (this.substitutionMap.containsKey(typeParameter)) {
            return this.substitutionMap.get(typeParameter);
        }
        return typeParameter.getType();
    }

    @Override
    @NotNull
    public Map<JavaTypeParameter, JavaType> getSubstitutionMap() {
        Map<JavaTypeParameter, JavaType> map = this.substitutionMap;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "getSubstitutionMap"));
        }
        return map;
    }

    public int hashCode() {
        return ((Object)this.substitutionMap).hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof JavaTypeSubstitutorImpl && ((Object)this.substitutionMap).equals(((JavaTypeSubstitutorImpl)obj).substitutionMap);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.substitutionMap;
    }
}

