/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Function1;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.resolve.java.resolver.ErrorReporter;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifier;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifierType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMember;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.resolve.java.structure.JavaType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaValueParameter;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class DescriptorResolverUtils {
    private DescriptorResolverUtils() {
    }

    @NotNull
    public static <D extends CallableMemberDescriptor> Collection<D> resolveOverrides(@NotNull Name name, @NotNull Collection<D> membersFromSupertypes, @NotNull Collection<D> membersFromCurrent, @NotNull ClassDescriptor classDescriptor, final @NotNull ErrorReporter errorReporter) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "resolveOverrides"));
        }
        if (membersFromSupertypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "membersFromSupertypes", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "resolveOverrides"));
        }
        if (membersFromCurrent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "membersFromCurrent", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "resolveOverrides"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "resolveOverrides"));
        }
        if (errorReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorReporter", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "resolveOverrides"));
        }
        final HashSet result2 = new HashSet();
        OverridingUtil.generateOverridesInFunctionGroup(name, membersFromSupertypes, membersFromCurrent, classDescriptor, new OverridingUtil.DescriptorSink(){

            @Override
            public void addToScope(@NotNull CallableMemberDescriptor fakeOverride) {
                if (fakeOverride == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fakeOverride", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils$1", "addToScope"));
                }
                OverridingUtil.resolveUnknownVisibilityForMember(fakeOverride, new Function1<CallableMemberDescriptor, Unit>(){

                    @Override
                    public Unit invoke(@NotNull CallableMemberDescriptor descriptor) {
                        if (descriptor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils$1$1", "invoke"));
                        }
                        errorReporter.reportCannotInferVisibility(descriptor);
                        return Unit.INSTANCE$;
                    }
                });
                result2.add(fakeOverride);
            }

            @Override
            public void conflict(@NotNull CallableMemberDescriptor fromSuper, @NotNull CallableMemberDescriptor fromCurrent) {
                if (fromSuper == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromSuper", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils$1", "conflict"));
                }
                if (fromCurrent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromCurrent", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils$1", "conflict"));
                }
            }
        });
        HashSet hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "resolveOverrides"));
        }
        return hashSet;
    }

    @Nullable
    public static ValueParameterDescriptor getAnnotationParameterByName(@NotNull Name name, @NotNull ClassDescriptor annotationClass) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "getAnnotationParameterByName"));
        }
        if (annotationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClass", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "getAnnotationParameterByName"));
        }
        Collection<ConstructorDescriptor> constructors2 = annotationClass.getConstructors();
        assert (constructors2.size() == 1) : "Annotation class descriptor must have only one constructor";
        for (ValueParameterDescriptor parameter : constructors2.iterator().next().getValueParameters()) {
            if (!parameter.getName().equals(name)) continue;
            return parameter;
        }
        return null;
    }

    public static boolean isObjectMethodInInterface(@NotNull JavaMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "isObjectMethodInInterface"));
        }
        return member.getContainingClass().isInterface() && member instanceof JavaMethod && DescriptorResolverUtils.isObjectMethod((JavaMethod)member);
    }

    public static boolean isObjectMethod(@NotNull JavaMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "isObjectMethod"));
        }
        String name = method.getName().asString();
        if (name.equals("toString") || name.equals("hashCode")) {
            return method.getValueParameters().isEmpty();
        }
        if (name.equals("equals")) {
            return DescriptorResolverUtils.isMethodWithOneParameterWithFqName(method, "java.lang.Object");
        }
        return false;
    }

    private static boolean isMethodWithOneParameterWithFqName(@NotNull JavaMethod method, @NotNull String fqName2) {
        JavaClassifier classifier2;
        JavaType type2;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "isMethodWithOneParameterWithFqName"));
        }
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/resolver/DescriptorResolverUtils", "isMethodWithOneParameterWithFqName"));
        }
        List<JavaValueParameter> parameters2 = method.getValueParameters();
        if (parameters2.size() == 1 && (type2 = parameters2.get(0).getType()) instanceof JavaClassifierType && (classifier2 = ((JavaClassifierType)type2).getClassifier()) instanceof JavaClass) {
            FqName classFqName = ((JavaClass)classifier2).getFqName();
            return classFqName != null && classFqName.asString().equals(fqName2);
        }
        return false;
    }
}

