/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.kotlinSignature;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.jet.lang.psi.JetTypeElement;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.resolve.AnalyzingUtils;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.AlternativeSignatureMismatchException;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.TypeTransformingVisitor;
import org.jetbrains.jet.lang.resolve.java.resolver.TypeUsage;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.renderer.DescriptorRenderer;

public abstract class ElementAlternativeSignatureData {
    private String error;
    private boolean isAnnotated;

    public final boolean hasErrors() {
        return this.error != null;
    }

    @NotNull
    public final String getError() {
        if (this.error == null) {
            throw new IllegalStateException("There are no errors");
        }
        String string = this.error;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/ElementAlternativeSignatureData", "getError"));
        }
        return string;
    }

    protected final void setError(@Nullable String error) {
        this.error = error;
    }

    public boolean isAnnotated() {
        return this.isAnnotated;
    }

    protected final void checkForErrors() {
        if (!this.isAnnotated() || this.hasErrors()) {
            throw new IllegalStateException("Trying to read result while there is none");
        }
    }

    protected final void setAnnotated(boolean isAnnotated) {
        this.isAnnotated = isAnnotated;
    }

    protected static void checkForSyntaxErrors(PsiElement namedElement) {
        List<PsiErrorElement> syntaxErrors = AnalyzingUtils.getSyntaxErrorRanges(namedElement);
        if (!syntaxErrors.isEmpty()) {
            int errorOffset = syntaxErrors.get(0).getTextOffset();
            String syntaxErrorDescription = syntaxErrors.get(0).getErrorDescription();
            if (syntaxErrors.size() == 1) {
                throw new AlternativeSignatureMismatchException("Alternative signature has syntax error at %d: %s", errorOffset, syntaxErrorDescription);
            }
            throw new AlternativeSignatureMismatchException("Alternative signature has %d syntax errors, first is at %d: %s", syntaxErrors.size(), errorOffset, syntaxErrorDescription);
        }
    }

    protected static JetType computeReturnType(@NotNull JetType originalType, @Nullable JetTypeReference altReturnTypeReference, @NotNull Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> originalToAltTypeParameters) {
        if (originalType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/ElementAlternativeSignatureData", "computeReturnType"));
        }
        if (originalToAltTypeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalToAltTypeParameters", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/ElementAlternativeSignatureData", "computeReturnType"));
        }
        if (altReturnTypeReference == null) {
            if (KotlinBuiltIns.isUnit(originalType)) {
                return originalType;
            }
            throw new AlternativeSignatureMismatchException("Return type in alternative signature is missing, while in real signature it is '%s'", DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(originalType));
        }
        JetTypeElement typeElement = altReturnTypeReference.getTypeElement();
        assert (typeElement != null);
        return TypeTransformingVisitor.computeType(typeElement, originalType, originalToAltTypeParameters, TypeUsage.MEMBER_SIGNATURE_COVARIANT);
    }
}

