/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentProvider;
import org.jetbrains.jet.lang.descriptors.impl.CompositePackageFragmentProvider;
import org.jetbrains.jet.lang.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutablePackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.PackageLikeBuilder;
import org.jetbrains.jet.lang.descriptors.impl.PackageLikeBuilderDummy;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.BodyResolver;
import org.jetbrains.jet.lang.resolve.DeclarationResolver;
import org.jetbrains.jet.lang.resolve.JetModuleUtil;
import org.jetbrains.jet.lang.resolve.MutablePackageFragmentProvider;
import org.jetbrains.jet.lang.resolve.OverloadResolver;
import org.jetbrains.jet.lang.resolve.OverrideResolver;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.TypeHierarchyResolver;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.varianceChecker.VarianceChecker;

@Deprecated
public class TopDownAnalyzer {
    @NotNull
    private DeclarationResolver declarationResolver;
    @NotNull
    private TypeHierarchyResolver typeHierarchyResolver;
    @NotNull
    private OverrideResolver overrideResolver;
    @NotNull
    private VarianceChecker varianceChecker;
    @NotNull
    private OverloadResolver overloadResolver;
    @NotNull
    private ModuleDescriptor moduleDescriptor;
    @NotNull
    private MutablePackageFragmentProvider packageFragmentProvider;
    @NotNull
    private BodyResolver bodyResolver;

    @Inject
    public void setDeclarationResolver(@NotNull DeclarationResolver declarationResolver) {
        if (declarationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationResolver", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "setDeclarationResolver"));
        }
        this.declarationResolver = declarationResolver;
    }

    @Inject
    public void setTypeHierarchyResolver(@NotNull TypeHierarchyResolver typeHierarchyResolver) {
        if (typeHierarchyResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeHierarchyResolver", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "setTypeHierarchyResolver"));
        }
        this.typeHierarchyResolver = typeHierarchyResolver;
    }

    @Inject
    public void setOverrideResolver(@NotNull OverrideResolver overrideResolver) {
        if (overrideResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overrideResolver", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "setOverrideResolver"));
        }
        this.overrideResolver = overrideResolver;
    }

    @Inject
    public void setVarianceChecker(@NotNull VarianceChecker varianceChecker) {
        if (varianceChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varianceChecker", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "setVarianceChecker"));
        }
        this.varianceChecker = varianceChecker;
    }

    @Inject
    public void setOverloadResolver(@NotNull OverloadResolver overloadResolver) {
        if (overloadResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overloadResolver", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "setOverloadResolver"));
        }
        this.overloadResolver = overloadResolver;
    }

    @Inject
    public void setModuleDescriptor(@NotNull ModuleDescriptor moduleDescriptor) {
        if (moduleDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDescriptor", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "setModuleDescriptor"));
        }
        this.moduleDescriptor = moduleDescriptor;
    }

    @Inject
    public void setPackageFragmentProvider(@NotNull MutablePackageFragmentProvider packageFragmentProvider) {
        if (packageFragmentProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFragmentProvider", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "setPackageFragmentProvider"));
        }
        this.packageFragmentProvider = packageFragmentProvider;
    }

    @Inject
    public void setBodyResolver(@NotNull BodyResolver bodyResolver) {
        if (bodyResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bodyResolver", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "setBodyResolver"));
        }
        this.bodyResolver = bodyResolver;
    }

    public void doProcess(@NotNull TopDownAnalysisContext c, @NotNull JetScope outerScope, @NotNull PackageLikeBuilder owner, @NotNull Collection<? extends PsiElement> declarations) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "doProcess"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "doProcess"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "doProcess"));
        }
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "doProcess"));
        }
        c.debug("Enter");
        this.typeHierarchyResolver.process(c, outerScope, owner, declarations);
        this.declarationResolver.process(c);
        this.overrideResolver.process(c);
        this.varianceChecker.process(c);
        this.lockScopes(c);
        this.overloadResolver.process(c);
        if (!c.getTopDownAnalysisParameters().isAnalyzingBootstrapLibrary()) {
            this.bodyResolver.resolveBodies(c);
        }
        c.debug("Exit");
        c.printDebugOutput(System.out);
    }

    private void lockScopes(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "lockScopes"));
        }
        for (ClassDescriptorWithResolutionScopes mutableClassDescriptor : c.getDeclaredClasses().values()) {
            ((MutableClassDescriptor)mutableClassDescriptor).lockScopes();
        }
        HashSet<FqName> scriptFqNames = Sets.newHashSet();
        for (JetFile file : c.getFileScopes().keySet()) {
            if (!file.isScript()) continue;
            scriptFqNames.add(file.getPackageFqName());
        }
        for (MutablePackageFragmentDescriptor fragment : this.packageFragmentProvider.getAllFragments()) {
            if (scriptFqNames.contains(fragment.getFqName())) continue;
            fragment.getMemberScope().changeLockLevel(WritableScope.LockLevel.READING);
        }
    }

    @NotNull
    public TopDownAnalysisContext analyzeFiles(@NotNull TopDownAnalysisParameters topDownAnalysisParameters, @NotNull Collection<JetFile> files, PackageFragmentProvider ... additionalProviders) {
        if (topDownAnalysisParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topDownAnalysisParameters", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "analyzeFiles"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "analyzeFiles"));
        }
        if (additionalProviders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalProviders", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "analyzeFiles"));
        }
        TopDownAnalysisContext topDownAnalysisContext = this.analyzeFiles(topDownAnalysisParameters, files, Arrays.asList(additionalProviders));
        if (topDownAnalysisContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "analyzeFiles"));
        }
        return topDownAnalysisContext;
    }

    @NotNull
    public TopDownAnalysisContext analyzeFiles(@NotNull TopDownAnalysisParameters topDownAnalysisParameters, @NotNull Collection<JetFile> files, @NotNull List<PackageFragmentProvider> additionalProviders) {
        if (topDownAnalysisParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topDownAnalysisParameters", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "analyzeFiles"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "analyzeFiles"));
        }
        if (additionalProviders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalProviders", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "analyzeFiles"));
        }
        assert (!topDownAnalysisParameters.isLazy()) : "Lazy resolve must be disabled for this method";
        TopDownAnalysisContext c = new TopDownAnalysisContext(topDownAnalysisParameters);
        CompositePackageFragmentProvider provider = new CompositePackageFragmentProvider(KotlinPackage.plus(Arrays.asList(this.packageFragmentProvider), additionalProviders));
        ((ModuleDescriptorImpl)this.moduleDescriptor).initialize(provider);
        this.doProcess(c, JetModuleUtil.getSubpackagesOfRootScope(this.moduleDescriptor), new PackageLikeBuilderDummy(), files);
        TopDownAnalysisContext topDownAnalysisContext = c;
        if (topDownAnalysisContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "analyzeFiles"));
        }
        return topDownAnalysisContext;
    }

    @NotNull
    public MutablePackageFragmentProvider getPackageFragmentProvider() {
        MutablePackageFragmentProvider mutablePackageFragmentProvider = this.packageFragmentProvider;
        if (mutablePackageFragmentProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "getPackageFragmentProvider"));
        }
        return mutablePackageFragmentProvider;
    }
}

