/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.types.CastDiagnosticsUtil;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeReconstructionResult;
import org.jetbrains.jet.lang.types.TypeUtils;

public class PossiblyBareType {
    private final JetType actualType;
    private final TypeConstructor bareTypeConstructor;
    private final boolean nullable;

    @NotNull
    public static PossiblyBareType bare(@NotNull TypeConstructor bareTypeConstructor, boolean nullable2) {
        if (bareTypeConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bareTypeConstructor", "org/jetbrains/jet/lang/resolve/PossiblyBareType", "bare"));
        }
        PossiblyBareType possiblyBareType = new PossiblyBareType(null, bareTypeConstructor, nullable2);
        if (possiblyBareType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/PossiblyBareType", "bare"));
        }
        return possiblyBareType;
    }

    @NotNull
    public static PossiblyBareType type(@NotNull JetType actualType) {
        if (actualType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actualType", "org/jetbrains/jet/lang/resolve/PossiblyBareType", "type"));
        }
        PossiblyBareType possiblyBareType = new PossiblyBareType(actualType, null, false);
        if (possiblyBareType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/PossiblyBareType", "type"));
        }
        return possiblyBareType;
    }

    private PossiblyBareType(@Nullable JetType actualType, @Nullable TypeConstructor bareTypeConstructor, boolean nullable2) {
        this.actualType = actualType;
        this.bareTypeConstructor = bareTypeConstructor;
        this.nullable = nullable2;
    }

    public boolean isBare() {
        return this.actualType == null;
    }

    @NotNull
    public JetType getActualType() {
        JetType jetType = this.actualType;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/PossiblyBareType", "getActualType"));
        }
        return jetType;
    }

    @NotNull
    public TypeConstructor getBareTypeConstructor() {
        TypeConstructor typeConstructor2 = this.bareTypeConstructor;
        if (typeConstructor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/PossiblyBareType", "getBareTypeConstructor"));
        }
        return typeConstructor2;
    }

    private boolean isBareTypeNullable() {
        return this.nullable;
    }

    public boolean isNullable() {
        if (this.isBare()) {
            return this.isBareTypeNullable();
        }
        return this.getActualType().isMarkedNullable();
    }

    public PossiblyBareType makeNullable() {
        if (this.isBare()) {
            return this.isBareTypeNullable() ? this : PossiblyBareType.bare(this.getBareTypeConstructor(), true);
        }
        return PossiblyBareType.type(TypeUtils.makeNullable(this.getActualType()));
    }

    @NotNull
    public TypeReconstructionResult reconstruct(@NotNull JetType subjectType) {
        if (subjectType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subjectType", "org/jetbrains/jet/lang/resolve/PossiblyBareType", "reconstruct"));
        }
        if (!this.isBare()) {
            TypeReconstructionResult typeReconstructionResult = new TypeReconstructionResult(this.getActualType(), true);
            if (typeReconstructionResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/PossiblyBareType", "reconstruct"));
            }
            return typeReconstructionResult;
        }
        TypeReconstructionResult reconstructionResult = CastDiagnosticsUtil.findStaticallyKnownSubtype(TypeUtils.makeNotNullable(subjectType), this.getBareTypeConstructor());
        JetType type2 = reconstructionResult.getResultingType();
        if (type2 == null) {
            TypeReconstructionResult typeReconstructionResult = reconstructionResult;
            if (typeReconstructionResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/PossiblyBareType", "reconstruct"));
            }
            return typeReconstructionResult;
        }
        JetType resultingType = TypeUtils.makeNullableAsSpecified(type2, this.isBareTypeNullable());
        TypeReconstructionResult typeReconstructionResult = new TypeReconstructionResult(resultingType, reconstructionResult.isAllArgumentsInferred());
        if (typeReconstructionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/PossiblyBareType", "reconstruct"));
        }
        return typeReconstructionResult;
    }

    public String toString() {
        return this.isBare() ? "bare " + this.bareTypeConstructor + (this.isBareTypeNullable() ? "?" : "") : this.getActualType().toString();
    }
}

