/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.impl;

import jet.runtime.typeinfo.JetValueParameter;
import kotlin.Function1;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.platform.platformStatic;
import kotlin.reflect.jvm.internal.InternalPackage;
import kotlin.reflect.jvm.internal.KClassImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.stubs.impl.ModifierMaskUtils$computeMaskFromModifierList$1;
import org.jetbrains.jet.lexer.JetModifierKeywordToken;
import org.jetbrains.jet.lexer.JetTokens;

@KotlinClass(abiVersion=19, data={"E\u0006)\tRj\u001c3jM&,'/T1tWV#\u0018\u000e\\:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*\u0019!.\u001a;\u000b\t1\fgn\u001a\u0006\u0004aNL'\"B:uk\n\u001c(\u0002B5na2T1!\u00118z\u0015\u0019Yw\u000e\u001e7j]*Y1m\\7qkR,W*Y:l\u0015-A\u0017m]'pI&4\u0017.\u001a:\u000b\u0013\u0019+hn\u0019;j_:\f$b\u0006&fi6{G-\u001b4jKJ\\U-_<pe\u0012$vn[3o\u0015\u0015aW\r_3s\u0015\u001d\u0011un\u001c7fC:T1!\u00138u\u0015m\u0019w.\u001c9vi\u0016l\u0015m]6Ge>lWj\u001c3jM&,'\u000fT5ti*aQn\u001c3jM&,'\u000fT5ti*y!*\u001a;N_\u0012Lg-[3s\u0019&\u001cHOC\bnCN\\\u0007*Y:N_\u0012Lg-[3s\u0015\u0011i\u0017m]6\u000b\u001b5|G-\u001b4jKJ$vn[3o\u00151i\u0017m]6U_N#(/\u001b8h\u0015\u0019\u0019FO]5oO*!!.\u0019<b\u0015\u0011b4\r\\1tg6z'M[3di62wN]\u0017N_\u0012Lg-[3s\u001b\u0006\u001c8.\u0016;jYNtD4\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\t!\u0019\u0001#\u0002\u0006\u0005\u0011\u0011\u0001bA\u0003\u0003\t\u000bA9!B\u0002\u0005\u0007!\u0001A\u0002A\u0003\u0002\u0011\u0013)1\u0001\u0002\u0003\t\t1\u0001Qa\u0001\u0003\u0005\u0011\u0019a\u0001!\u0002\u0002\u0005\u0003!9Qa\u0001C\u0006\u0011\u001ba\u0001!B\u0002\u0005\t!=A\u0002A\u0003\u0004\t\u0011A\u0001\u0002\u0004\u0001\u0006\u0005\u0011!\u0001BB\u0003\u0004\t\tA\u0019\u0002\u0004\u0001\u0006\u0005\u0011\u0011\u00012C\u0003\u0003\t\u0017Ai!B\u0002\u0005\t!aA\u0002A\u0003\u0002\u00113)!\u0001\u0002\u0006\t\u0005\u0015\u0011AQ\u0003\u0005\r\u000b\r!9\u0001C\u0007\r\u0001\u0011\u0019\u0017\u0001d\u0002\u0012\u0010\u00155Aaq\u0001\r\u0018e\u0011Q!\u0001E\u0004k\u0001I\"!B\u0001\t\n5ZBq\u0001\r\u0006;;!\u0001\u0001c\u0003\u000e\u0015\u0015\t\u0001\"B\u0005\u0004\u0013\t)\u0011\u0001\u0003\u0004\n\u0007%\u0011Q!\u0001E\u0007!\u000e\u0001\u0011EA\u0003\u0002\u0011\u001d\t6!\u0002\u0003\u0006\u0013\u0005!)!D\u0001\t\u00105\u001aBq\u0001M\t;\u001b!\u0001\u0001C\u0005\u000e\u0005\u0015\t\u0001\u0002\u0003)\u0004\u0001\u0005\u0012Q!\u0001\u0005\b#\u000e)A\u0011C\u0005\u0002\t\u000bi\u0011\u0001#\u0005.:\u0011\u001d\u0001DCO\u0007\t\u0001A)\"\u0004\u0002\u0006\u0003!9\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001bC\u0007\u0003\u000b\u0005Aa\u0001UB\u0001C\t)\u0011\u0001#\u0004R\u0007\u001d!!\"C\u0001\u0005\u00025\tAQA\u0007\u0002\u0011%i3\u0003b\u0002\u0019\u0018u5A\u0001\u0001E\u000b\u001b\t)\u0011\u0001C\u0004Q\u0007\u0001\t#!B\u0001\t\u0014E\u001bQ\u0001b\u0006\n\u0003!YQ\"\u0001C\u0003k\u0001\u0001"})
public final class ModifierMaskUtils
implements KObject {
    public static final /* synthetic */ KClassImpl $kotlinClass;
    public static final ModifierMaskUtils INSTANCE$;

    static {
        $kotlinClass = InternalPackage.kClassFromKotlin(ModifierMaskUtils.class);
        new ModifierMaskUtils();
    }

    @platformStatic
    public static final int computeMaskFromModifierList(@JetValueParameter(name="modifierList") @NotNull JetModifierList modifierList) {
        if (modifierList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierList", "org/jetbrains/jet/lang/psi/stubs/impl/ModifierMaskUtils", "computeMaskFromModifierList"));
        }
        Intrinsics.checkParameterIsNotNull(modifierList, "modifierList");
        return ModifierMaskUtils.computeMask(new ModifierMaskUtils$computeMaskFromModifierList$1(modifierList));
    }

    @platformStatic
    public static final int computeMask(@JetValueParameter(name="hasModifier") @NotNull Function1<? super JetModifierKeywordToken, ? extends Boolean> hasModifier) {
        if (hasModifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hasModifier", "org/jetbrains/jet/lang/psi/stubs/impl/ModifierMaskUtils", "computeMask"));
        }
        Intrinsics.checkParameterIsNotNull(hasModifier, "hasModifier");
        int mask = 0;
        for (Pair<Integer, Object> pair : KotlinPackage.withIndices((Object[])JetTokens.MODIFIER_KEYWORDS_ARRAY)) {
            JetModifierKeywordToken modifierKeywordToken;
            int index2 = ((Number)pair.component1()).intValue();
            JetModifierKeywordToken jetModifierKeywordToken = modifierKeywordToken = (JetModifierKeywordToken)pair.component2();
            Intrinsics.checkExpressionValueIsNotNull(jetModifierKeywordToken, "modifierKeywordToken");
            if (!hasModifier.invoke(jetModifierKeywordToken).booleanValue()) continue;
            mask |= 1 << index2;
        }
        return mask;
    }

    @platformStatic
    public static final boolean maskHasModifier(@JetValueParameter(name="mask") int mask, @JetValueParameter(name="modifierToken") @NotNull JetModifierKeywordToken modifierToken) {
        if (modifierToken == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierToken", "org/jetbrains/jet/lang/psi/stubs/impl/ModifierMaskUtils", "maskHasModifier"));
        }
        Intrinsics.checkParameterIsNotNull(modifierToken, "modifierToken");
        int index2 = KotlinPackage.indexOf((Object[])JetTokens.MODIFIER_KEYWORDS_ARRAY, modifierToken);
        KotlinPackage.assert(index2 >= 0, "All JetModifierKeywordTokens should be present in MODIFIER_KEYWORDS_ARRAY");
        return (mask & 1 << index2) != 0;
    }

    @platformStatic
    @NotNull
    public static final String maskToString(@JetValueParameter(name="mask") int mask) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int first = 1;
        JetModifierKeywordToken[] jetModifierKeywordTokenArray = JetTokens.MODIFIER_KEYWORDS_ARRAY;
        for (int i = 0; i < jetModifierKeywordTokenArray.length; ++i) {
            JetModifierKeywordToken modifierKeyword;
            JetModifierKeywordToken jetModifierKeywordToken = modifierKeyword = jetModifierKeywordTokenArray[i];
            Intrinsics.checkExpressionValueIsNotNull(jetModifierKeywordToken, "modifierKeyword");
            if (!ModifierMaskUtils.maskHasModifier(mask, jetModifierKeywordToken)) continue;
            if (first == 0) {
                sb.append(" ");
            }
            sb.append(modifierKeyword.getValue());
            first = 0;
        }
        sb.append("]");
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/stubs/impl/ModifierMaskUtils", "maskToString"));
        }
        return string;
    }

    ModifierMaskUtils() {
        INSTANCE$ = this;
        KotlinPackage.assert(KotlinPackage.getSize(JetTokens.MODIFIER_KEYWORDS_ARRAY) <= 32, "Current implementation depends on the ability to represent modifier list as bit mask");
    }
}

