/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.stubs.KotlinModifierListStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetModifierListElementType;
import org.jetbrains.jet.lang.psi.stubs.impl.KotlinStubBaseImpl;
import org.jetbrains.jet.lang.psi.stubs.impl.ModifierMaskUtils;
import org.jetbrains.jet.lexer.JetModifierKeywordToken;

public class KotlinModifierListStubImpl
extends KotlinStubBaseImpl<JetModifierList>
implements KotlinModifierListStub {
    private final int mask;

    public KotlinModifierListStubImpl(StubElement parent, int mask, @NotNull JetModifierListElementType<?> elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/jet/lang/psi/stubs/impl/KotlinModifierListStubImpl", "<init>"));
        }
        super((StubElement<? extends PsiElement>)parent, elementType);
        this.mask = mask;
    }

    public int getMask() {
        return this.mask;
    }

    @Override
    public boolean hasModifier(@NotNull JetModifierKeywordToken modifierToken) {
        if (modifierToken == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierToken", "org/jetbrains/jet/lang/psi/stubs/impl/KotlinModifierListStubImpl", "hasModifier"));
        }
        return ModifierMaskUtils.maskHasModifier(this.mask, modifierToken);
    }

    @Override
    @NotNull
    public String toString() {
        String string = super.toString() + ModifierMaskUtils.maskToString(this.mask);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/stubs/impl/KotlinModifierListStubImpl", "toString"));
        }
        return string;
    }
}

