/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetExpressionImpl;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.KotlinStringLiteralTextEscaper;
import org.jetbrains.jet.lexer.JetTokens;

public class JetStringTemplateExpression
extends JetExpressionImpl
implements PsiLanguageInjectionHost {
    private static final TokenSet TOKENS_SUITABLE_FOR_INJECTION = TokenSet.create(JetNodeTypes.LITERAL_STRING_TEMPLATE_ENTRY, JetNodeTypes.ESCAPE_STRING_TEMPLATE_ENTRY);

    public JetStringTemplateExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetStringTemplateExpression", "<init>"));
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetStringTemplateExpression", "accept"));
        }
        return visitor.visitStringTemplateExpression(this, data2);
    }

    @NotNull
    public JetStringTemplateEntry[] getEntries() {
        JetStringTemplateEntry[] jetStringTemplateEntryArray = this.findChildrenByClass(JetStringTemplateEntry.class);
        if (jetStringTemplateEntryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetStringTemplateExpression", "getEntries"));
        }
        return jetStringTemplateEntryArray;
    }

    @Override
    public boolean isValidHost() {
        ASTNode node = this.getNode();
        for (ASTNode child = node.getFirstChildNode().getTreeNext(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == JetTokens.CLOSING_QUOTE) {
                return true;
            }
            if (TOKENS_SUITABLE_FOR_INJECTION.contains(child.getElementType())) continue;
            return false;
        }
        return false;
    }

    @Override
    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/jet/lang/psi/JetStringTemplateExpression", "updateText"));
        }
        return ElementManipulators.handleContentChange(this, text);
    }

    @Override
    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        KotlinStringLiteralTextEscaper kotlinStringLiteralTextEscaper = new KotlinStringLiteralTextEscaper(this);
        if (kotlinStringLiteralTextEscaper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetStringTemplateExpression", "createLiteralTextEscaper"));
        }
        return kotlinStringLiteralTextEscaper;
    }
}

