/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.kdoc.psi.api.KDoc;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetModifierListOwnerStub;
import org.jetbrains.jet.lang.psi.KotlinDeclarationNavigationPolicy;
import org.jetbrains.jet.lang.psi.findDocComment.FindDocCommentPackage;
import org.jetbrains.jet.lang.psi.stubs.KotlinClassOrObjectStub;

abstract class JetDeclarationStub<T extends StubElement>
extends JetModifierListOwnerStub<T>
implements JetDeclaration {
    public JetDeclarationStub(@NotNull T stub, @NotNull IStubElementType nodeType) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/JetDeclarationStub", "<init>"));
        }
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeType", "org/jetbrains/jet/lang/psi/JetDeclarationStub", "<init>"));
        }
        super(stub, nodeType);
    }

    public JetDeclarationStub(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetDeclarationStub", "<init>"));
        }
        super(node);
    }

    @Override
    @Nullable
    public KDoc getDocComment() {
        return FindDocCommentPackage.findDocComment(this);
    }

    @Override
    public PsiElement getParent() {
        Object stub = this.getStub();
        if (!(stub == null || stub instanceof KotlinClassOrObjectStub && ((KotlinClassOrObjectStub)stub).isLocal())) {
            return stub.getParentStub().getPsi();
        }
        return super.getParent();
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        JetElement navigationElement;
        KotlinDeclarationNavigationPolicy navigationPolicy = ServiceManager.getService(KotlinDeclarationNavigationPolicy.class);
        if (navigationPolicy != null && (navigationElement = navigationPolicy.getNavigationElement(this)) != null) {
            JetElement jetElement = navigationElement;
            if (jetElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetDeclarationStub", "getNavigationElement"));
            }
            return jetElement;
        }
        JetDeclarationStub jetDeclarationStub = this;
        if (jetDeclarationStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetDeclarationStub", "getNavigationElement"));
        }
        return jetDeclarationStub;
    }
}

