/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics.rendering;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactory;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.diagnostics.rendering.DiagnosticFactoryToRendererMap;
import org.jetbrains.jet.lang.diagnostics.rendering.DiagnosticRenderer;
import org.jetbrains.jet.lang.diagnostics.rendering.DispatchingDiagnosticRenderer;
import org.jetbrains.jet.lang.diagnostics.rendering.Renderers;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeConstraint;
import org.jetbrains.jet.lang.resolve.varianceChecker.VarianceChecker;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lexer.JetModifierKeywordToken;
import org.jetbrains.jet.renderer.DescriptorRenderer;
import org.jetbrains.jet.renderer.MultiRenderer;
import org.jetbrains.jet.renderer.Renderer;

public class DefaultErrorMessages {
    private static final DiagnosticFactoryToRendererMap MAP = new DiagnosticFactoryToRendererMap();
    private static List<DiagnosticFactoryToRendererMap> maps = null;
    private static Application application = ApplicationManager.getApplication();
    private static DispatchingDiagnosticRenderer renderer = null;

    @NotNull
    public static String render(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/jet/lang/diagnostics/rendering/DefaultErrorMessages", "render"));
        }
        String string = DefaultErrorMessages.getRenderer().render(diagnostic);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/DefaultErrorMessages", "render"));
        }
        return string;
    }

    @NotNull
    private static DiagnosticRenderer<Diagnostic> getRenderer() {
        boolean mapsChanged = DefaultErrorMessages.resetMapsIfNeeded();
        if (renderer == null || mapsChanged) {
            renderer = new DispatchingDiagnosticRenderer(maps);
        }
        DispatchingDiagnosticRenderer dispatchingDiagnosticRenderer = renderer;
        if (dispatchingDiagnosticRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/DefaultErrorMessages", "getRenderer"));
        }
        return dispatchingDiagnosticRenderer;
    }

    private static boolean resetMapsIfNeeded() {
        boolean needToResetMaps = maps == null;
        Application newApp = ApplicationManager.getApplication();
        if (application != newApp) {
            assert (newApp.isUnitTestMode()) : "Expected application switch only in tests";
            application = newApp;
            needToResetMaps = true;
        }
        if (!needToResetMaps) {
            return false;
        }
        maps = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(KotlinPackage.map(Extensions.getExtensions(Extension.EP_NAME), new Function1<Extension, DiagnosticFactoryToRendererMap>(){

            @Override
            public DiagnosticFactoryToRendererMap invoke(Extension extension) {
                return extension.getMap();
            }
        }))).add(MAP)).build();
        return true;
    }

    @Nullable
    public static DiagnosticRenderer getRendererForDiagnostic(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/jet/lang/diagnostics/rendering/DefaultErrorMessages", "getRendererForDiagnostic"));
        }
        for (DiagnosticFactoryToRendererMap map : maps) {
            DiagnosticRenderer<?> renderer = map.get(diagnostic.getFactory());
            if (renderer == null) continue;
            return renderer;
        }
        return null;
    }

    private DefaultErrorMessages() {
    }

    static {
        MAP.put(Errors.UNRESOLVED_REFERENCE, "Unresolved reference: {0}", Renderers.ELEMENT_TEXT);
        MAP.put(Errors.INVISIBLE_REFERENCE, "Cannot access ''{0}'': it is ''{1}'' in ''{2}''", Renderers.NAME, Renderers.TO_STRING, Renderers.NAME);
        MAP.put(Errors.INVISIBLE_MEMBER, "Cannot access ''{0}'': it is ''{1}'' in ''{2}''", Renderers.NAME, Renderers.TO_STRING, Renderers.NAME);
        MAP.put(Errors.REDECLARATION, "Redeclaration: {0}", Renderers.STRING);
        MAP.put(Errors.NAME_SHADOWING, "Name shadowed: {0}", Renderers.STRING);
        MAP.put(Errors.TYPE_MISMATCH, "Type mismatch: inferred type is {1} but {0} was expected", Renderers.RENDER_TYPE, Renderers.RENDER_TYPE);
        MAP.put(Errors.INCOMPATIBLE_MODIFIERS, "Incompatible modifiers: ''{0}''", new Renderer<Collection<JetModifierKeywordToken>>(){

            @Override
            @NotNull
            public String render(@NotNull Collection<JetModifierKeywordToken> tokens) {
                if (tokens == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokens", "org/jetbrains/jet/lang/diagnostics/rendering/DefaultErrorMessages$2", "render"));
                }
                StringBuilder sb = new StringBuilder();
                for (JetModifierKeywordToken token : tokens) {
                    if (sb.length() != 0) {
                        sb.append(" ");
                    }
                    sb.append(token.getValue());
                }
                String string = sb.toString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/DefaultErrorMessages$2", "render"));
                }
                return string;
            }
        });
        MAP.put(Errors.ILLEGAL_MODIFIER, "Illegal modifier ''{0}''", Renderers.TO_STRING);
        MAP.put(Errors.INAPPLICABLE_ANNOTATION, "This annotation is not applicable to class members");
        MAP.put(Errors.REDUNDANT_MODIFIER, "Modifier ''{0}'' is redundant because ''{1}'' is present", Renderers.TO_STRING, Renderers.TO_STRING);
        MAP.put(Errors.ABSTRACT_MODIFIER_IN_TRAIT, "Modifier ''abstract'' is redundant in trait");
        MAP.put(Errors.OPEN_MODIFIER_IN_TRAIT, "Modifier ''open'' is redundant in trait");
        MAP.put(Errors.OPEN_MODIFIER_IN_ENUM, "Modifier ''open'' is not applicable for enum class");
        MAP.put(Errors.ABSTRACT_MODIFIER_IN_ENUM, "Modifier ''abstract'' is not applicable for enum class");
        MAP.put(Errors.ILLEGAL_ENUM_ANNOTATION, "Annotation ''enum'' is only applicable for class");
        MAP.put(Errors.REDUNDANT_MODIFIER_IN_GETTER, "Visibility modifiers are redundant in getter");
        MAP.put(Errors.TRAIT_CAN_NOT_BE_FINAL, "Trait cannot be final");
        MAP.put(Errors.TYPE_PARAMETERS_IN_ENUM, "Enum class cannot have type parameters");
        MAP.put(Errors.TYPECHECKER_HAS_RUN_INTO_RECURSIVE_PROBLEM, "Type checking has run into a recursive problem. Easiest workaround: specify types of your declarations explicitly");
        MAP.put(Errors.RETURN_NOT_ALLOWED, "'return' is not allowed here");
        MAP.put(Errors.RETURN_NOT_ALLOWED_EXPLICIT_RETURN_TYPE_REQUIRED, "'return' is only allowed in function literals that have return types specified explicitly");
        MAP.put(Errors.PROJECTION_IN_IMMEDIATE_ARGUMENT_TO_SUPERTYPE, "Projections are not allowed for immediate arguments of a supertype");
        MAP.put(Errors.LABEL_NAME_CLASH, "There is more than one label with such a name in this scope");
        MAP.put(Errors.EXPRESSION_EXPECTED_PACKAGE_FOUND, "Expression expected, but a package name found");
        MAP.put(Errors.CANNOT_IMPORT_FROM_ELEMENT, "Cannot import from ''{0}''", Renderers.NAME);
        MAP.put(Errors.CANNOT_BE_IMPORTED, "Cannot import ''{0}'', functions and properties can be imported only from packages", Renderers.NAME);
        MAP.put(Errors.USELESS_HIDDEN_IMPORT, "Useless import, it is hidden further");
        MAP.put(Errors.USELESS_SIMPLE_IMPORT, "Useless import, does nothing");
        MAP.put(Errors.PLATFORM_CLASS_MAPPED_TO_KOTLIN, "This class shouldn''t be used in Kotlin. Use {0} instead.", Renderers.CLASSES_OR_SEPARATED);
        MAP.put(Errors.CANNOT_INFER_PARAMETER_TYPE, "Cannot infer a type for this parameter. To specify it explicitly use the {(p : Type) -> ...} notation");
        MAP.put(Errors.NO_BACKING_FIELD_ABSTRACT_PROPERTY, "This property doesn't have a backing field, because it's abstract");
        MAP.put(Errors.NO_BACKING_FIELD_CUSTOM_ACCESSORS, "This property doesn't have a backing field, because it has custom accessors without reference to the backing field");
        MAP.put(Errors.INACCESSIBLE_BACKING_FIELD, "The backing field is not accessible here");
        MAP.put(Errors.NOT_PROPERTY_BACKING_FIELD, "The referenced variable is not a property and doesn't have backing field");
        MAP.put(Errors.MIXING_NAMED_AND_POSITIONED_ARGUMENTS, "Mixing named and positioned arguments is not allowed");
        MAP.put(Errors.ARGUMENT_PASSED_TWICE, "An argument is already passed for this parameter");
        MAP.put(Errors.NAMED_PARAMETER_NOT_FOUND, "Cannot find a parameter with this name: {0}", Renderers.ELEMENT_TEXT);
        MAP.put(Errors.NAMED_ARGUMENTS_NOT_ALLOWED, "Named arguments are not allowed for non-Kotlin functions");
        MAP.put(Errors.VARARG_OUTSIDE_PARENTHESES, "Passing value as a vararg is only allowed inside a parenthesized argument list");
        MAP.put(Errors.NON_VARARG_SPREAD, "The spread operator (*foo) may only be applied in a vararg position");
        MAP.put(Errors.MANY_FUNCTION_LITERAL_ARGUMENTS, "Only one function literal is allowed outside a parenthesized argument list");
        MAP.put(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER, "This property must either have a type annotation, be initialized or be delegated");
        MAP.put(Errors.VARIABLE_WITH_NO_TYPE_NO_INITIALIZER, "This variable must either have a type annotation or be initialized");
        MAP.put(Errors.INITIALIZER_REQUIRED_FOR_MULTIDECLARATION, "Initializer required for multi-declaration");
        MAP.put(Errors.COMPONENT_FUNCTION_MISSING, "Multi-declaration initializer of type {1} must have a ''{0}()'' function", Renderers.TO_STRING, Renderers.RENDER_TYPE);
        MAP.put(Errors.COMPONENT_FUNCTION_AMBIGUITY, "Function ''{0}()'' is ambiguous for this expression: {1}", Renderers.TO_STRING, Renderers.AMBIGUOUS_CALLS);
        MAP.put(Errors.COMPONENT_FUNCTION_RETURN_TYPE_MISMATCH, "''{0}()'' function returns ''{1}'', but ''{2}'' is expected", Renderers.TO_STRING, Renderers.RENDER_TYPE, Renderers.RENDER_TYPE);
        MAP.put(Errors.ABSTRACT_PROPERTY_IN_PRIMARY_CONSTRUCTOR_PARAMETERS, "This property cannot be declared abstract");
        MAP.put(Errors.ABSTRACT_PROPERTY_WITH_INITIALIZER, "Property with initializer cannot be abstract");
        MAP.put(Errors.ABSTRACT_PROPERTY_WITH_GETTER, "Property with getter implementation cannot be abstract");
        MAP.put(Errors.ABSTRACT_PROPERTY_WITH_SETTER, "Property with setter implementation cannot be abstract");
        MAP.put(Errors.ABSTRACT_DELEGATED_PROPERTY, "Delegated property cannot be abstract");
        MAP.put(Errors.ACCESSOR_FOR_DELEGATED_PROPERTY, "Delegated property cannot have accessor");
        MAP.put(Errors.DELEGATED_PROPERTY_IN_TRAIT, "Delegated properties are not allowed in traits");
        MAP.put(Errors.LOCAL_VARIABLE_WITH_DELEGATE, "Local variables are not allowed to have delegates");
        MAP.put(Errors.PACKAGE_MEMBER_CANNOT_BE_PROTECTED, "Package member cannot be protected");
        MAP.put(Errors.GETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY, "Getter visibility must be the same as property visibility");
        MAP.put(Errors.BACKING_FIELD_IN_TRAIT, "Property in a trait cannot have a backing field");
        MAP.put(Errors.MUST_BE_INITIALIZED, "Property must be initialized");
        MAP.put(Errors.MUST_BE_INITIALIZED_OR_BE_ABSTRACT, "Property must be initialized or be abstract");
        MAP.put(Errors.PROPERTY_INITIALIZER_IN_TRAIT, "Property initializers are not allowed in traits");
        MAP.put(Errors.FINAL_PROPERTY_IN_TRAIT, "Abstract property in trait cannot be final");
        MAP.put(Errors.EXTENSION_PROPERTY_WITH_BACKING_FIELD, "Extension property cannot be initialized because it has no backing field");
        MAP.put(Errors.PROPERTY_INITIALIZER_NO_BACKING_FIELD, "Initializer is not allowed here because this property has no backing field");
        MAP.put(Errors.ABSTRACT_PROPERTY_IN_NON_ABSTRACT_CLASS, "Abstract property ''{0}'' in non-abstract class ''{1}''", Renderers.STRING, Renderers.NAME);
        MAP.put(Errors.ABSTRACT_FUNCTION_IN_NON_ABSTRACT_CLASS, "Abstract function ''{0}'' in non-abstract class ''{1}''", Renderers.STRING, Renderers.NAME);
        MAP.put(Errors.ABSTRACT_FUNCTION_WITH_BODY, "A function ''{0}'' with body cannot be abstract", Renderers.NAME);
        MAP.put(Errors.NON_ABSTRACT_FUNCTION_WITH_NO_BODY, "Function ''{0}'' without a body must be abstract", Renderers.NAME);
        MAP.put(Errors.FINAL_FUNCTION_WITH_NO_BODY, "Function ''{0}'' without body cannot be final", Renderers.NAME);
        MAP.put(Errors.NON_MEMBER_FUNCTION_NO_BODY, "Function ''{0}'' must have a body", Renderers.NAME);
        MAP.put(Errors.NON_FINAL_MEMBER_IN_FINAL_CLASS, "\"open\" has no effect in a final class");
        MAP.put(Errors.PUBLIC_MEMBER_SHOULD_SPECIFY_TYPE, "Public or protected member should have specified type");
        MAP.put(Errors.PROJECTION_ON_NON_CLASS_TYPE_ARGUMENT, "Projections are not allowed on type arguments of functions and properties");
        MAP.put(Errors.SUPERTYPE_NOT_INITIALIZED, "This type has a constructor, and thus must be initialized here");
        MAP.put(Errors.NOTHING_TO_OVERRIDE, "''{0}'' overrides nothing", Renderers.NAME);
        MAP.put(Errors.VIRTUAL_MEMBER_HIDDEN, "''{0}'' hides member of supertype ''{2}'' and needs ''override'' modifier", Renderers.NAME, Renderers.NAME, Renderers.NAME);
        MAP.put(Errors.DATA_CLASS_OVERRIDE_CONFLICT, "Function ''{0}'' generated for the data class conflicts with member of supertype ''{1}''", Renderers.NAME, Renderers.NAME);
        MAP.put(Errors.CANNOT_OVERRIDE_INVISIBLE_MEMBER, "''{0}'' has no access to ''{1}'', so it cannot override it", DescriptorRenderer.FQ_NAMES_IN_TYPES, DescriptorRenderer.FQ_NAMES_IN_TYPES);
        MAP.put(Errors.CANNOT_INFER_VISIBILITY, "Cannot infer visibility for ''{0}''. Please specify it explicitly", DescriptorRenderer.COMPACT);
        MAP.put(Errors.ENUM_ENTRY_SHOULD_BE_INITIALIZED, "Missing delegation specifier ''{0}''", Renderers.NAME);
        MAP.put(Errors.ENUM_ENTRY_ILLEGAL_TYPE, "The type constructor of enum entry should be ''{0}''", Renderers.NAME);
        MAP.put(Errors.UNINITIALIZED_VARIABLE, "Variable ''{0}'' must be initialized", Renderers.NAME);
        MAP.put(Errors.UNINITIALIZED_PARAMETER, "Parameter ''{0}'' is uninitialized here", Renderers.NAME);
        MAP.put(Errors.UNUSED_VARIABLE, "Variable ''{0}'' is never used", Renderers.NAME);
        MAP.put(Errors.UNUSED_PARAMETER, "Parameter ''{0}'' is never used", Renderers.NAME);
        MAP.put(Errors.ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE, "Variable ''{0}'' is assigned but never accessed", Renderers.NAME);
        MAP.put(Errors.VARIABLE_WITH_REDUNDANT_INITIALIZER, "Variable ''{0}'' initializer is redundant", Renderers.NAME);
        MAP.put(Errors.UNUSED_VALUE, "The value ''{0}'' assigned to ''{1}'' is never used", Renderers.ELEMENT_TEXT, DescriptorRenderer.FQ_NAMES_IN_TYPES);
        MAP.put(Errors.UNUSED_CHANGED_VALUE, "The value changed at ''{0}'' is never used", Renderers.ELEMENT_TEXT);
        MAP.put(Errors.UNUSED_EXPRESSION, "The expression is unused");
        MAP.put(Errors.UNUSED_FUNCTION_LITERAL, "The function literal is unused. If you mean block, you can use 'run { ... }'");
        MAP.put(Errors.VAL_REASSIGNMENT, "Val cannot be reassigned", Renderers.NAME);
        MAP.put(Errors.SETTER_PROJECTED_OUT, "Setter for ''{0}'' is removed by type projection", Renderers.NAME);
        MAP.put(Errors.INVISIBLE_SETTER, "Cannot assign to ''{0}'': the setter is ''{1}'' in ''{2}''", Renderers.NAME, Renderers.TO_STRING, Renderers.NAME);
        MAP.put(Errors.INITIALIZATION_BEFORE_DECLARATION, "Variable cannot be initialized before declaration", Renderers.NAME);
        MAP.put(Errors.VARIABLE_EXPECTED, "Variable expected");
        MAP.put(Errors.VAL_OR_VAR_ON_LOOP_PARAMETER, "''{0}'' on loop parameter is not allowed", Renderers.TO_STRING);
        MAP.put(Errors.VAL_OR_VAR_ON_FUN_PARAMETER, "''{0}'' on function parameter is not allowed", Renderers.TO_STRING);
        MAP.put(Errors.VAL_OR_VAR_ON_CATCH_PARAMETER, "''{0}'' on catch parameter is not allowed", Renderers.TO_STRING);
        MAP.put(Errors.INITIALIZATION_USING_BACKING_FIELD_CUSTOM_SETTER, "This property has a custom setter, so initialization using backing field required", Renderers.NAME);
        MAP.put(Errors.INITIALIZATION_USING_BACKING_FIELD_OPEN_SETTER, "Setter of this property can be overridden, so initialization using backing field required", Renderers.NAME);
        MAP.put(Errors.UNREACHABLE_CODE, "Unreachable code", Renderers.TO_STRING);
        MAP.put(Errors.MANY_CLASS_OBJECTS, "Only one class object is allowed per class");
        MAP.put(Errors.CLASS_OBJECT_NOT_ALLOWED, "A class object is not allowed here");
        MAP.put(Errors.LOCAL_OBJECT_NOT_ALLOWED, "Named object ''{0}'' is a singleton and cannot be local. Try to use anonymous object instead", Renderers.NAME);
        MAP.put(Errors.LOCAL_ENUM_NOT_ALLOWED, "Enum class ''{0}'' cannot be local", Renderers.NAME);
        MAP.put(Errors.DELEGATION_IN_TRAIT, "Traits cannot use delegation");
        MAP.put(Errors.DELEGATION_NOT_TO_TRAIT, "Only traits can be delegated to");
        MAP.put(Errors.UNMET_TRAIT_REQUIREMENT, "Super trait ''{0}'' requires subclasses to extend ''{1}''", Renderers.NAME, Renderers.NAME);
        MAP.put(Errors.NO_CONSTRUCTOR, "This class does not have a constructor");
        MAP.put(Errors.NOT_A_CLASS, "Not a class");
        MAP.put(Errors.ILLEGAL_ESCAPE_SEQUENCE, "Illegal escape sequence");
        MAP.put(Errors.LOCAL_EXTENSION_PROPERTY, "Local extension properties are not allowed");
        MAP.put(Errors.LOCAL_VARIABLE_WITH_GETTER, "Local variables are not allowed to have getters");
        MAP.put(Errors.LOCAL_VARIABLE_WITH_SETTER, "Local variables are not allowed to have setters");
        MAP.put(Errors.VAL_WITH_SETTER, "A 'val'-property cannot have a setter");
        MAP.put(Errors.NO_GET_METHOD, "No get method providing array access");
        MAP.put(Errors.NO_SET_METHOD, "No set method providing array access");
        MAP.put(Errors.INC_DEC_SHOULD_NOT_RETURN_UNIT, "Functions inc(), dec() shouldn't return Unit to be used by operators ++, --");
        MAP.put(Errors.ASSIGNMENT_OPERATOR_SHOULD_RETURN_UNIT, "Function ''{0}'' should return Unit to be used by corresponding operator ''{1}''", Renderers.NAME, Renderers.ELEMENT_TEXT);
        MAP.put(Errors.ASSIGN_OPERATOR_AMBIGUITY, "Assignment operators ambiguity: {0}", Renderers.AMBIGUOUS_CALLS);
        MAP.put(Errors.EQUALS_MISSING, "No method 'equals(kotlin.Any?): kotlin.Boolean' available");
        MAP.put(Errors.ASSIGNMENT_IN_EXPRESSION_CONTEXT, "Assignments are not expressions, and only expressions are allowed in this context");
        MAP.put(Errors.PACKAGE_IS_NOT_AN_EXPRESSION, "'package' is not an expression, it can only be used on the left-hand side of a dot ('.')");
        MAP.put(Errors.SUPER_IS_NOT_AN_EXPRESSION, "''{0}'' is not an expression, it can only be used on the left-hand side of a dot ('.')", Renderers.STRING);
        MAP.put(Errors.DECLARATION_IN_ILLEGAL_CONTEXT, "Declarations are not allowed in this position");
        MAP.put(Errors.SETTER_PARAMETER_WITH_DEFAULT_VALUE, "Setter parameters cannot have default values");
        MAP.put(Errors.NO_THIS, "'this' is not defined in this context");
        MAP.put(Errors.SUPER_NOT_AVAILABLE, "No supertypes are accessible in this context");
        MAP.put(Errors.SUPERCLASS_NOT_ACCESSIBLE_FROM_TRAIT, "Superclass is not accessible from trait");
        MAP.put(Errors.AMBIGUOUS_SUPER, "Many supertypes available, please specify the one you mean in angle brackets, e.g. 'super<Foo>'");
        MAP.put(Errors.ABSTRACT_SUPER_CALL, "Abstract member cannot be accessed directly");
        MAP.put(Errors.NOT_A_SUPERTYPE, "Not a supertype");
        MAP.put(Errors.TYPE_ARGUMENTS_REDUNDANT_IN_SUPER_QUALIFIER, "Type arguments do not need to be specified in a 'super' qualifier");
        MAP.put(Errors.USELESS_CAST_STATIC_ASSERT_IS_FINE, "No cast needed. You can use ':' if you need a cast to a super type");
        MAP.put(Errors.USELESS_CAST, "No cast needed");
        MAP.put(Errors.CAST_NEVER_SUCCEEDS, "This cast can never succeed");
        MAP.put(Errors.DYNAMIC_NOT_ALLOWED, "Dynamic types are not allowed in this position");
        MAP.put(Errors.USELESS_NULLABLE_CHECK, "Non-null type is checked for instance of nullable type");
        MAP.put(Errors.WRONG_SETTER_PARAMETER_TYPE, "Setter parameter type must be equal to the type of the property, i.e. ''{0}''", Renderers.RENDER_TYPE, Renderers.RENDER_TYPE);
        MAP.put(Errors.WRONG_GETTER_RETURN_TYPE, "Getter return type must be equal to the type of the property, i.e. ''{0}''", Renderers.RENDER_TYPE, Renderers.RENDER_TYPE);
        MAP.put(Errors.NO_CLASS_OBJECT, "Please specify constructor invocation; classifier ''{0}'' does not have a class object", Renderers.NAME);
        MAP.put(Errors.TYPE_PARAMETER_IS_NOT_AN_EXPRESSION, "Type parameter ''{0}'' is not an expression", Renderers.NAME);
        MAP.put(Errors.TYPE_PARAMETER_ON_LHS_OF_DOT, "Type parameter ''{0}'' cannot have or inherit a class object, so it cannot be on the left hand side of dot", Renderers.NAME);
        MAP.put(Errors.NO_GENERICS_IN_SUPERTYPE_SPECIFIER, "Generic arguments of the base type must be specified");
        MAP.put(Errors.NESTED_CLASS_ACCESSED_VIA_INSTANCE_REFERENCE, "Nested {0} accessed via instance reference", Renderers.RENDER_CLASS_OR_OBJECT_NAME);
        MAP.put(Errors.NESTED_CLASS_SHOULD_BE_QUALIFIED, "Nested {0} should be qualified as ''{1}''", Renderers.RENDER_CLASS_OR_OBJECT_NAME, Renderers.TO_STRING);
        MAP.put(Errors.INACCESSIBLE_OUTER_CLASS_EXPRESSION, "Expression is inaccessible from a nested class ''{0}'', use ''inner'' keyword to make the class inner", Renderers.NAME);
        MAP.put(Errors.NESTED_CLASS_NOT_ALLOWED, "Nested class is not allowed here, use ''inner'' keyword to make the class inner");
        MAP.put(Errors.HAS_NEXT_MISSING, "hasNext() cannot be called on iterator() of type ''{0}''", Renderers.RENDER_TYPE);
        MAP.put(Errors.HAS_NEXT_FUNCTION_AMBIGUITY, "hasNext() is ambiguous for iterator() of type ''{0}''", Renderers.RENDER_TYPE);
        MAP.put(Errors.HAS_NEXT_FUNCTION_NONE_APPLICABLE, "None of the hasNext() functions is applicable for iterator() of type ''{0}''", Renderers.RENDER_TYPE);
        MAP.put(Errors.HAS_NEXT_FUNCTION_TYPE_MISMATCH, "The ''iterator().hasNext()'' function of the loop range must return kotlin.Boolean, but returns {0}", Renderers.RENDER_TYPE);
        MAP.put(Errors.NEXT_MISSING, "next() cannot be called on iterator() of type ''{0}''", Renderers.RENDER_TYPE);
        MAP.put(Errors.NEXT_AMBIGUITY, "next() is ambiguous for iterator() of type ''{0}''", Renderers.RENDER_TYPE);
        MAP.put(Errors.NEXT_NONE_APPLICABLE, "None of the next() functions is applicable for iterator() of type ''{0}''", Renderers.RENDER_TYPE);
        MAP.put(Errors.ITERATOR_MISSING, "For-loop range must have an iterator() method");
        MAP.put(Errors.ITERATOR_AMBIGUITY, "Method ''iterator()'' is ambiguous for this expression: {0}", Renderers.AMBIGUOUS_CALLS);
        MAP.put(Errors.DELEGATE_SPECIAL_FUNCTION_MISSING, "Missing ''{0}'' method on delegate of type ''{1}''", Renderers.STRING, Renderers.RENDER_TYPE);
        MAP.put(Errors.DELEGATE_SPECIAL_FUNCTION_AMBIGUITY, "Overload resolution ambiguity on method ''{0}'': {1}", Renderers.STRING, Renderers.AMBIGUOUS_CALLS);
        MAP.put(Errors.DELEGATE_SPECIAL_FUNCTION_NONE_APPLICABLE, "Property delegate must have a ''{0}'' method. None of the following functions is suitable: {1}", Renderers.STRING, Renderers.AMBIGUOUS_CALLS);
        MAP.put(Errors.DELEGATE_SPECIAL_FUNCTION_RETURN_TYPE_MISMATCH, "The ''{0}'' function of property delegate is expected to return ''{1}'', but returns ''{2}''", Renderers.STRING, Renderers.RENDER_TYPE, Renderers.RENDER_TYPE);
        MAP.put(Errors.DELEGATE_PD_METHOD_NONE_APPLICABLE, "''{0}'' method may be missing. None of the following functions will be called: {1}", Renderers.STRING, Renderers.AMBIGUOUS_CALLS);
        MAP.put(Errors.COMPARE_TO_TYPE_MISMATCH, "''compareTo()'' must return kotlin.Int, but returns {0}", Renderers.RENDER_TYPE);
        MAP.put(Errors.RETURN_IN_FUNCTION_WITH_EXPRESSION_BODY, "Returns are not allowed for functions with expression body. Use block body in '{...}'");
        MAP.put(Errors.NO_RETURN_IN_FUNCTION_WITH_BLOCK_BODY, "A 'return' expression required in a function with a block body ('{...}')");
        MAP.put(Errors.RETURN_TYPE_MISMATCH, "This function must return a value of type {0}", Renderers.RENDER_TYPE);
        MAP.put(Errors.EXPECTED_TYPE_MISMATCH, "Expected a value of type {0}", Renderers.RENDER_TYPE);
        MAP.put(Errors.ASSIGNMENT_TYPE_MISMATCH, "Expected a value of type {0}. Assignment operation is not an expression, so it does not return any value", Renderers.RENDER_TYPE);
        MAP.put(Errors.EXPECTED_PARAMETER_TYPE_MISMATCH, "Expected parameter of type {0}", Renderers.RENDER_TYPE);
        MAP.put(Errors.EXPECTED_RETURN_TYPE_MISMATCH, "Expected return type {0}", Renderers.RENDER_TYPE);
        MAP.put(Errors.EXPECTED_PARAMETERS_NUMBER_MISMATCH, "Expected {0,choice,0#no parameters|1#one parameter of type|1<{0,number,integer} parameters of types} {1}", null, Renderers.RENDER_COLLECTION_OF_TYPES);
        MAP.put(Errors.IMPLICIT_CAST_TO_UNIT_OR_ANY, "Type is cast to ''{0}''. Please specify ''{0}'' as expected type, if you mean such cast", Renderers.RENDER_TYPE);
        MAP.put(Errors.EXPRESSION_EXPECTED, "{0} is not an expression, and only expressions are allowed here", new Renderer<JetExpression>(){

            @Override
            @NotNull
            public String render(@NotNull JetExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/diagnostics/rendering/DefaultErrorMessages$3", "render"));
                }
                String expressionType = expression.toString();
                String string = expressionType.substring(0, 1) + expressionType.substring(1).toLowerCase();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/DefaultErrorMessages$3", "render"));
                }
                return string;
            }
        });
        MAP.put(Errors.UPPER_BOUND_VIOLATED, "Type argument is not within its bounds: should be subtype of ''{0}''", Renderers.RENDER_TYPE, Renderers.RENDER_TYPE);
        MAP.put(Errors.FINAL_CLASS_OBJECT_UPPER_BOUND, "''{0}'' is a final type, and thus a class object cannot extend it", Renderers.RENDER_TYPE);
        MAP.put(Errors.FINAL_UPPER_BOUND, "''{0}'' is a final type, and thus a value of the type parameter is predetermined", Renderers.RENDER_TYPE);
        MAP.put(Errors.DYNAMIC_UPPER_BOUND, "Dynamic type can not be used as an upper bound");
        MAP.put(Errors.USELESS_ELVIS, "Elvis operator (?:) always returns the left operand of non-nullable type {0}", Renderers.RENDER_TYPE);
        MAP.put(Errors.CONFLICTING_UPPER_BOUNDS, "Upper bounds of {0} have empty intersection", Renderers.NAME);
        MAP.put(Errors.CONFLICTING_CLASS_OBJECT_UPPER_BOUNDS, "Class object upper bounds of {0} have empty intersection", Renderers.NAME);
        MAP.put(Errors.TOO_MANY_ARGUMENTS, "Too many arguments for {0}", DescriptorRenderer.FQ_NAMES_IN_TYPES);
        MAP.put(Errors.CONSTANT_EXPECTED_TYPE_MISMATCH, "An {0} literal does not conform to the expected type {1}", Renderers.STRING, Renderers.RENDER_TYPE);
        MAP.put(Errors.INTEGER_OVERFLOW, "This operation has led to an overflow");
        MAP.put(Errors.INT_LITERAL_OUT_OF_RANGE, "The value is out of range");
        MAP.put(Errors.WRONG_LONG_SUFFIX, "Use 'L' instead of 'l'");
        MAP.put(Errors.FLOAT_LITERAL_OUT_OF_RANGE, "The value is out of range");
        MAP.put(Errors.INCORRECT_CHARACTER_LITERAL, "Incorrect character literal");
        MAP.put(Errors.EMPTY_CHARACTER_LITERAL, "Empty character literal");
        MAP.put(Errors.TOO_MANY_CHARACTERS_IN_CHARACTER_LITERAL, "Too many characters in a character literal ''{0}''", Renderers.ELEMENT_TEXT);
        MAP.put(Errors.ILLEGAL_ESCAPE, "Illegal escape: ''{0}''", Renderers.ELEMENT_TEXT);
        MAP.put(Errors.NULL_FOR_NONNULL_TYPE, "Null can not be a value of a non-null type {0}", Renderers.RENDER_TYPE);
        MAP.put(Errors.ELSE_MISPLACED_IN_WHEN, "'else' entry must be the last one in a when-expression");
        MAP.put(Errors.NO_ELSE_IN_WHEN, "'when' expression must contain 'else' branch");
        MAP.put(Errors.TYPE_MISMATCH_IN_RANGE, "Type mismatch: incompatible types of range and element checked in it");
        MAP.put(Errors.CYCLIC_INHERITANCE_HIERARCHY, "There's a cycle in the inheritance hierarchy for this type");
        MAP.put(Errors.MANY_CLASSES_IN_SUPERTYPE_LIST, "Only one class may appear in a supertype list");
        MAP.put(Errors.SUPERTYPE_NOT_A_CLASS_OR_TRAIT, "Only classes and traits may serve as supertypes");
        MAP.put(Errors.SUPERTYPE_INITIALIZED_IN_TRAIT, "Traits cannot initialize supertypes");
        MAP.put(Errors.CLASS_IN_SUPERTYPE_FOR_ENUM, "Enum class cannot inherit from classes");
        MAP.put(Errors.CONSTRUCTOR_IN_TRAIT, "A trait may not have a constructor");
        MAP.put(Errors.SUPERTYPE_APPEARS_TWICE, "A supertype appears twice");
        MAP.put(Errors.FINAL_SUPERTYPE, "This type is final, so it cannot be inherited from");
        MAP.put(Errors.SINGLETON_IN_SUPERTYPE, "Cannot inherit from a singleton");
        MAP.put(Errors.ILLEGAL_SELECTOR, "Expression ''{0}'' cannot be a selector (occur after a dot)", Renderers.STRING);
        MAP.put(Errors.NO_TAIL_CALLS_FOUND, "A function is marked as tail-recursive but no tail calls are found");
        MAP.put(Errors.VALUE_PARAMETER_WITH_NO_TYPE_ANNOTATION, "A type annotation is required on a value parameter");
        MAP.put(Errors.BREAK_OR_CONTINUE_OUTSIDE_A_LOOP, "'break' and 'continue' are only allowed inside a loop");
        MAP.put(Errors.BREAK_OR_CONTINUE_JUMPS_ACROSS_FUNCTION_BOUNDARY, "'break' or 'continue' jumps across a function boundary");
        MAP.put(Errors.NOT_A_LOOP_LABEL, "The label ''{0}'' does not denote a loop", Renderers.STRING);
        MAP.put(Errors.NOT_A_RETURN_LABEL, "The label ''{0}'' does not reference to a context from which we can return", Renderers.STRING);
        MAP.put(Errors.ANONYMOUS_INITIALIZER_IN_TRAIT, "Anonymous initializers are not allowed in traits");
        MAP.put(Errors.NULLABLE_SUPERTYPE, "A supertype cannot be nullable");
        MAP.put(Errors.DYNAMIC_SUPERTYPE, "A supertype cannot be dynamic");
        MAP.put(Errors.REDUNDANT_NULLABLE, "Redundant '?'");
        MAP.put(Errors.BASE_WITH_NULLABLE_UPPER_BOUND, "''{0}'' has a nullable upper bound. This means that a value of this type may be null. Using ''{0}?'' is likely to mislead the reader", Renderers.RENDER_TYPE);
        MAP.put(Errors.UNSAFE_CALL, "Only safe (?.) or non-null asserted (!!.) calls are allowed on a nullable receiver of type {0}", Renderers.RENDER_TYPE);
        MAP.put(Errors.AMBIGUOUS_LABEL, "Ambiguous label");
        MAP.put(Errors.UNSUPPORTED, "Unsupported [{0}]", Renderers.STRING);
        MAP.put(Errors.UNNECESSARY_SAFE_CALL, "Unnecessary safe call on a non-null receiver of type {0}", Renderers.RENDER_TYPE);
        MAP.put(Errors.UNNECESSARY_NOT_NULL_ASSERTION, "Unnecessary non-null assertion (!!) on a non-null receiver of type {0}", Renderers.RENDER_TYPE);
        MAP.put(Errors.NAME_IN_CONSTRAINT_IS_NOT_A_TYPE_PARAMETER, "{0} does not refer to a type parameter of {1}", new Renderer<JetTypeConstraint>(){

            @Override
            @NotNull
            public String render(@NotNull JetTypeConstraint typeConstraint) {
                if (typeConstraint == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeConstraint", "org/jetbrains/jet/lang/diagnostics/rendering/DefaultErrorMessages$4", "render"));
                }
                String string = typeConstraint.getSubjectTypeParameterName().getReferencedName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/DefaultErrorMessages$4", "render"));
                }
                return string;
            }
        }, Renderers.DECLARATION_NAME);
        MAP.put(Errors.SMARTCAST_IMPOSSIBLE, "Smart cast to ''{0}'' is impossible, because ''{1}'' could have changed since the is-check", Renderers.RENDER_TYPE, Renderers.STRING);
        MAP.put(Errors.VARIANCE_ON_TYPE_PARAMETER_OF_FUNCTION_OR_PROPERTY, "Variance annotations are only allowed for type parameters of classes and traits");
        MAP.put(Errors.TYPE_VARIANCE_CONFLICT, "Type parameter {0} is declared as ''{1}'' but occurs in ''{2}'' position in type {3}", new MultiRenderer<VarianceChecker.VarianceConflictDiagnosticData>(){

            @Override
            @NotNull
            public String[] render(@NotNull VarianceChecker.VarianceConflictDiagnosticData data2) {
                if (data2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/jet/lang/diagnostics/rendering/DefaultErrorMessages$5", "render"));
                }
                String[] stringArray = new String[]{Renderers.NAME.render(data2.getTypeParameter()), Renderers.RENDER_POSITION_VARIANCE.render(data2.getTypeParameter().getVariance()), Renderers.RENDER_POSITION_VARIANCE.render(data2.getOccurrencePosition()), Renderers.RENDER_TYPE.render(data2.getContainingType())};
                if (stringArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/DefaultErrorMessages$5", "render"));
                }
                return stringArray;
            }
        });
        MAP.put(Errors.REDUNDANT_PROJECTION, "Projection is redundant: the corresponding type parameter of {0} has the same variance", Renderers.NAME);
        MAP.put(Errors.CONFLICTING_PROJECTION, "Projection is conflicting with variance of the corresponding type parameter of {0}. Remove the projection or replace it with ''*''", Renderers.NAME);
        MAP.put(Errors.TYPE_MISMATCH_IN_FOR_LOOP, "The loop iterates over values of type {0} but the parameter is declared to be {1}", Renderers.RENDER_TYPE, Renderers.RENDER_TYPE);
        MAP.put(Errors.TYPE_MISMATCH_IN_CONDITION, "Condition must be of type kotlin.Boolean, but is of type {0}", Renderers.RENDER_TYPE);
        MAP.put(Errors.INCOMPATIBLE_TYPES, "Incompatible types: {0} and {1}", Renderers.RENDER_TYPE, Renderers.RENDER_TYPE);
        MAP.put(Errors.EXPECTED_CONDITION, "Expected condition of type kotlin.Boolean");
        MAP.put(Errors.CANNOT_CHECK_FOR_ERASED, "Cannot check for instance of erased type: {0}", Renderers.RENDER_TYPE);
        MAP.put(Errors.UNCHECKED_CAST, "Unchecked cast: {0} to {1}", Renderers.RENDER_TYPE, Renderers.RENDER_TYPE);
        MAP.put(Errors.INCONSISTENT_TYPE_PARAMETER_VALUES, "Type parameter {0} of ''{1}'' has inconsistent values: {2}", Renderers.NAME, Renderers.NAME, Renderers.RENDER_COLLECTION_OF_TYPES);
        MAP.put(Errors.EQUALITY_NOT_APPLICABLE, "Operator ''{0}'' cannot be applied to ''{1}'' and ''{2}''", new Renderer<JetSimpleNameExpression>(){

            @Override
            @NotNull
            public String render(@NotNull JetSimpleNameExpression nameExpression) {
                if (nameExpression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameExpression", "org/jetbrains/jet/lang/diagnostics/rendering/DefaultErrorMessages$6", "render"));
                }
                String string = nameExpression.getReferencedName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/DefaultErrorMessages$6", "render"));
                }
                return string;
            }
        }, Renderers.RENDER_TYPE, Renderers.RENDER_TYPE);
        MAP.put(Errors.SENSELESS_COMPARISON, "Condition ''{0}'' is always ''{1}''", Renderers.ELEMENT_TEXT, Renderers.TO_STRING);
        MAP.put(Errors.SENSELESS_NULL_IN_WHEN, "Expression under 'when' is never equal to null");
        MAP.put(Errors.OVERRIDING_FINAL_MEMBER, "''{0}'' in ''{1}'' is final and cannot be overridden", Renderers.NAME, Renderers.NAME);
        MAP.put(Errors.CANNOT_WEAKEN_ACCESS_PRIVILEGE, "Cannot weaken access privilege ''{0}'' for ''{1}'' in ''{2}''", Renderers.TO_STRING, Renderers.NAME, Renderers.NAME);
        MAP.put(Errors.CANNOT_CHANGE_ACCESS_PRIVILEGE, "Cannot change access privilege ''{0}'' for ''{1}'' in ''{2}''", Renderers.TO_STRING, Renderers.NAME, Renderers.NAME);
        MAP.put(Errors.RETURN_TYPE_MISMATCH_ON_OVERRIDE, "Return type of ''{0}'' is not a subtype of the return type of overridden member {1}", Renderers.NAME, DescriptorRenderer.FQ_NAMES_IN_TYPES);
        MAP.put(Errors.PROPERTY_TYPE_MISMATCH_ON_OVERRIDE, "Type of ''{0}'' doesn't match to the type of overridden var-property {1}", Renderers.NAME, DescriptorRenderer.FQ_NAMES_IN_TYPES);
        MAP.put(Errors.VAR_OVERRIDDEN_BY_VAL, "Var-property {0} cannot be overridden by val-property {1}", DescriptorRenderer.FQ_NAMES_IN_TYPES, DescriptorRenderer.FQ_NAMES_IN_TYPES);
        MAP.put(Errors.ABSTRACT_MEMBER_NOT_IMPLEMENTED, "{0} must be declared abstract or implement abstract member {1}", Renderers.RENDER_CLASS_OR_OBJECT, DescriptorRenderer.FQ_NAMES_IN_TYPES);
        MAP.put(Errors.MANY_IMPL_MEMBER_NOT_IMPLEMENTED, "{0} must override {1} because it inherits many implementations of it", Renderers.RENDER_CLASS_OR_OBJECT, DescriptorRenderer.FQ_NAMES_IN_TYPES);
        MAP.put(Errors.CONFLICTING_OVERLOADS, "''{0}'' is already defined in {1}", DescriptorRenderer.COMPACT_WITH_MODIFIERS, Renderers.STRING);
        MAP.put(Errors.ILLEGAL_PLATFORM_NAME, "Illegal platform name: ''{0}''", Renderers.STRING);
        MAP.put(Errors.FUNCTION_EXPECTED, "Expression ''{0}''{1} cannot be invoked as a function. The function 'invoke()' is not found", Renderers.ELEMENT_TEXT, new Renderer<JetType>(){

            @Override
            @NotNull
            public String render(@NotNull JetType type2) {
                if (type2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/diagnostics/rendering/DefaultErrorMessages$7", "render"));
                }
                if (type2.isError()) {
                    if ("" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/DefaultErrorMessages$7", "render"));
                    }
                    return "";
                }
                String string = " of type '" + Renderers.RENDER_TYPE.render(type2) + "'";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/DefaultErrorMessages$7", "render"));
                }
                return string;
            }
        });
        MAP.put(Errors.FUNCTION_CALL_EXPECTED, "Function invocation ''{0}({1})'' expected", Renderers.ELEMENT_TEXT, new Renderer<Boolean>(){

            @Override
            @NotNull
            public String render(@NotNull Boolean hasValueParameters) {
                if (hasValueParameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hasValueParameters", "org/jetbrains/jet/lang/diagnostics/rendering/DefaultErrorMessages$8", "render"));
                }
                String string = hasValueParameters != false ? "..." : "";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/DefaultErrorMessages$8", "render"));
                }
                return string;
            }
        });
        MAP.put(Errors.NON_TAIL_RECURSIVE_CALL, "Recursive call is not a tail call");
        MAP.put(Errors.TAIL_RECURSION_IN_TRY_IS_NOT_SUPPORTED, "Tail recursion optimization inside try/catch/finally is not supported");
        MAP.put(Errors.RESULT_TYPE_MISMATCH, "{0} must return {1} but returns {2}", Renderers.STRING, Renderers.RENDER_TYPE, Renderers.RENDER_TYPE);
        MAP.put(Errors.UNSAFE_INFIX_CALL, "Infix call corresponds to a dot-qualified call ''{0}.{1}({2})'' which is not allowed on a nullable receiver ''{0}''. Use '?.'-qualified call instead", Renderers.STRING, Renderers.STRING, Renderers.STRING);
        MAP.put(Errors.OVERLOAD_RESOLUTION_AMBIGUITY, "Overload resolution ambiguity: {0}", Renderers.AMBIGUOUS_CALLS);
        MAP.put(Errors.NONE_APPLICABLE, "None of the following functions can be called with the arguments supplied: {0}", Renderers.AMBIGUOUS_CALLS);
        MAP.put(Errors.CANNOT_COMPLETE_RESOLVE, "Cannot choose among the following candidates without completing type inference: {0}", Renderers.AMBIGUOUS_CALLS);
        MAP.put(Errors.UNRESOLVED_REFERENCE_WRONG_RECEIVER, "Unresolved reference. None of the following candidates is applicable because of receiver type mismatch: {0}", Renderers.AMBIGUOUS_CALLS);
        MAP.put(Errors.NO_VALUE_FOR_PARAMETER, "No value passed for parameter {0}", Renderers.NAME);
        MAP.put(Errors.MISSING_RECEIVER, "A receiver of type {0} is required", Renderers.RENDER_TYPE);
        MAP.put(Errors.NO_RECEIVER_ALLOWED, "No receiver can be passed to this function or property");
        MAP.put(Errors.CREATING_AN_INSTANCE_OF_ABSTRACT_CLASS, "Cannot create an instance of an abstract class");
        MAP.put(Errors.TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS, "Type inference failed: {0}", Renderers.TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER);
        MAP.put(Errors.TYPE_INFERENCE_CANNOT_CAPTURE_TYPES, "Type inference failed: {0}", Renderers.TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER);
        MAP.put(Errors.TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER, "Type inference failed: {0}", Renderers.TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER);
        MAP.put(Errors.TYPE_INFERENCE_TYPE_CONSTRUCTOR_MISMATCH, "Type inference failed: {0}", Renderers.TYPE_INFERENCE_TYPE_CONSTRUCTOR_MISMATCH_RENDERER);
        MAP.put(Errors.TYPE_INFERENCE_UPPER_BOUND_VIOLATED, "{0}", Renderers.TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER);
        MAP.put(Errors.TYPE_INFERENCE_EXPECTED_TYPE_MISMATCH, "Type inference failed. Expected type mismatch: found: {1} required: {0}", Renderers.RENDER_TYPE, Renderers.RENDER_TYPE);
        MAP.put(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS, "{0,choice,0#No type arguments|1#Type argument|1<{0,number,integer} type arguments} expected", (Renderer)null);
        MAP.put(Errors.NO_TYPE_ARGUMENTS_ON_RHS, "{0,choice,0#No type arguments|1#Type argument|1<{0,number,integer} type arguments} expected. Use ''{1}'' if you don''t want to pass type arguments", null, Renderers.STRING);
        MAP.put(Errors.DANGLING_FUNCTION_LITERAL_ARGUMENT_SUSPECTED, "This expression is treated as an argument to the function call on the previous line. Separate it with a semicolon (;) if it is not intended to be an argument.");
        MAP.put(Errors.TYPE_PARAMETER_AS_REIFIED, "Cannot use ''{0}'' as reified type parameter. Use a class instead.", Renderers.NAME);
        MAP.put(Errors.REIFIED_TYPE_PARAMETER_NO_INLINE, "Only type parameters of inline functions can be reified");
        MAP.put(Errors.REIFIED_TYPE_FORBIDDEN_SUBSTITUTION, "Cannot use ''{0}'' as reified type parameter", Renderers.RENDER_TYPE);
        MAP.put(Errors.SUPERTYPES_FOR_ANNOTATION_CLASS, "Annotation class cannot have supertypes");
        MAP.put(Errors.MISSING_VAL_ON_ANNOTATION_PARAMETER, "'val' keyword is missing on annotation parameter");
        MAP.put(Errors.ANNOTATION_CLASS_CONSTRUCTOR_CALL, "Annotation class cannot be instantiated");
        MAP.put(Errors.NOT_AN_ANNOTATION_CLASS, "''{0}'' is not an annotation class", Renderers.NAME);
        MAP.put(Errors.ANNOTATION_CLASS_WITH_BODY, "Body is not allowed for annotation class");
        MAP.put(Errors.INVALID_TYPE_OF_ANNOTATION_MEMBER, "Invalid type of annotation member");
        MAP.put(Errors.NULLABLE_TYPE_OF_ANNOTATION_MEMBER, "An annotation parameter cannot be nullable");
        MAP.put(Errors.ILLEGAL_ANNOTATION_KEYWORD, "''annotation'' keyword is only applicable for class");
        MAP.put(Errors.ANNOTATION_PARAMETER_MUST_BE_CONST, "An annotation parameter must be a compile-time constant");
        MAP.put(Errors.ANNOTATION_PARAMETER_MUST_BE_ENUM_CONST, "An enum annotation parameter must be a enum constant");
        MAP.put(Errors.ANNOTATION_PARAMETER_MUST_BE_CLASS_LITERAL, "An annotation parameter must be a class literal");
        MAP.put(Errors.DEFAULT_VALUE_NOT_ALLOWED_IN_OVERRIDE, "An overriding function is not allowed to specify default values for its parameters");
        String multipleDefaultsMessage = "More than one overridden descriptor declares a default value for ''{0}''. As the compiler can not make sure these values agree, this is not allowed.";
        MAP.put(Errors.MULTIPLE_DEFAULTS_INHERITED_FROM_SUPERTYPES, multipleDefaultsMessage, DescriptorRenderer.FQ_NAMES_IN_TYPES);
        MAP.put(Errors.MULTIPLE_DEFAULTS_INHERITED_FROM_SUPERTYPES_WHEN_NO_EXPLICIT_OVERRIDE, multipleDefaultsMessage, DescriptorRenderer.FQ_NAMES_IN_TYPES);
        MAP.put(Errors.PARAMETER_NAME_CHANGED_ON_OVERRIDE, "The corresponding parameter in the supertype ''{0}'' is named ''{1}''. This may cause problems when calling this function with named arguments.", Renderers.NAME, Renderers.NAME);
        MAP.put(Errors.DIFFERENT_NAMES_FOR_THE_SAME_PARAMETER_IN_SUPERTYPES, "Names of the parameter #{1} conflict in the following members of supertypes: ''{0}''. This may cause problems when calling this function with named arguments.", Renderers.commaSeparated(DescriptorRenderer.FQ_NAMES_IN_TYPES), Renderers.TO_STRING);
        MAP.put(Errors.AMBIGUOUS_ANONYMOUS_TYPE_INFERRED, "Right-hand side has anonymous type. Please specify type explicitly", Renderers.TO_STRING);
        MAP.put(Errors.REFLECTION_TYPES_NOT_LOADED, "Reflection types can't be loaded. Please ensure that you have Kotlin Runtime in your classpath");
        MAP.put(Errors.EXTENSION_IN_CLASS_REFERENCE_NOT_ALLOWED, "''{0}'' is a member and an extension at the same time. References to such elements are not allowed", Renderers.NAME);
        MAP.put(Errors.CALLABLE_REFERENCE_LHS_NOT_A_CLASS, "Callable reference left-hand side cannot be a type parameter");
        MAP.put(Errors.INVISIBLE_MEMBER_FROM_INLINE, "Cannot access effectively non-public-api ''{0}'' member from effectively public-api ''{1}''", DescriptorRenderer.SHORT_NAMES_IN_TYPES, DescriptorRenderer.SHORT_NAMES_IN_TYPES);
        MAP.put(Errors.NOT_YET_SUPPORTED_IN_INLINE, "''{0}'' construction not yet supported in inline functions", Renderers.ELEMENT_TEXT, DescriptorRenderer.SHORT_NAMES_IN_TYPES);
        MAP.put(Errors.DECLARATION_CANT_BE_INLINED, "Inline annotation could be present only on nonvirtual members (private or final)");
        MAP.put(Errors.NOTHING_TO_INLINE, "Expected performance impact of inlining ''{0}'' can be insignificant. Inlining works best for functions with lambda parameters", DescriptorRenderer.SHORT_NAMES_IN_TYPES);
        MAP.put(Errors.USAGE_IS_NOT_INLINABLE, "Illegal usage of inline-parameter ''{0}'' in ''{1}''. Annotate the parameter with [noinline]", Renderers.ELEMENT_TEXT, DescriptorRenderer.SHORT_NAMES_IN_TYPES);
        MAP.put(Errors.NULLABLE_INLINE_PARAMETER, "Inline-parameter ''{0}'' of ''{1}'' must not be nullable. Annotate the parameter with [noinline] or make not nullable", Renderers.ELEMENT_TEXT, DescriptorRenderer.SHORT_NAMES_IN_TYPES);
        MAP.put(Errors.RECURSION_IN_INLINE, "Inline-function ''{1}'' can't be recursive", Renderers.ELEMENT_TEXT, DescriptorRenderer.SHORT_NAMES_IN_TYPES);
        MAP.put(Errors.NON_LOCAL_RETURN_NOT_ALLOWED, "Can''t inline ''{0}'' here: it may contain non-local returns. Annotate parameter declaration ''{0}'' with ''inlineOptions(ONLY_LOCAL_RETURN)''", Renderers.ELEMENT_TEXT, DescriptorRenderer.SHORT_NAMES_IN_TYPES, DescriptorRenderer.SHORT_NAMES_IN_TYPES);
        MAP.setImmutable();
        for (Field field : Errors.class.getFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                Object fieldValue = field.get(null);
                if (!(fieldValue instanceof DiagnosticFactory) || MAP.get((DiagnosticFactory)fieldValue) != null) continue;
                throw new IllegalStateException("No default diagnostic renderer is provided for " + ((DiagnosticFactory)fieldValue).getName());
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        DefaultErrorMessages.resetMapsIfNeeded();
    }

    public static interface Extension {
        public static final ExtensionPointName<Extension> EP_NAME = ExtensionPointName.create("org.jetbrains.kotlin.defaultErrorMessages");

        @NotNull
        public DiagnosticFactoryToRendererMap getMap();
    }
}

