/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;

@KotlinSyntheticClass(abiVersion=19, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class DiagnosticsPackage$PositioningStrategy$7f4b466c {
    @NotNull
    public static final List<TextRange> markElement(@JetValueParameter(name="element") @NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/DiagnosticsPackage$PositioningStrategy$7f4b466c", "markElement"));
        }
        Intrinsics.checkParameterIsNotNull(element, "element");
        List<TextRange> list = KotlinPackage.listOf(new TextRange(DiagnosticsPackage$PositioningStrategy$7f4b466c.getStartOffset(element), DiagnosticsPackage$PositioningStrategy$7f4b466c.getEndOffset(element)));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/DiagnosticsPackage$PositioningStrategy$7f4b466c", "markElement"));
        }
        return list;
    }

    @NotNull
    public static final List<TextRange> markNode(@JetValueParameter(name="node") @NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/diagnostics/DiagnosticsPackage$PositioningStrategy$7f4b466c", "markNode"));
        }
        Intrinsics.checkParameterIsNotNull(node, "node");
        PsiElement psiElement = node.getPsi();
        Intrinsics.checkExpressionValueIsNotNull(psiElement, "node.getPsi()");
        List<TextRange> list = DiagnosticsPackage$PositioningStrategy$7f4b466c.markElement(psiElement);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/DiagnosticsPackage$PositioningStrategy$7f4b466c", "markNode"));
        }
        return list;
    }

    @NotNull
    public static final List<TextRange> markRange(@JetValueParameter(name="range") @NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/jet/lang/diagnostics/DiagnosticsPackage$PositioningStrategy$7f4b466c", "markRange"));
        }
        Intrinsics.checkParameterIsNotNull(range, "range");
        List<TextRange> list = KotlinPackage.listOf(range);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/DiagnosticsPackage$PositioningStrategy$7f4b466c", "markRange"));
        }
        return list;
    }

    @NotNull
    public static final List<TextRange> markRange(@JetValueParameter(name="from") @NotNull PsiElement from, @JetValueParameter(name="to") @NotNull PsiElement to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/jet/lang/diagnostics/DiagnosticsPackage$PositioningStrategy$7f4b466c", "markRange"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/jet/lang/diagnostics/DiagnosticsPackage$PositioningStrategy$7f4b466c", "markRange"));
        }
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(to, "to");
        List<TextRange> list = DiagnosticsPackage$PositioningStrategy$7f4b466c.markRange(new TextRange(DiagnosticsPackage$PositioningStrategy$7f4b466c.getStartOffset(from), DiagnosticsPackage$PositioningStrategy$7f4b466c.getEndOffset(to)));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/DiagnosticsPackage$PositioningStrategy$7f4b466c", "markRange"));
        }
        return list;
    }

    public static final int getStartOffset(@JetValueParameter(name="element") @NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/DiagnosticsPackage$PositioningStrategy$7f4b466c", "getStartOffset"));
        }
        Intrinsics.checkParameterIsNotNull(element, "element");
        PsiElement child = element.getFirstChild();
        if (child != null) {
            while (!(child instanceof PsiComment) ? child instanceof PsiWhiteSpace : true) {
                PsiElement psiElement = child;
                if (psiElement == null) {
                    Intrinsics.throwNpe();
                }
                child = psiElement.getNextSibling();
            }
            if (child != null) {
                PsiElement psiElement = child;
                if (psiElement == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(psiElement, "child!!");
                return DiagnosticsPackage$PositioningStrategy$7f4b466c.getStartOffset(psiElement);
            }
        }
        return element.getTextRange().getStartOffset();
    }

    public static final int getEndOffset(@JetValueParameter(name="element") @NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/DiagnosticsPackage$PositioningStrategy$7f4b466c", "getEndOffset"));
        }
        Intrinsics.checkParameterIsNotNull(element, "element");
        PsiElement child = element.getLastChild();
        if (child != null) {
            while (!(child instanceof PsiComment) ? child instanceof PsiWhiteSpace : true) {
                PsiElement psiElement = child;
                if (psiElement == null) {
                    Intrinsics.throwNpe();
                }
                child = psiElement.getPrevSibling();
            }
            if (child != null) {
                PsiElement psiElement = child;
                if (psiElement == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(psiElement, "child!!");
                return DiagnosticsPackage$PositioningStrategy$7f4b466c.getEndOffset(psiElement);
            }
        }
        return element.getTextRange().getEndOffset();
    }

    public static final boolean hasSyntaxErrors(@JetValueParameter(name="psiElement") @NotNull PsiElement psiElement) {
        boolean bl;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/jet/lang/diagnostics/DiagnosticsPackage$PositioningStrategy$7f4b466c", "hasSyntaxErrors"));
        }
        Intrinsics.checkParameterIsNotNull(psiElement, "psiElement");
        if (psiElement instanceof PsiErrorElement) {
            return true;
        }
        PsiElement[] children = psiElement.getChildren();
        if (KotlinPackage.isNotEmpty((Object[])children)) {
            PsiElement psiElement2 = (PsiElement)KotlinPackage.last((Object[])children);
            Intrinsics.checkExpressionValueIsNotNull(psiElement2, "children.last()");
            bl = DiagnosticsPackage$PositioningStrategy$7f4b466c.hasSyntaxErrors(psiElement2);
        } else {
            bl = false;
        }
        return bl;
    }
}

