/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.StringTable;
import org.jetbrains.jet.utils.UtilsPackage;

public class NameSerializationUtil {
    private NameSerializationUtil() {
    }

    @NotNull
    public static NameResolver deserializeNameResolver(@NotNull InputStream in) {
        NameResolver nameResolver;
        block3: {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "deserializeNameResolver"));
            }
            try {
                ProtoBuf.StringTable simpleNames = ProtoBuf.StringTable.parseDelimitedFrom(in);
                ProtoBuf.QualifiedNameTable qualifiedNames = ProtoBuf.QualifiedNameTable.parseDelimitedFrom(in);
                nameResolver = new NameResolver(simpleNames, qualifiedNames);
                if (nameResolver != null) break block3;
            }
            catch (IOException e) {
                throw UtilsPackage.rethrow(e);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "deserializeNameResolver"));
        }
        return nameResolver;
    }

    public static void serializeNameResolver(@NotNull OutputStream out, @NotNull NameResolver nameResolver) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "serializeNameResolver"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "serializeNameResolver"));
        }
        NameSerializationUtil.serializeStringTable(out, nameResolver.getStringTable(), nameResolver.getQualifiedNameTable());
    }

    public static void serializeStringTable(@NotNull OutputStream out, @NotNull StringTable stringTable) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "serializeStringTable"));
        }
        if (stringTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringTable", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "serializeStringTable"));
        }
        NameSerializationUtil.serializeStringTable(out, NameSerializationUtil.toStringTable(stringTable), NameSerializationUtil.toQualifiedNameTable(stringTable));
    }

    private static void serializeStringTable(@NotNull OutputStream out, @NotNull ProtoBuf.StringTable stringTable, @NotNull ProtoBuf.QualifiedNameTable qualifiedNameTable) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "serializeStringTable"));
        }
        if (stringTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringTable", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "serializeStringTable"));
        }
        if (qualifiedNameTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedNameTable", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "serializeStringTable"));
        }
        try {
            stringTable.writeDelimitedTo(out);
            qualifiedNameTable.writeDelimitedTo(out);
        }
        catch (IOException e) {
            throw UtilsPackage.rethrow(e);
        }
    }

    @NotNull
    public static ProtoBuf.StringTable toStringTable(@NotNull StringTable stringTable) {
        if (stringTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringTable", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "toStringTable"));
        }
        ProtoBuf.StringTable.Builder simpleNames = ProtoBuf.StringTable.newBuilder();
        for (String simpleName : stringTable.getStrings()) {
            simpleNames.addString(simpleName);
        }
        ProtoBuf.StringTable stringTable2 = simpleNames.build();
        if (stringTable2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "toStringTable"));
        }
        return stringTable2;
    }

    @NotNull
    public static ProtoBuf.QualifiedNameTable toQualifiedNameTable(@NotNull StringTable stringTable) {
        if (stringTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringTable", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "toQualifiedNameTable"));
        }
        ProtoBuf.QualifiedNameTable.Builder qualifiedNames = ProtoBuf.QualifiedNameTable.newBuilder();
        for (ProtoBuf.QualifiedNameTable.QualifiedName.Builder qName : stringTable.getFqNames()) {
            qualifiedNames.addQualifiedName(qName);
        }
        ProtoBuf.QualifiedNameTable qualifiedNameTable = qualifiedNames.build();
        if (qualifiedNameTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "toQualifiedNameTable"));
        }
        return qualifiedNameTable;
    }

    @NotNull
    public static NameResolver createNameResolver(@NotNull StringTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "createNameResolver"));
        }
        NameResolver nameResolver = new NameResolver(NameSerializationUtil.toStringTable(table), NameSerializationUtil.toQualifiedNameTable(table));
        if (nameResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/NameSerializationUtil", "createNameResolver"));
        }
        return nameResolver;
    }
}

