/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.inline;

import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.inline.CapturedParamInfo;
import org.jetbrains.jet.codegen.inline.FieldRemapper;
import org.jetbrains.jet.codegen.inline.LambdaInfo;
import org.jetbrains.jet.codegen.inline.Parameters;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;

public class RegeneratedLambdaFieldRemapper
extends FieldRemapper {
    private final String oldOwnerType;
    private final String newOwnerType;
    private final Parameters parameters;
    private final Map<String, LambdaInfo> recapturedLambdas;

    public RegeneratedLambdaFieldRemapper(String oldOwnerType, String newOwnerType, Parameters parameters2, Map<String, LambdaInfo> recapturedLambdas, FieldRemapper remapper) {
        super(oldOwnerType, remapper, parameters2);
        this.oldOwnerType = oldOwnerType;
        this.newOwnerType = newOwnerType;
        this.parameters = parameters2;
        this.recapturedLambdas = recapturedLambdas;
    }

    @Override
    public boolean canProcess(@NotNull String fieldOwner, String fieldName, boolean isFolding) {
        if (fieldOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldOwner", "org/jetbrains/jet/codegen/inline/RegeneratedLambdaFieldRemapper", "canProcess"));
        }
        return super.canProcess(fieldOwner, fieldName, isFolding) || this.isRecapturedLambdaType(fieldOwner);
    }

    private boolean isRecapturedLambdaType(String owner) {
        return this.recapturedLambdas.containsKey(owner);
    }

    @Override
    @Nullable
    public CapturedParamInfo findField(@NotNull FieldInsnNode fieldInsnNode, @NotNull Collection<CapturedParamInfo> captured) {
        boolean searchInParent;
        if (fieldInsnNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldInsnNode", "org/jetbrains/jet/codegen/inline/RegeneratedLambdaFieldRemapper", "findField"));
        }
        if (captured == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "captured", "org/jetbrains/jet/codegen/inline/RegeneratedLambdaFieldRemapper", "findField"));
        }
        boolean bl = searchInParent = !this.canProcess(fieldInsnNode.owner, fieldInsnNode.name, false);
        if (searchInParent) {
            return this.parent.findField(fieldInsnNode);
        }
        return this.findFieldInMyCaptured(fieldInsnNode);
    }

    @Nullable
    public CapturedParamInfo findFieldInMyCaptured(@NotNull FieldInsnNode fieldInsnNode) {
        if (fieldInsnNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldInsnNode", "org/jetbrains/jet/codegen/inline/RegeneratedLambdaFieldRemapper", "findFieldInMyCaptured"));
        }
        return super.findField(fieldInsnNode, this.parameters.getCaptured());
    }

    @Override
    @Nullable
    public StackValue getFieldForInline(@NotNull FieldInsnNode node, @Nullable StackValue prefix) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/codegen/inline/RegeneratedLambdaFieldRemapper", "getFieldForInline"));
        }
        assert (node.name.startsWith("$$$")) : "Captured field template should start with $$$ prefix";
        FieldInsnNode fin = new FieldInsnNode(node.getOpcode(), node.owner, node.name.substring(3), node.desc);
        CapturedParamInfo field = this.findFieldInMyCaptured(fin);
        boolean searchInParent = false;
        if (field == null) {
            field = this.findFieldInMyCaptured(new FieldInsnNode(178, this.oldOwnerType, "this$0", Type.getObjectType(this.parent.getLambdaInternalName()).getDescriptor()));
            searchInParent = true;
            if (field == null) {
                throw new IllegalStateException("Couldn't find captured this " + this.getLambdaInternalName() + " for " + node.name);
            }
        }
        StackValue.Field result2 = StackValue.field(field.getType(), Type.getObjectType(this.newOwnerType), field.getNewFieldName(), false, prefix == null ? StackValue.LOCAL_0 : prefix);
        return searchInParent ? this.parent.getFieldForInline(node, result2) : result2;
    }
}

