/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.inline;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.inline.ParameterInfo;
import org.jetbrains.jet.codegen.inline.Parameters;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class LocalVarRemapper {
    private final int allParamsSize;
    private final Parameters params;
    private final int actualParamsSize;
    private final StackValue[] remapValues;
    private final int additionalShift;

    public LocalVarRemapper(Parameters params, int additionalShift) {
        this.additionalShift = additionalShift;
        this.allParamsSize = params.totalSize();
        this.params = params;
        int realSize = 0;
        this.remapValues = new StackValue[params.totalSize()];
        int index2 = 0;
        for (ParameterInfo info : params) {
            if (!info.isSkippedOrRemapped()) {
                this.remapValues[index2] = StackValue.local(realSize, AsmTypeConstants.OBJECT_TYPE);
                realSize += info.getType().getSize();
            } else {
                this.remapValues[index2] = info.isRemapped() ? info.getRemapValue() : null;
            }
            ++index2;
        }
        this.actualParamsSize = realSize;
    }

    public RemapInfo doRemap(int index2) {
        int remappedIndex;
        if (index2 < this.allParamsSize) {
            ParameterInfo info = this.params.get(index2);
            StackValue remapped = this.remapValues[index2];
            if (info.isSkipped || remapped == null) {
                return new RemapInfo(info);
            }
            if (info.isRemapped()) {
                return new RemapInfo(remapped, info, RemapStatus.REMAPPED);
            }
            remappedIndex = ((StackValue.Local)remapped).index;
        } else {
            remappedIndex = this.actualParamsSize - this.params.totalSize() + index2;
        }
        return new RemapInfo(StackValue.local(remappedIndex + this.additionalShift, AsmTypeConstants.OBJECT_TYPE), null, RemapStatus.SHIFT);
    }

    public RemapInfo remap(int index2) {
        RemapInfo info = this.doRemap(index2);
        if (RemapStatus.FAIL == info.status) {
            assert (info.parameterInfo != null) : "Parameter info should be not null";
            throw new RuntimeException("Trying to access skipped parameter: " + info.parameterInfo.type + " at " + index2);
        }
        return info;
    }

    public void visitIincInsn(int var, int increment, MethodVisitor mv) {
        RemapInfo remap = this.remap(var);
        assert (remap.value instanceof StackValue.Local);
        mv.visitIincInsn(((StackValue.Local)remap.value).index, increment);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index2, MethodVisitor mv) {
        RemapInfo info = this.doRemap(index2);
        if (RemapStatus.SHIFT == info.status) {
            mv.visitLocalVariable(name, desc, signature, start, end, ((StackValue.Local)info.value).index);
        }
    }

    public void visitVarInsn(int opcode, int var, InstructionAdapter mv) {
        RemapInfo remapInfo = this.remap(var);
        StackValue value = remapInfo.value;
        if (value instanceof StackValue.Local) {
            if (remapInfo.parameterInfo != null) {
                opcode = value.type.getOpcode(21);
            }
            mv.visitVarInsn(opcode, ((StackValue.Local)value).index);
            if (remapInfo.parameterInfo != null) {
                StackValue.coerce(value.type, remapInfo.parameterInfo.type, mv);
            }
        } else {
            assert (remapInfo.parameterInfo != null) : "Non local value should have parameter info";
            value.put(remapInfo.parameterInfo.type, mv);
        }
    }

    private static class RemapInfo {
        public final StackValue value;
        public final ParameterInfo parameterInfo;
        public final RemapStatus status;

        public RemapInfo(@NotNull StackValue value, @Nullable ParameterInfo info, RemapStatus remapStatus) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/codegen/inline/LocalVarRemapper$RemapInfo", "<init>"));
            }
            this.value = value;
            this.parameterInfo = info;
            this.status = remapStatus;
        }

        public RemapInfo(@NotNull ParameterInfo info) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/jet/codegen/inline/LocalVarRemapper$RemapInfo", "<init>"));
            }
            this.value = null;
            this.parameterInfo = info;
            this.status = RemapStatus.FAIL;
        }
    }

    public static enum RemapStatus {
        SHIFT,
        REMAPPED,
        FAIL;

    }
}

