/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.FunctionCodegen;
import org.jetbrains.jet.codegen.MemberCodegen;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.SamType;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.SourceElement;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.impl.ClassDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.java.descriptor.JavaClassDescriptor;
import org.jetbrains.jet.lang.resolve.java.diagnostics.DiagnosticsPackage;
import org.jetbrains.jet.lang.resolve.kotlin.PackagePartClassUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class SamWrapperCodegen {
    private final GenerationState state;
    private final JetTypeMapper typeMapper;
    private final SamType samType;
    private final MemberCodegen<?> parentCodegen;

    public SamWrapperCodegen(@NotNull GenerationState state, @NotNull SamType samType, @NotNull MemberCodegen<?> parentCodegen) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/SamWrapperCodegen", "<init>"));
        }
        if (samType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "samType", "org/jetbrains/jet/codegen/SamWrapperCodegen", "<init>"));
        }
        if (parentCodegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCodegen", "org/jetbrains/jet/codegen/SamWrapperCodegen", "<init>"));
        }
        this.state = state;
        this.typeMapper = state.getTypeMapper();
        this.samType = samType;
        this.parentCodegen = parentCodegen;
    }

    public Type genWrapper(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/codegen/SamWrapperCodegen", "genWrapper"));
        }
        FqName fqName2 = this.getWrapperName(file);
        Type asmType = AsmUtil.asmTypeByFqNameWithoutInnerClasses(fqName2);
        JetType functionType = this.samType.getKotlinFunctionType();
        ClassDescriptorImpl classDescriptor = new ClassDescriptorImpl(this.samType.getJavaClassDescriptor().getContainingDeclaration(), fqName2.shortName(), Modality.FINAL, Collections.singleton(this.samType.getType()), SourceElement.NO_SOURCE);
        SimpleFunctionDescriptor erasedInterfaceFunction = this.samType.getAbstractMethod().getOriginal().copy(classDescriptor, Modality.FINAL, Visibilities.PUBLIC, CallableMemberDescriptor.Kind.SYNTHESIZED, false);
        ClassBuilder cv = this.state.getFactory().newVisitor(DiagnosticsPackage.OtherOrigin(erasedInterfaceFunction), asmType, file);
        cv.defineClass(file, 50, 16, asmType.getInternalName(), null, AsmTypeConstants.OBJECT_TYPE.getInternalName(), new String[]{this.typeMapper.mapType(this.samType.getType()).getInternalName()});
        cv.visitSource(file.getName(), null);
        AsmUtil.writeKotlinSyntheticClassAnnotation(cv, JvmAnnotationNames.KotlinSyntheticClass.Kind.SAM_WRAPPER);
        Type functionAsmType = this.typeMapper.mapType(functionType);
        cv.newField(DiagnosticsPackage.OtherOrigin(erasedInterfaceFunction), 4114, "function", functionAsmType.getDescriptor(), null, null);
        this.generateConstructor(asmType, functionAsmType, cv);
        this.generateMethod(asmType, functionAsmType, cv, erasedInterfaceFunction, functionType);
        cv.done();
        return asmType;
    }

    private void generateConstructor(Type ownerType, Type functionType, ClassBuilder cv) {
        MethodVisitor mv = cv.newMethod(DiagnosticsPackage.OtherOrigin(this.samType.getJavaClassDescriptor()), 0, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, functionType), null, null);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            mv.visitCode();
            InstructionAdapter iv = new InstructionAdapter(mv);
            iv.load(0, AsmTypeConstants.OBJECT_TYPE);
            iv.invokespecial(AsmTypeConstants.OBJECT_TYPE.getInternalName(), "<init>", "()V", false);
            iv.load(0, AsmTypeConstants.OBJECT_TYPE);
            iv.load(1, functionType);
            iv.putfield(ownerType.getInternalName(), "function", functionType.getDescriptor());
            iv.visitInsn(177);
            FunctionCodegen.endVisit(iv, "constructor of SAM wrapper", null);
        }
    }

    private void generateMethod(Type ownerType, Type functionType, ClassBuilder cv, SimpleFunctionDescriptor erasedInterfaceFunction, JetType functionJetType) {
        FunctionCodegen codegen = new FunctionCodegen(CodegenContext.STATIC.intoClass((ClassDescriptor)erasedInterfaceFunction.getContainingDeclaration(), OwnerKind.IMPLEMENTATION, this.state), cv, this.state, this.parentCodegen);
        FunctionDescriptor invokeFunction = functionJetType.getMemberScope().getFunctions(Name.identifier("invoke")).iterator().next().getOriginal();
        StackValue.Field functionField = StackValue.field(functionType, ownerType, "function", false, StackValue.none());
        codegen.genDelegate(erasedInterfaceFunction, invokeFunction, functionField);
        SimpleFunctionDescriptor originalInterfaceErased = this.samType.getAbstractMethod().getOriginal();
        SimpleFunctionDescriptorImpl descriptorForBridges = SimpleFunctionDescriptorImpl.create(erasedInterfaceFunction.getContainingDeclaration(), erasedInterfaceFunction.getAnnotations(), originalInterfaceErased.getName(), CallableMemberDescriptor.Kind.DECLARATION, erasedInterfaceFunction.getSource());
        descriptorForBridges.initialize((JetType)null, originalInterfaceErased.getDispatchReceiverParameter(), originalInterfaceErased.getTypeParameters(), (List)originalInterfaceErased.getValueParameters(), originalInterfaceErased.getReturnType(), Modality.OPEN, originalInterfaceErased.getVisibility());
        descriptorForBridges.addOverriddenDescriptor(originalInterfaceErased);
        codegen.generateBridges(descriptorForBridges);
    }

    @NotNull
    private FqName getWrapperName(@NotNull JetFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/jet/codegen/SamWrapperCodegen", "getWrapperName"));
        }
        FqName packageClassFqName = PackageClassUtils.getPackageClassFqName(containingFile.getPackageFqName());
        JavaClassDescriptor descriptor = this.samType.getJavaClassDescriptor();
        int hash = PackagePartClassUtils.getPathHashCode(containingFile.getVirtualFile()) * 31 + DescriptorUtils.getFqNameSafe(descriptor).hashCode();
        String shortName = String.format("%s$sam$%s$%08x", packageClassFqName.shortName().asString(), descriptor.getName().asString(), hash);
        FqName fqName2 = packageClassFqName.parent().child(Name.identifier(shortName));
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/SamWrapperCodegen", "getWrapperName"));
        }
        return fqName2;
    }
}

